/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.handshake;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.ExchangeHandshakeRequest;
import io.undertow.websockets.jsr.handshake.ExchangeHandshakeResponse;
import io.undertow.websockets.jsr.handshake.PerConnectionConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.PerConnectionServerEndpointConfig;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerEndpointConfig;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class HandshakeUtil {
    private static final String CONFIG_KEY = "ServerEndpointConfiguration";
    private static final AttachmentKey<ServerEndpointConfig> PER_SESSION_CONFIG = AttachmentKey.create(ServerEndpointConfig.class);
    public static final AttachmentKey<Map<String, String>> PATH_PARAMS = AttachmentKey.create(Map.class);
    public static final AttachmentKey<Principal> PRINCIPAL = AttachmentKey.create(Principal.class);

    private HandshakeUtil() {
    }

    public static boolean checkOrigin(ServerEndpointConfig config, WebSocketHttpExchange exchange) {
        ServerEndpointConfig.Configurator c = config.getConfigurator();
        return c.checkOrigin(exchange.getRequestHeader("Origin"));
    }

    public static void prepareUpgrade(ServerEndpointConfig config, WebSocketHttpExchange exchange) {
        PerConnectionServerEndpointConfig perSessionConfig = new PerConnectionServerEndpointConfig(config);
        exchange.putAttachment(PER_SESSION_CONFIG, perSessionConfig);
        ExchangeHandshakeRequest request = new ExchangeHandshakeRequest(exchange);
        ExchangeHandshakeResponse response = new ExchangeHandshakeResponse(exchange);
        ServerEndpointConfig.Configurator c = perSessionConfig.getConfigurator();
        c.modifyHandshake(perSessionConfig, request, response);
        response.update();
    }

    public static void setConfig(WebSocketChannel channel, ConfiguredServerEndpoint config, WebSocketHttpExchange exchange) {
        ServerEndpointConfig perSessionConfig = exchange.getAttachment(PER_SESSION_CONFIG);
        channel.setAttribute(CONFIG_KEY, new PerConnectionConfiguredServerEndpoint(config, perSessionConfig));
    }

    @Deprecated
    public static void setConfig(WebSocketChannel channel, ConfiguredServerEndpoint config) {
        channel.setAttribute(CONFIG_KEY, config);
    }

    public static ConfiguredServerEndpoint getConfig(WebSocketChannel channel) {
        return (ConfiguredServerEndpoint)channel.getAttribute(CONFIG_KEY);
    }

    public static void propagate(HttpServerExchange source, ServletWebSocketHttpExchange target) {
        ServerEndpointConfig perSession = source.getAttachment(PER_SESSION_CONFIG);
        target.putAttachment(PER_SESSION_CONFIG, perSession);
    }

    static String selectSubProtocol(ConfiguredServerEndpoint config, String[] requestedSubprotocolArray) {
        if (config.getEndpointConfiguration().getConfigurator() != null) {
            return config.getEndpointConfiguration().getConfigurator().getNegotiatedSubprotocol(config.getEndpointConfiguration().getSubprotocols(), Arrays.asList(requestedSubprotocolArray));
        }
        for (String protocol : config.getEndpointConfiguration().getSubprotocols()) {
            for (String clientsupported : requestedSubprotocolArray) {
                if (!protocol.equals(clientsupported)) continue;
                return protocol;
            }
        }
        return null;
    }

    static List<Extension> selectExtensions(ConfiguredServerEndpoint config, List<Extension> requestedExtensions) {
        if (config.getEndpointConfiguration().getConfigurator() != null) {
            return config.getEndpointConfiguration().getConfigurator().getNegotiatedExtensions(config.getExtensions(), requestedExtensions);
        }
        return Collections.emptyList();
    }
}

