/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELException;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.ServiceLoader;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String className, ClassLoader classLoader, Properties properties2) {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            if (properties2 != null) {
                Constructor<?> constr = null;
                try {
                    constr = spiClass.getConstructor(Properties.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (constr != null) {
                    return constr.newInstance(properties2);
                }
            }
            return spiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw new ELException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ELException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(Class<?> serviceClass, String factoryId, String fallbackClassName, Properties properties2) {
        ClassLoader classLoader;
        block23: {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception x) {
                throw new ELException(x.toString(), x);
            }
            try {
                ServiceLoader<?> serviceLoader = ServiceLoader.load(serviceClass, classLoader);
                for (Object service : serviceLoader) {
                    if (service == null) continue;
                    return service;
                }
            }
            catch (Exception serviceLoader) {
                // empty catch block
            }
            try {
                String javah = System.getProperty("java.home");
                String configFileName = javah + File.separator + "lib" + File.separator + "el.properties";
                File configFile = new File(configFileName);
                if (!configFile.exists()) break block23;
                Properties props = new Properties();
                try (FileInputStream propertiesStream = new FileInputStream(configFile);){
                    props.load(propertiesStream);
                }
                String factoryClassName = props.getProperty(factoryId);
                return FactoryFinder.newInstance(factoryClassName, classLoader, properties2);
            }
            catch (Exception javah) {
                // empty catch block
            }
        }
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader, properties2);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new ELException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader, properties2);
    }
}

