/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.ConstraintHelper;

public class TypeCheck
extends AbstractConstraintCheck {
    private final ConstraintHelper constraintHelper;
    private final Types typeUtils;
    private final AnnotationApiHelper annotationApiHelper;

    public TypeCheck(ConstraintHelper constraintHelper, Types typeUtils, AnnotationApiHelper annotationApiHelper) {
        this.constraintHelper = constraintHelper;
        this.typeUtils = typeUtils;
        this.annotationApiHelper = annotationApiHelper;
    }

    @Override
    public Set<ConstraintCheckIssue> checkField(VariableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, element.asType(), "NOT_SUPPORTED_TYPE");
    }

    @Override
    public Set<ConstraintCheckIssue> checkMethod(ExecutableElement element, AnnotationMirror annotation) {
        ConstraintHelper.AnnotationProcessorValidationTarget target = ConstraintHelper.AnnotationProcessorValidationTarget.ANNOTATED_ELEMENT;
        if (this.constraintHelper.isConstraintAnnotation(annotation.getAnnotationType().asElement())) {
            target = this.constraintHelper.resolveValidationTarget(element, annotation);
        }
        if (target == ConstraintHelper.AnnotationProcessorValidationTarget.PARAMETERS) {
            return Collections.emptySet();
        }
        return this.checkInternal(element, annotation, element.getReturnType(), "NOT_SUPPORTED_RETURN_TYPE");
    }

    @Override
    public Set<ConstraintCheckIssue> checkNonAnnotationType(TypeElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, element.asType(), "NOT_SUPPORTED_TYPE");
    }

    private Set<ConstraintCheckIssue> checkInternal(Element element, AnnotationMirror annotation, TypeMirror type2, String messageKey) {
        Optional<TypeMirror> typeToCheck;
        Optional<TypeMirror> optional = typeToCheck = this.usesUnwrapping(annotation, type2) ? this.getUnwrappedType(type2) : Optional.of(type2);
        if (typeToCheck.isPresent()) {
            if (!this.isAnnotationAllowedForType(annotation, typeToCheck.get())) {
                return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, messageKey, annotation.getAnnotationType().asElement().getSimpleName()));
            }
        } else {
            return CollectionHelper.asSet(ConstraintCheckIssue.warning(element, annotation, "NOT_FOUND_UNWRAPPED_TYPE", annotation.getAnnotationType().asElement().getSimpleName()));
        }
        return Collections.emptySet();
    }

    private boolean isAnnotationAllowedForType(AnnotationMirror annotation, TypeMirror type2) {
        return ConstraintHelper.ConstraintCheckResult.ALLOWED.equals((Object)this.constraintHelper.checkConstraint(annotation.getAnnotationType(), type2));
    }

    private boolean usesUnwrapping(AnnotationMirror annotationMirror, TypeMirror typeMirror) {
        AnnotationApiHelper.UnwrapMode mode = this.annotationApiHelper.determineUnwrapMode(annotationMirror);
        if (AnnotationApiHelper.UnwrapMode.SKIP.equals((Object)mode)) {
            return false;
        }
        if (this.constraintHelper.isSupportedForUnwrappingByDefault(this.getQualifiedName(typeMirror))) {
            return true;
        }
        return AnnotationApiHelper.UnwrapMode.UNWRAP.equals((Object)mode);
    }

    private Optional<TypeMirror> getUnwrappedType(TypeMirror type2) {
        return this.constraintHelper.getUnwrappedToByDefault(this.getQualifiedName(type2));
    }

    private Name getQualifiedName(TypeMirror typeMirror) {
        if (TypeKind.DECLARED.equals((Object)typeMirror.getKind())) {
            return ((TypeElement)this.typeUtils.asElement(typeMirror)).getQualifiedName();
        }
        return null;
    }
}

