/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks.annotationparameters;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersAbstractCheck;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class AnnotationParametersPatternCheck
extends AnnotationParametersAbstractCheck {
    public AnnotationParametersPatternCheck(AnnotationApiHelper annotationApiHelper) {
        super(annotationApiHelper, "jakarta.validation.constraints.Pattern");
    }

    @Override
    protected Set<ConstraintCheckIssue> doCheck(Element element, AnnotationMirror annotation) {
        String regexp = (String)this.annotationApiHelper.getAnnotationValue(annotation, "regexp").getValue();
        try {
            Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "INVALID_PATTERN_ANNOTATION_PARAMETERS", new Object[0]));
        }
        return Collections.emptySet();
    }
}

