/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks.annotationparameters;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersAbstractCheck;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class AnnotationPayloadUnwrappingCheck
extends AnnotationParametersAbstractCheck {
    private final Types typeUtils;

    public AnnotationPayloadUnwrappingCheck(AnnotationApiHelper annotationApiHelper, Types typeUtils) {
        super(annotationApiHelper, new String[0]);
        this.typeUtils = typeUtils;
    }

    @Override
    protected boolean canCheckThisAnnotation(AnnotationMirror annotation) {
        return true;
    }

    @Override
    protected Set<ConstraintCheckIssue> doCheck(Element element, AnnotationMirror annotation) {
        List<? extends AnnotationValue> annotationValue = this.annotationApiHelper.getAnnotationArrayValue(annotation, "payload");
        if (annotationValue.stream().map(AnnotationValue::getValue).map(type2 -> (TypeMirror)type2).map(this.typeUtils::asElement).map(elem -> ((TypeElement)elem).getQualifiedName()).filter(name -> name.toString().startsWith("jakarta.validation.valueextraction.Unwrapping.")).distinct().count() > 1L) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "INVALID_PAYLOAD_UNWRAPPING_VALUE_ANNOTATION_PARAMETERS", new Object[0]));
        }
        return Collections.emptySet();
    }
}

