/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.properties.javabean;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.internal.properties.Callable;
import org.hibernate.validator.internal.properties.Signature;
import org.hibernate.validator.internal.properties.javabean.JavaBeanAnnotatedConstrainable;
import org.hibernate.validator.internal.properties.javabean.JavaBeanParameter;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.ReflectionHelper;

public abstract class JavaBeanExecutable<T extends Executable>
implements Callable,
JavaBeanAnnotatedConstrainable {
    protected final T executable;
    private final Type typeForValidatorResolution;
    private final boolean hasReturnValue;
    private final Type type;
    private final List<JavaBeanParameter> parameters;

    JavaBeanExecutable(T executable, boolean hasReturnValue) {
        this.executable = executable;
        this.type = ReflectionHelper.typeOf(executable);
        this.typeForValidatorResolution = ReflectionHelper.boxedType(this.type);
        this.hasReturnValue = hasReturnValue;
        this.parameters = JavaBeanExecutable.getParameters(executable);
    }

    @Override
    public boolean hasReturnValue() {
        return this.hasReturnValue;
    }

    @Override
    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    @Override
    public String getName() {
        return ((Executable)this.executable).getName();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return ((Executable)this.executable).getDeclaringClass();
    }

    @Override
    public Type getTypeForValidatorResolution() {
        return this.typeForValidatorResolution;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getParameterName(ExecutableParameterNameProvider parameterNameProvider, int parameterIndex) {
        return parameterNameProvider.getParameterNames((Executable)this.executable).get(parameterIndex);
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(((Executable)this.executable).getModifiers());
    }

    @Override
    public Signature getSignature() {
        return ExecutableHelper.getSignature(this.executable);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return ((Executable)this.executable).getDeclaredAnnotations();
    }

    @Override
    public boolean overrides(ExecutableHelper executableHelper, Callable superTypeMethod) {
        return executableHelper.overrides((Method)this.executable, (Method)((JavaBeanExecutable)superTypeMethod).executable);
    }

    @Override
    public boolean isResolvedToSameMethodInHierarchy(ExecutableHelper executableHelper, Class<?> mainSubType, Callable superTypeMethod) {
        return executableHelper.isResolvedToSameMethodInHierarchy(mainSubType, (Method)this.executable, (Method)((JavaBeanExecutable)superTypeMethod).executable);
    }

    @Override
    public Type getGenericType() {
        return ReflectionHelper.typeOf(this.executable);
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return ((Executable)this.executable).getAnnotatedReturnType();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return ((Executable)this.executable).getAnnotation(annotationClass);
    }

    public List<JavaBeanParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Type getParameterGenericType(int index) {
        return this.parameters.get(index).getGenericType();
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return ((Executable)this.executable).getParameterTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaBeanExecutable that = (JavaBeanExecutable)o;
        if (this.hasReturnValue != that.hasReturnValue) {
            return false;
        }
        if (!this.executable.equals(that.executable)) {
            return false;
        }
        if (!this.typeForValidatorResolution.equals(that.typeForValidatorResolution)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.executable.hashCode();
        result = 31 * result + this.typeForValidatorResolution.hashCode();
        result = 31 * result + (this.hasReturnValue ? 1 : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return ExecutableHelper.getExecutableAsString(this.getDeclaringClass().getSimpleName() + "#" + ((Executable)this.executable).getName(), ((Executable)this.executable).getParameterTypes());
    }

    private static List<JavaBeanParameter> getParameters(Executable executable) {
        if (executable.getParameterCount() == 0) {
            return Collections.emptyList();
        }
        int parameterCount = executable.getParameterCount();
        ArrayList<JavaBeanParameter> parameters2 = new ArrayList<JavaBeanParameter>(parameterCount);
        Parameter[] parameterArray = executable.getParameters();
        Class<?>[] parameterTypes = executable.getParameterTypes();
        AnnotatedType[] annotatedTypes = executable.getAnnotatedParameterTypes();
        Annotation[][] parameterAnnotationsArray = executable.getParameterAnnotations();
        Annotation[][] annotationsForJDK8303112 = JavaBeanExecutable.recomputeParameterAnnotationsForJDK8303112(parameterArray, parameterAnnotationsArray);
        for (int i = 0; i < parameterArray.length; ++i) {
            parameters2.add(new JavaBeanParameter(i, parameterArray[i], parameterTypes[i], annotatedTypes[i], annotationsForJDK8303112 != null ? annotationsForJDK8303112[i] : null));
        }
        return CollectionHelper.toImmutableList(parameters2);
    }

    private static Annotation[][] recomputeParameterAnnotationsForJDK8303112(Parameter[] parameters2, Annotation[][] parameterAnnotationsArray) {
        int parameterCount = parameters2.length;
        if (parameterAnnotationsArray.length == parameterCount) {
            return null;
        }
        Annotation[][] annotationsForJDK8303112 = new Annotation[parameterCount][];
        int nonImplicitNorSyntheticParamIndex = 0;
        for (int i = 0; i < parameterCount; ++i) {
            Parameter parameter = parameters2[i];
            if (parameter.isImplicit() || parameter.isSynthetic()) {
                annotationsForJDK8303112[i] = new Annotation[0];
                continue;
            }
            if (nonImplicitNorSyntheticParamIndex < parameterAnnotationsArray.length) {
                annotationsForJDK8303112[i] = parameterAnnotationsArray[nonImplicitNorSyntheticParamIndex];
                ++nonImplicitNorSyntheticParamIndex;
                continue;
            }
            nonImplicitNorSyntheticParamIndex = parameterCount - parameterAnnotationsArray.length;
            Arrays.fill((Object[])annotationsForJDK8303112, 0, nonImplicitNorSyntheticParamIndex, new Annotation[0]);
            System.arraycopy(parameterAnnotationsArray, 0, annotationsForJDK8303112, nonImplicitNorSyntheticParamIndex, parameterAnnotationsArray.length);
            return annotationsForJDK8303112;
        }
        return annotationsForJDK8303112;
    }
}

