/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.properties.javabean;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.hibernate.validator.internal.properties.javabean.JavaBeanAnnotatedElement;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;

public class JavaBeanParameter
implements JavaBeanAnnotatedElement {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    static final Annotation[] EMPTY_PARAMETER_ANNOTATIONS = new Annotation[0];
    private final int index;
    private final Parameter parameter;
    private final Class<?> type;
    private final Type genericType;
    private final AnnotatedType annotatedType;
    private final Annotation[] annotationsForJDK8303112;

    JavaBeanParameter(int index, Parameter parameter, Class<?> type2, AnnotatedType annotatedType, Annotation[] annotationsForJDK8303112) {
        this.index = index;
        this.parameter = parameter;
        this.type = type2;
        this.genericType = JavaBeanParameter.getErasedTypeIfTypeVariable(annotatedType.getType());
        this.annotatedType = annotatedType;
        this.annotationsForJDK8303112 = annotationsForJDK8303112;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        try {
            if (this.annotationsForJDK8303112 != null) {
                return (Annotation[])this.annotationsForJDK8303112.clone();
            }
            return this.parameter.getDeclaredAnnotations();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            LOG.warn(Messages.MESSAGES.constraintOnConstructorOfNonStaticInnerClass(), ex);
            return EMPTY_PARAMETER_ANNOTATIONS;
        }
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public TypeVariable<?>[] getTypeParameters() {
        return this.type.getTypeParameters();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        if (this.annotationsForJDK8303112 != null) {
            for (Annotation annotation : this.annotationsForJDK8303112) {
                if (!annotationClass.isAssignableFrom(annotation.annotationType())) continue;
                Annotation castAnnotation = annotation;
                return (A)castAnnotation;
            }
            return null;
        }
        return this.parameter.getAnnotation(annotationClass);
    }

    private static Type getErasedTypeIfTypeVariable(Type genericType) {
        if (genericType instanceof TypeVariable) {
            return TypeHelper.getErasedType(genericType);
        }
        return genericType;
    }
}

