/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class ReflectionHelper {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPES;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPES;

    private ReflectionHelper() {
    }

    public static Type typeOf(Member member) {
        Type type2;
        if (member instanceof Field) {
            type2 = ((Field)member).getGenericType();
        } else if (member instanceof Method) {
            type2 = ((Method)member).getGenericReturnType();
        } else if (member instanceof Constructor) {
            type2 = member.getDeclaringClass();
        } else {
            throw LOG.getMemberIsNeitherAFieldNorAMethodException(member);
        }
        if (type2 instanceof TypeVariable) {
            type2 = TypeHelper.getErasedType(type2);
        }
        return type2;
    }

    public static Object getValue(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw LOG.getUnableToAccessMemberException(field.getName(), e);
        }
    }

    public static Object getValue(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw LOG.getUnableToAccessMemberException(method.getName(), e);
        }
    }

    public static boolean isCollection(Type type2) {
        return ReflectionHelper.isIterable(type2) || ReflectionHelper.isMap(type2) || TypeHelper.isArray(type2);
    }

    public static Type getCollectionElementType(Type type2) {
        Type indexedType = null;
        if (ReflectionHelper.isIterable(type2) && type2 instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type2;
            indexedType = paramType.getActualTypeArguments()[0];
        } else if (ReflectionHelper.isMap(type2) && type2 instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type2;
            indexedType = paramType.getActualTypeArguments()[1];
        } else if (TypeHelper.isArray(type2)) {
            indexedType = TypeHelper.getComponentType(type2);
        }
        return indexedType;
    }

    public static boolean isIndexable(Type type2) {
        return ReflectionHelper.isList(type2) || ReflectionHelper.isMap(type2) || TypeHelper.isArray(type2);
    }

    public static Class<?> getClassFromType(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            return ReflectionHelper.getClassFromType(((ParameterizedType)type2).getRawType());
        }
        if (type2 instanceof GenericArrayType) {
            return Object[].class;
        }
        throw LOG.getUnableToConvertTypeToClassException(type2);
    }

    public static boolean isIterable(Type type2) {
        if (type2 instanceof Class && Iterable.class.isAssignableFrom((Class)type2)) {
            return true;
        }
        if (type2 instanceof ParameterizedType) {
            return ReflectionHelper.isIterable(((ParameterizedType)type2).getRawType());
        }
        if (type2 instanceof WildcardType) {
            Type[] upperBounds2 = ((WildcardType)type2).getUpperBounds();
            return upperBounds2.length != 0 && ReflectionHelper.isIterable(upperBounds2[0]);
        }
        return false;
    }

    public static boolean isMap(Type type2) {
        if (type2 instanceof Class && Map.class.isAssignableFrom((Class)type2)) {
            return true;
        }
        if (type2 instanceof ParameterizedType) {
            return ReflectionHelper.isMap(((ParameterizedType)type2).getRawType());
        }
        if (type2 instanceof WildcardType) {
            Type[] upperBounds2 = ((WildcardType)type2).getUpperBounds();
            return upperBounds2.length != 0 && ReflectionHelper.isMap(upperBounds2[0]);
        }
        return false;
    }

    public static boolean isList(Type type2) {
        if (type2 instanceof Class && List.class.isAssignableFrom((Class)type2)) {
            return true;
        }
        if (type2 instanceof ParameterizedType) {
            return ReflectionHelper.isList(((ParameterizedType)type2).getRawType());
        }
        if (type2 instanceof WildcardType) {
            Type[] upperBounds2 = ((WildcardType)type2).getUpperBounds();
            return upperBounds2.length != 0 && ReflectionHelper.isList(upperBounds2[0]);
        }
        return false;
    }

    public static Object getIndexedValue(Object value, int index) {
        Iterable<?> iterable;
        if (value == null) {
            return null;
        }
        Class<?> type2 = value.getClass();
        if (ReflectionHelper.isIterable(type2)) {
            iterable = (Iterable<?>)value;
        } else if (TypeHelper.isArray(type2)) {
            iterable = CollectionHelper.iterableFromArray(value);
        } else {
            return null;
        }
        int i = 0;
        for (Object o : iterable) {
            if (i == index) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public static Object getMappedValue(Object value, Object key) {
        if (!(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        return map.get(key);
    }

    private static Class<?> internalBoxedType(Class<?> primitiveType) {
        Class<?> wrapperType = PRIMITIVE_TO_WRAPPER_TYPES.get(primitiveType);
        if (wrapperType == null) {
            throw LOG.getHasToBeAPrimitiveTypeException(primitiveType.getClass());
        }
        return wrapperType;
    }

    public static Type boxedType(Type type2) {
        if (type2 instanceof Class && ((Class)type2).isPrimitive()) {
            return ReflectionHelper.internalBoxedType((Class)type2);
        }
        return type2;
    }

    public static Class<?> boxedType(Class<?> type2) {
        if (type2.isPrimitive()) {
            return ReflectionHelper.internalBoxedType(type2);
        }
        return type2;
    }

    public static Class<?> unBoxedType(Class<?> type2) {
        Class<?> wrapperType = WRAPPER_TO_PRIMITIVE_TYPES.get(type2);
        if (wrapperType == null) {
            throw LOG.getHasToBeABoxedTypeException(type2.getClass());
        }
        return wrapperType;
    }

    static {
        HashMap<Class<Object>, Class<Object>> tmpMap = CollectionHelper.newHashMap(9);
        tmpMap.put(Boolean.TYPE, Boolean.class);
        tmpMap.put(Character.TYPE, Character.class);
        tmpMap.put(Double.TYPE, Double.class);
        tmpMap.put(Float.TYPE, Float.class);
        tmpMap.put(Long.TYPE, Long.class);
        tmpMap.put(Integer.TYPE, Integer.class);
        tmpMap.put(Short.TYPE, Short.class);
        tmpMap.put(Byte.TYPE, Byte.class);
        tmpMap.put(Void.TYPE, Void.TYPE);
        PRIMITIVE_TO_WRAPPER_TYPES = Collections.unmodifiableMap(tmpMap);
        tmpMap = CollectionHelper.newHashMap(9);
        tmpMap.put(Boolean.class, Boolean.TYPE);
        tmpMap.put(Character.class, Character.TYPE);
        tmpMap.put(Double.class, Double.TYPE);
        tmpMap.put(Float.class, Float.TYPE);
        tmpMap.put(Long.class, Long.TYPE);
        tmpMap.put(Integer.class, Integer.TYPE);
        tmpMap.put(Short.class, Short.TYPE);
        tmpMap.put(Byte.class, Byte.TYPE);
        tmpMap.put(Void.TYPE, Void.TYPE);
        WRAPPER_TO_PRIMITIVE_TYPES = Collections.unmodifiableMap(tmpMap);
    }
}

