/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.cpu;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Locale;
import org.wildfly.common.cpu.CacheLevelInfo;
import org.wildfly.common.cpu.CacheType;

public final class CacheInfo {
    private static final CacheLevelInfo[] cacheLevels = AccessController.doPrivileged(() -> {
        try {
            String osArch = System.getProperty("os.name", "unknown").toLowerCase(Locale.US);
            if (osArch.contains("linux")) {
                File[] files;
                File cpu0 = new File("/sys/devices/system/cpu/cpu0/cache");
                if (!cpu0.exists() || (files = cpu0.listFiles()) == null) return new CacheLevelInfo[0];
                ArrayList<File> indexes = new ArrayList<File>();
                for (File file : files) {
                    if (!file.getName().startsWith("index")) continue;
                    indexes.add(file);
                }
                CacheLevelInfo[] levelInfoArray = new CacheLevelInfo[indexes.size()];
                for (int i = 0; i < indexes.size(); ++i) {
                    CacheType type2;
                    File file = (File)indexes.get(i);
                    int index = CacheInfo.parseIntFile(new File(file, "level"));
                    switch (CacheInfo.parseStringFile(new File(file, "type"))) {
                        case "Data": {
                            type2 = CacheType.DATA;
                            break;
                        }
                        case "Instruction": {
                            type2 = CacheType.INSTRUCTION;
                            break;
                        }
                        case "Unified": {
                            type2 = CacheType.UNIFIED;
                            break;
                        }
                        default: {
                            type2 = CacheType.UNKNOWN;
                        }
                    }
                    int size = CacheInfo.parseIntKBFile(new File(file, "size"));
                    int lineSize = CacheInfo.parseIntFile(new File(file, "coherency_line_size"));
                    levelInfoArray[i] = new CacheLevelInfo(index, type2, size, lineSize);
                }
                return levelInfoArray;
            }
            if (osArch.contains("mac os x")) {
                int lineSize = CacheInfo.safeParseInt(CacheInfo.parseProcessOutput("/usr/sbin/sysctl", "-n", "hw.cachelinesize"));
                if (lineSize == 0) return new CacheLevelInfo[0];
                int l1d = CacheInfo.safeParseInt(CacheInfo.parseProcessOutput("/usr/sbin/sysctl", "-n", "hw.l1dcachesize"));
                int l1i = CacheInfo.safeParseInt(CacheInfo.parseProcessOutput("/usr/sbin/sysctl", "-n", "hw.l1icachesize"));
                int l2 = CacheInfo.safeParseInt(CacheInfo.parseProcessOutput("/usr/sbin/sysctl", "-n", "hw.l2cachesize"));
                int l3 = CacheInfo.safeParseInt(CacheInfo.parseProcessOutput("/usr/sbin/sysctl", "-n", "hw.l3cachesize"));
                ArrayList<CacheLevelInfo> list = new ArrayList<CacheLevelInfo>();
                if (l1d != 0) {
                    list.add(new CacheLevelInfo(1, CacheType.DATA, l1d / 1024, lineSize));
                }
                if (l1i != 0) {
                    list.add(new CacheLevelInfo(1, CacheType.INSTRUCTION, l1i / 1024, lineSize));
                }
                if (l2 != 0) {
                    list.add(new CacheLevelInfo(2, CacheType.UNIFIED, l2 / 1024, lineSize));
                }
                if (l3 != 0) {
                    list.add(new CacheLevelInfo(3, CacheType.UNIFIED, l3 / 1024, lineSize));
                }
                if (list.size() <= 0) return new CacheLevelInfo[0];
                return list.toArray(new CacheLevelInfo[list.size()]);
            }
            if (!osArch.contains("windows")) return new CacheLevelInfo[0];
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new CacheLevelInfo[0];
    });

    public static int getLevelEntryCount() {
        return cacheLevels.length;
    }

    public static CacheLevelInfo getCacheLevelInfo(int index) {
        return cacheLevels[index];
    }

    public static int getSmallestDataCacheLineSize() {
        int minSize = Integer.MAX_VALUE;
        for (CacheLevelInfo cacheLevel : cacheLevels) {
            int cacheLineSize;
            if (!cacheLevel.getCacheType().isData() || (cacheLineSize = cacheLevel.getCacheLineSize()) == 0 || cacheLineSize >= minSize) continue;
            minSize = cacheLineSize;
        }
        return minSize == Integer.MAX_VALUE ? 0 : minSize;
    }

    public static int getSmallestInstructionCacheLineSize() {
        int minSize = Integer.MAX_VALUE;
        for (CacheLevelInfo cacheLevel : cacheLevels) {
            int cacheLineSize;
            if (!cacheLevel.getCacheType().isInstruction() || (cacheLineSize = cacheLevel.getCacheLineSize()) == 0 || cacheLineSize >= minSize) continue;
            minSize = cacheLineSize;
        }
        return minSize == Integer.MAX_VALUE ? 0 : minSize;
    }

    static int parseIntFile(File file) {
        return CacheInfo.safeParseInt(CacheInfo.parseStringFile(file));
    }

    static int safeParseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    static int parseIntKBFile(File file) {
        try {
            String s = CacheInfo.parseStringFile(file);
            if (s.endsWith("K")) {
                return Integer.parseInt(s.substring(0, s.length() - 1));
            }
            if (s.endsWith("M")) {
                return Integer.parseInt(s.substring(0, s.length() - 1)) * 1024;
            }
            if (s.endsWith("G")) {
                return Integer.parseInt(s.substring(0, s.length() - 1)) * 1024 * 1024;
            }
            return Integer.parseInt(s);
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    static String parseStringFile(File file) {
        String string;
        FileInputStream is = new FileInputStream(file);
        try {
            string = CacheInfo.parseStringStream(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable ignored) {
                return "";
            }
        }
        is.close();
        return string;
    }

    static String parseStringStream(InputStream is) {
        String string;
        InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);
        try {
            int res;
            StringBuilder b = new StringBuilder();
            char[] cb = new char[64];
            while ((res = r.read(cb)) != -1) {
                b.append(cb, 0, res);
            }
            string = b.toString().trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable ignored) {
                return "";
            }
        }
        ((Reader)r).close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String parseProcessOutput(String ... args2) {
        ProcessBuilder processBuilder = new ProcessBuilder(args2);
        try {
            String result;
            Process process = processBuilder.start();
            process.getOutputStream().close();
            InputStream errorStream = process.getErrorStream();
            Thread errorThread = new Thread(null, new StreamConsumer(errorStream), "Process thread", 32768L);
            errorThread.start();
            try (InputStream inputStream = process.getInputStream();){
                result = CacheInfo.parseStringStream(inputStream);
            }
            boolean intr = false;
            try {
                process.waitFor();
                return result;
            }
            catch (InterruptedException e) {
                intr = true;
                String string = null;
                return string;
            }
            finally {
                try {
                    errorThread.join();
                }
                catch (InterruptedException e4) {
                    intr = true;
                }
                finally {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        catch (IOException e3) {
            return "";
        }
    }

    public static void main(String[] args2) {
        System.out.println("Detected cache info:");
        for (CacheLevelInfo levelInfo : cacheLevels) {
            System.out.printf("Level %d cache: type %s, size %d KiB, cache line is %d bytes%n", new Object[]{levelInfo.getCacheLevel(), levelInfo.getCacheType(), levelInfo.getCacheLevelSizeKB(), levelInfo.getCacheLineSize()});
        }
    }

    static class StreamConsumer
    implements Runnable {
        private final InputStream stream;

        StreamConsumer(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[128];
            try {
                while (this.stream.read(buffer) != -1) {
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

