/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.wildfly.common.Assert;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.channels.AcceptListenerSettable;
import org.xnio.channels.AcceptingChannel;
import org.xnio.nio.AbstractNioChannel;
import org.xnio.nio.NioSocketStreamConnection;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.WorkerThread;

final class QueuedNioTcpServer2
extends AbstractNioChannel<QueuedNioTcpServer2>
implements AcceptingChannel<StreamConnection>,
AcceptListenerSettable<QueuedNioTcpServer2> {
    private final NioTcpServer realServer;
    private final List<Queue<StreamConnection>> acceptQueues;
    private final Runnable acceptTask = this::acceptTask;
    private volatile ChannelListener<? super QueuedNioTcpServer2> acceptListener;

    QueuedNioTcpServer2(NioTcpServer realServer) {
        super(realServer.getWorker());
        this.realServer = realServer;
        NioXnioWorker worker = realServer.getWorker();
        int cnt = worker.getIoThreadCount();
        this.acceptQueues = new ArrayList<Queue<StreamConnection>>(cnt);
        for (int i = 0; i < cnt; ++i) {
            this.acceptQueues.add(new LinkedBlockingQueue());
        }
        realServer.getCloseSetter().set(ignored -> this.invokeCloseHandler());
        realServer.getAcceptSetter().set(ignored -> this.handleReady());
    }

    @Override
    public StreamConnection accept() throws IOException {
        WorkerThread current = WorkerThread.getCurrent();
        if (current == null) {
            return null;
        }
        Queue<StreamConnection> socketChannels = this.acceptQueues.get(current.getNumber());
        StreamConnection connection = socketChannels.poll();
        if (connection == null && !this.realServer.isOpen()) {
            throw new ClosedChannelException();
        }
        return connection;
    }

    @Override
    public ChannelListener<? super QueuedNioTcpServer2> getAcceptListener() {
        return this.acceptListener;
    }

    @Override
    public void setAcceptListener(ChannelListener<? super QueuedNioTcpServer2> listener) {
        this.acceptListener = listener;
    }

    @Override
    public ChannelListener.Setter<QueuedNioTcpServer2> getAcceptSetter() {
        return new AcceptListenerSettable.Setter<QueuedNioTcpServer2>(this);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.realServer.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type2) {
        return this.realServer.getLocalAddress(type2);
    }

    @Override
    public void suspendAccepts() {
        this.realServer.suspendAccepts();
    }

    @Override
    public void resumeAccepts() {
        this.realServer.resumeAccepts();
    }

    @Override
    public boolean isAcceptResumed() {
        return this.realServer.isAcceptResumed();
    }

    @Override
    public void wakeupAccepts() {
        this.realServer.wakeupAccepts();
    }

    @Override
    public void awaitAcceptable() {
        throw Assert.unsupported();
    }

    @Override
    public void awaitAcceptable(long time, TimeUnit timeUnit) {
        throw Assert.unsupported();
    }

    @Override
    @Deprecated
    public XnioExecutor getAcceptThread() {
        return this.getIoThread();
    }

    @Override
    public void close() throws IOException {
        this.realServer.close();
    }

    @Override
    public boolean isOpen() {
        return this.realServer.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.realServer.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.realServer.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.realServer.setOption(option, value);
    }

    void handleReady() {
        NioSocketStreamConnection connection;
        NioTcpServer realServer = this.realServer;
        try {
            connection = realServer.accept();
        }
        catch (ClosedChannelException e) {
            return;
        }
        if (connection != null) {
            int i = 0;
            Runnable acceptTask = this.acceptTask;
            do {
                XnioIoThread thread2 = connection.getIoThread();
                this.acceptQueues.get(thread2.getNumber()).add(connection);
                thread2.execute(acceptTask);
                if (++i == 128) {
                    return;
                }
                try {
                    connection = realServer.accept();
                }
                catch (ClosedChannelException e) {
                    return;
                }
            } while (connection != null);
        }
    }

    void acceptTask() {
        WorkerThread current = WorkerThread.getCurrent();
        assert (current != null);
        Queue<StreamConnection> queue = this.acceptQueues.get(current.getNumber());
        ChannelListeners.invokeChannelListener(this, this.getAcceptListener());
        if (!queue.isEmpty()) {
            current.execute(this.acceptTask);
        }
    }
}

