/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.MemoizingFunction;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public class DefaultMemoizingFunction<K, V>
implements MemoizingFunction<K, V> {
    private static final Entry nullValue = new Entry(null);
    private final ConcurrentHashMap<Object, Entry> map = new ConcurrentHashMap();
    private final Function<K, V> delegate;
    private final Duration lifespan;
    private final Supplier<Clock> clock;

    public DefaultMemoizingFunction(Function<K, V> delegate) {
        this(delegate, null, null);
    }

    @Override
    public V apply(K key) {
        Entry result = this.map.compute(Optional.ofNullable(key).orElse(nullValue), (k, v) -> v == null || v.expiry != null && v.expiry.isBefore(this.clock.get().instant()) ? Optional.ofNullable(this.delegate.apply(k == nullValue ? null : key)).map(value -> new Entry(value, this.lifespan == null ? null : this.clock.get().instant().plus(this.lifespan))).orElse(nullValue) : v);
        return (V)result.getValue();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V remove(K key) {
        return (V)Optional.ofNullable(this.map.remove(key)).map(Entry::getValue);
    }

    @Override
    public boolean isCached(K key) {
        return key == null || this.map.containsKey(key);
    }

    @Override
    public void forEach(Consumer<? super V> consumer) {
        this.map.values().forEach((? super T e) -> consumer.accept((Object)e.getValue()));
    }

    @ConstructorProperties(value={"delegate", "lifespan", "clock"})
    @Generated
    public DefaultMemoizingFunction(Function<K, V> delegate, Duration lifespan, Supplier<Clock> clock) {
        this.delegate = delegate;
        this.lifespan = lifespan;
        this.clock = clock;
    }

    static final class Entry {
        private final Object value;
        private final Instant expiry;

        Entry(Object value) {
            this(value, null);
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public Instant getExpiry() {
            return this.expiry;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Instant this$expiry = this.getExpiry();
            Instant other$expiry = other.getExpiry();
            return !(this$expiry == null ? other$expiry != null : !((Object)this$expiry).equals(other$expiry));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Instant $expiry = this.getExpiry();
            result = result * 59 + ($expiry == null ? 43 : ((Object)$expiry).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultMemoizingFunction.Entry(value=" + String.valueOf(this.getValue()) + ", expiry=" + String.valueOf(this.getExpiry()) + ")";
        }

        @ConstructorProperties(value={"value", "expiry"})
        @Generated
        public Entry(Object value, Instant expiry) {
            this.value = value;
            this.expiry = expiry;
        }
    }
}

