/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.RetryStatus;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryConfiguration.class);
    private final Duration delay;
    private final int maxRetries;
    private final Predicate<Exception> errorTest;
    private final boolean throwOnFailingErrorTest;
    private final Consumer<RetryStatus> successLogger;
    private final Consumer<RetryStatus> exceptionLogger;
    private final Function<Throwable, ?> errorMapper;

    @Generated
    private static Duration $default$delay() {
        return Duration.ofSeconds(1L);
    }

    @Generated
    private static int $default$maxRetries() {
        return -1;
    }

    @Generated
    private static Predicate<Exception> $default$errorTest() {
        return e -> true;
    }

    @Generated
    private static boolean $default$throwOnFailingErrorTest() {
        return false;
    }

    @Generated
    private static Consumer<RetryStatus> $default$successLogger() {
        return status -> log.info("Task {} completed successfully on retry", status.getTask());
    }

    @Generated
    private static Consumer<RetryStatus> $default$exceptionLogger() {
        return status -> {
            if (status.getNumberOfTimesRetried() == 0) {
                log.error("Task {} failed. Retrying every {} ms...", status.getTask(), status.getRetryConfiguration().getDelay().toMillis(), status.getException());
            } else if (status.getNumberOfTimesRetried() >= status.getRetryConfiguration().getMaxRetries()) {
                log.error("Task {} failed permanently. Not retrying.", status.getTask(), (Object)status.getException());
            }
        };
    }

    @Generated
    private static Function<Throwable, ?> $default$errorMapper() {
        return e -> e;
    }

    @ConstructorProperties(value={"delay", "maxRetries", "errorTest", "throwOnFailingErrorTest", "successLogger", "exceptionLogger", "errorMapper"})
    @Generated
    RetryConfiguration(Duration delay, int maxRetries, Predicate<Exception> errorTest, boolean throwOnFailingErrorTest, Consumer<RetryStatus> successLogger, Consumer<RetryStatus> exceptionLogger, Function<Throwable, ?> errorMapper) {
        this.delay = delay;
        this.maxRetries = maxRetries;
        this.errorTest = errorTest;
        this.throwOnFailingErrorTest = throwOnFailingErrorTest;
        this.successLogger = successLogger;
        this.exceptionLogger = exceptionLogger;
        this.errorMapper = errorMapper;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Duration getDelay() {
        return this.delay;
    }

    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public Predicate<Exception> getErrorTest() {
        return this.errorTest;
    }

    @Generated
    public boolean isThrowOnFailingErrorTest() {
        return this.throwOnFailingErrorTest;
    }

    @Generated
    public Consumer<RetryStatus> getSuccessLogger() {
        return this.successLogger;
    }

    @Generated
    public Consumer<RetryStatus> getExceptionLogger() {
        return this.exceptionLogger;
    }

    @Generated
    public Function<Throwable, ?> getErrorMapper() {
        return this.errorMapper;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryConfiguration)) {
            return false;
        }
        RetryConfiguration other = (RetryConfiguration)o;
        if (this.getMaxRetries() != other.getMaxRetries()) {
            return false;
        }
        if (this.isThrowOnFailingErrorTest() != other.isThrowOnFailingErrorTest()) {
            return false;
        }
        Duration this$delay = this.getDelay();
        Duration other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Predicate<Exception> this$errorTest = this.getErrorTest();
        Predicate<Exception> other$errorTest = other.getErrorTest();
        if (this$errorTest == null ? other$errorTest != null : !this$errorTest.equals(other$errorTest)) {
            return false;
        }
        Consumer<RetryStatus> this$successLogger = this.getSuccessLogger();
        Consumer<RetryStatus> other$successLogger = other.getSuccessLogger();
        if (this$successLogger == null ? other$successLogger != null : !this$successLogger.equals(other$successLogger)) {
            return false;
        }
        Consumer<RetryStatus> this$exceptionLogger = this.getExceptionLogger();
        Consumer<RetryStatus> other$exceptionLogger = other.getExceptionLogger();
        if (this$exceptionLogger == null ? other$exceptionLogger != null : !this$exceptionLogger.equals(other$exceptionLogger)) {
            return false;
        }
        Function<Throwable, ?> this$errorMapper = this.getErrorMapper();
        Function<Throwable, ?> other$errorMapper = other.getErrorMapper();
        return !(this$errorMapper == null ? other$errorMapper != null : !this$errorMapper.equals(other$errorMapper));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxRetries();
        result = result * 59 + (this.isThrowOnFailingErrorTest() ? 79 : 97);
        Duration $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Predicate<Exception> $errorTest = this.getErrorTest();
        result = result * 59 + ($errorTest == null ? 43 : $errorTest.hashCode());
        Consumer<RetryStatus> $successLogger = this.getSuccessLogger();
        result = result * 59 + ($successLogger == null ? 43 : $successLogger.hashCode());
        Consumer<RetryStatus> $exceptionLogger = this.getExceptionLogger();
        result = result * 59 + ($exceptionLogger == null ? 43 : $exceptionLogger.hashCode());
        Function<Throwable, ?> $errorMapper = this.getErrorMapper();
        result = result * 59 + ($errorMapper == null ? 43 : $errorMapper.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RetryConfiguration(delay=" + String.valueOf(this.getDelay()) + ", maxRetries=" + this.getMaxRetries() + ", errorTest=" + String.valueOf(this.getErrorTest()) + ", throwOnFailingErrorTest=" + this.isThrowOnFailingErrorTest() + ", successLogger=" + String.valueOf(this.getSuccessLogger()) + ", exceptionLogger=" + String.valueOf(this.getExceptionLogger()) + ", errorMapper=" + String.valueOf(this.getErrorMapper()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean delay$set;
        @Generated
        private Duration delay$value;
        @Generated
        private boolean maxRetries$set;
        @Generated
        private int maxRetries$value;
        @Generated
        private boolean errorTest$set;
        @Generated
        private Predicate<Exception> errorTest$value;
        @Generated
        private boolean throwOnFailingErrorTest$set;
        @Generated
        private boolean throwOnFailingErrorTest$value;
        @Generated
        private boolean successLogger$set;
        @Generated
        private Consumer<RetryStatus> successLogger$value;
        @Generated
        private boolean exceptionLogger$set;
        @Generated
        private Consumer<RetryStatus> exceptionLogger$value;
        @Generated
        private boolean errorMapper$set;
        @Generated
        private Function<Throwable, ?> errorMapper$value;

        @Generated
        Builder() {
        }

        @Generated
        public Builder delay(Duration delay) {
            this.delay$value = delay;
            this.delay$set = true;
            return this;
        }

        @Generated
        public Builder maxRetries(int maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this;
        }

        @Generated
        public Builder errorTest(Predicate<Exception> errorTest) {
            this.errorTest$value = errorTest;
            this.errorTest$set = true;
            return this;
        }

        @Generated
        public Builder throwOnFailingErrorTest(boolean throwOnFailingErrorTest) {
            this.throwOnFailingErrorTest$value = throwOnFailingErrorTest;
            this.throwOnFailingErrorTest$set = true;
            return this;
        }

        @Generated
        public Builder successLogger(Consumer<RetryStatus> successLogger) {
            this.successLogger$value = successLogger;
            this.successLogger$set = true;
            return this;
        }

        @Generated
        public Builder exceptionLogger(Consumer<RetryStatus> exceptionLogger) {
            this.exceptionLogger$value = exceptionLogger;
            this.exceptionLogger$set = true;
            return this;
        }

        @Generated
        public Builder errorMapper(Function<Throwable, ?> errorMapper) {
            this.errorMapper$value = errorMapper;
            this.errorMapper$set = true;
            return this;
        }

        @Generated
        public RetryConfiguration build() {
            Duration delay$value = this.delay$value;
            if (!this.delay$set) {
                delay$value = RetryConfiguration.$default$delay();
            }
            int maxRetries$value = this.maxRetries$value;
            if (!this.maxRetries$set) {
                maxRetries$value = RetryConfiguration.$default$maxRetries();
            }
            Predicate<Exception> errorTest$value = this.errorTest$value;
            if (!this.errorTest$set) {
                errorTest$value = RetryConfiguration.$default$errorTest();
            }
            boolean throwOnFailingErrorTest$value = this.throwOnFailingErrorTest$value;
            if (!this.throwOnFailingErrorTest$set) {
                throwOnFailingErrorTest$value = RetryConfiguration.$default$throwOnFailingErrorTest();
            }
            Consumer<RetryStatus> successLogger$value = this.successLogger$value;
            if (!this.successLogger$set) {
                successLogger$value = RetryConfiguration.$default$successLogger();
            }
            Consumer<RetryStatus> exceptionLogger$value = this.exceptionLogger$value;
            if (!this.exceptionLogger$set) {
                exceptionLogger$value = RetryConfiguration.$default$exceptionLogger();
            }
            Function<Throwable, ?> errorMapper$value = this.errorMapper$value;
            if (!this.errorMapper$set) {
                errorMapper$value = RetryConfiguration.$default$errorMapper();
            }
            return new RetryConfiguration(delay$value, maxRetries$value, errorTest$value, throwOnFailingErrorTest$value, successLogger$value, exceptionLogger$value, errorMapper$value);
        }

        @Generated
        public String toString() {
            return "RetryConfiguration.Builder(delay$value=" + String.valueOf(this.delay$value) + ", maxRetries$value=" + this.maxRetries$value + ", errorTest$value=" + String.valueOf(this.errorTest$value) + ", throwOnFailingErrorTest$value=" + this.throwOnFailingErrorTest$value + ", successLogger$value=" + String.valueOf(this.successLogger$value) + ", exceptionLogger$value=" + String.valueOf(this.exceptionLogger$value) + ", errorMapper$value=" + String.valueOf(this.errorMapper$value) + ")";
        }
    }
}

