/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.api.search.constraints.AllConstraint;
import io.fluxcapacitor.common.search.Document;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonDeserialize(builder=Builder.class)
public final class SearchQuery {
    @JsonAlias(value={"collections"})
    @JsonProperty(value="collection")
    private final List<String> collections;
    private final Instant since;
    private final Instant before;
    private final boolean sinceExclusive;
    private final boolean beforeInclusive;
    private final List<Constraint> constraints;
    private final AtomicReference<Object> decomposeConstraints = new AtomicReference();

    public SearchQuery(List<String> collections, Instant since, Instant before, boolean sinceExclusive, boolean beforeInclusive, List<Constraint> constraints) {
        this.sinceExclusive = sinceExclusive;
        this.beforeInclusive = beforeInclusive;
        if (collections.isEmpty()) {
            throw new IllegalArgumentException("Collections should not be empty");
        }
        this.collections = collections;
        this.since = since;
        this.before = before;
        this.constraints = constraints;
    }

    public Instant getBefore() {
        return this.before == null || this.since == null || this.before.isAfter(this.since) ? this.before : this.since;
    }

    public boolean matches(SerializedDocument d) {
        if (d == null || !this.collections.contains(d.getCollection())) {
            return false;
        }
        return this.matches(d.deserializeDocument());
    }

    boolean matches(Document d) {
        if (!this.decomposeConstraints().matches(d)) {
            return false;
        }
        if (this.since != null && d.getEnd() != null && (this.sinceExclusive ? d.getEnd().compareTo(this.since) <= 0 : d.getEnd().compareTo(this.since) < 0)) {
            return false;
        }
        return this.before == null || d.getTimestamp() == null || !(this.before.equals(this.since) ? d.getTimestamp().compareTo(this.before) > 0 : (this.beforeInclusive ? d.getTimestamp().compareTo(this.before) > 0 : d.getTimestamp().compareTo(this.before) >= 0));
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        Builder builder = new Builder().since(this.since).before(this.before).sinceExclusive(this.sinceExclusive).beforeInclusive(this.beforeInclusive);
        if (this.collections != null) {
            builder.collections(this.collections);
        }
        if (this.constraints != null) {
            builder.constraints(this.constraints);
        }
        return builder;
    }

    @Generated
    public List<String> getCollections() {
        return this.collections;
    }

    @Generated
    public Instant getSince() {
        return this.since;
    }

    @Generated
    public boolean isSinceExclusive() {
        return this.sinceExclusive;
    }

    @Generated
    public boolean isBeforeInclusive() {
        return this.beforeInclusive;
    }

    @Generated
    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchQuery)) {
            return false;
        }
        SearchQuery other = (SearchQuery)o;
        if (this.isSinceExclusive() != other.isSinceExclusive()) {
            return false;
        }
        if (this.isBeforeInclusive() != other.isBeforeInclusive()) {
            return false;
        }
        List<String> this$collections = this.getCollections();
        List<String> other$collections = other.getCollections();
        if (this$collections == null ? other$collections != null : !((Object)this$collections).equals(other$collections)) {
            return false;
        }
        Instant this$since = this.getSince();
        Instant other$since = other.getSince();
        if (this$since == null ? other$since != null : !((Object)this$since).equals(other$since)) {
            return false;
        }
        Instant this$before = this.getBefore();
        Instant other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        List<Constraint> this$constraints = this.getConstraints();
        List<Constraint> other$constraints = other.getConstraints();
        return !(this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSinceExclusive() ? 79 : 97);
        result = result * 59 + (this.isBeforeInclusive() ? 79 : 97);
        List<String> $collections = this.getCollections();
        result = result * 59 + ($collections == null ? 43 : ((Object)$collections).hashCode());
        Instant $since = this.getSince();
        result = result * 59 + ($since == null ? 43 : ((Object)$since).hashCode());
        Instant $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        List<Constraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SearchQuery(collections=" + String.valueOf(this.getCollections()) + ", since=" + String.valueOf(this.getSince()) + ", before=" + String.valueOf(this.getBefore()) + ", sinceExclusive=" + this.isSinceExclusive() + ", beforeInclusive=" + this.isBeforeInclusive() + ", constraints=" + String.valueOf(this.getConstraints()) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Constraint decomposeConstraints() {
        Object $value = this.decomposeConstraints.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.decomposeConstraints;
            synchronized (atomicReference) {
                $value = this.decomposeConstraints.get();
                if ($value == null) {
                    Constraint actualValue = AllConstraint.all(this.getConstraints().stream().map(Constraint::decompose).collect(Collectors.toList()));
                    $value = actualValue == null ? this.decomposeConstraints : actualValue;
                    this.decomposeConstraints.set($value);
                }
            }
        }
        return (Constraint)($value == this.decomposeConstraints ? null : $value);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class Builder {
        @Generated
        private ArrayList<String> collections;
        @Generated
        private Instant since;
        @Generated
        private Instant before;
        @Generated
        private boolean sinceExclusive;
        @Generated
        private boolean beforeInclusive;
        @Generated
        private ArrayList<Constraint> constraints;

        @Generated
        Builder() {
        }

        @Generated
        public Builder collection(String collection) {
            if (this.collections == null) {
                this.collections = new ArrayList();
            }
            this.collections.add(collection);
            return this;
        }

        @JsonAlias(value={"collections"})
        @JsonProperty(value="collection")
        @Generated
        public Builder collections(Collection<? extends String> collections) {
            if (collections == null) {
                throw new NullPointerException("collections cannot be null");
            }
            if (this.collections == null) {
                this.collections = new ArrayList();
            }
            this.collections.addAll(collections);
            return this;
        }

        @Generated
        public Builder clearCollections() {
            if (this.collections != null) {
                this.collections.clear();
            }
            return this;
        }

        @Generated
        public Builder since(Instant since) {
            this.since = since;
            return this;
        }

        @Generated
        public Builder before(Instant before) {
            this.before = before;
            return this;
        }

        @Generated
        public Builder sinceExclusive(boolean sinceExclusive) {
            this.sinceExclusive = sinceExclusive;
            return this;
        }

        @Generated
        public Builder beforeInclusive(boolean beforeInclusive) {
            this.beforeInclusive = beforeInclusive;
            return this;
        }

        @Generated
        public Builder constraint(Constraint constraint) {
            if (this.constraints == null) {
                this.constraints = new ArrayList();
            }
            this.constraints.add(constraint);
            return this;
        }

        @Generated
        public Builder constraints(Collection<? extends Constraint> constraints) {
            if (constraints == null) {
                throw new NullPointerException("constraints cannot be null");
            }
            if (this.constraints == null) {
                this.constraints = new ArrayList();
            }
            this.constraints.addAll(constraints);
            return this;
        }

        @Generated
        public Builder clearConstraints() {
            if (this.constraints != null) {
                this.constraints.clear();
            }
            return this;
        }

        @Generated
        public SearchQuery build() {
            return new SearchQuery(switch (this.collections == null ? 0 : this.collections.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.collections.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.collections));
            }, this.since, this.before, this.sinceExclusive, this.beforeInclusive, switch (this.constraints == null ? 0 : this.constraints.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.constraints.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Constraint>(this.constraints));
            });
        }

        @Generated
        public String toString() {
            return "SearchQuery.Builder(collections=" + String.valueOf(this.collections) + ", since=" + String.valueOf(this.since) + ", before=" + String.valueOf(this.before) + ", sinceExclusive=" + this.sinceExclusive + ", beforeInclusive=" + this.beforeInclusive + ", constraints=" + String.valueOf(this.constraints) + ")";
        }
    }
}

