/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.Optional;
import lombok.NonNull;

@FunctionalInterface
public interface MessageFilter<M> {
    public boolean test(M var1, Executable var2, Class<? extends Annotation> var3);

    default public Optional<Class<?>> getLeastSpecificAllowedClass(Executable executable, Class<? extends Annotation> handlerAnnotation) {
        return Optional.empty();
    }

    default public MessageFilter<M> and(final @NonNull MessageFilter<? super M> second) {
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
        final MessageFilter first = this;
        return new MessageFilter<M>(this){

            @Override
            public boolean test(M m, Executable e, Class<? extends Annotation> handlerAnnotation) {
                return first.test(m, e, handlerAnnotation) && second.test(m, e, handlerAnnotation);
            }

            @Override
            public Optional<Class<?>> getLeastSpecificAllowedClass(Executable executable, Class<? extends Annotation> handlerAnnotation) {
                return first.getLeastSpecificAllowedClass(executable, handlerAnnotation).or(() -> second.getLeastSpecificAllowedClass(executable, handlerAnnotation));
            }
        };
    }
}

