/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.search;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.SearchUtils;
import io.fluxcapacitor.common.ThrowingFunction;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.search.FacetEntry;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.search.DefaultDocumentSerializer;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.common.search.Facet;
import io.fluxcapacitor.common.search.Inverter;
import io.fluxcapacitor.common.search.SearchExclude;
import io.fluxcapacitor.common.serialization.JsonUtils;
import java.beans.ConstructorProperties;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonInverter
implements Inverter<JsonNode> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonInverter.class);
    private final JsonMapper objectMapper;
    private final ThrowingFunction<Object, String> summarizer;
    protected static Function<Member, Boolean> searchIgnoreCache = ObjectUtils.memoize(m -> {
        Optional result = ReflectionUtils.getMemberAnnotation(m.getDeclaringClass(), m.getName(), SearchExclude.class).or(() -> Optional.ofNullable(ReflectionUtils.getTypeAnnotation(m.getDeclaringClass(), SearchExclude.class)));
        return result.map(a -> {
            SearchExclude s;
            return a instanceof SearchExclude ? (s = (SearchExclude)a) : a.annotationType().getAnnotation(SearchExclude.class);
        }).map(SearchExclude::value).orElse(false);
    });

    public JacksonInverter() {
        this(JsonUtils.writer);
    }

    public JacksonInverter(JsonMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.summarizer = JacksonInverter.createSummarizer(this);
    }

    protected static ThrowingFunction<Object, String> createSummarizer(JacksonInverter inverter) {
        JacksonInverter summarizer = new JacksonInverter((JsonMapper)((JsonMapper.Builder)inverter.objectMapper.rebuild().annotationIntrospector(new JacksonAnnotationIntrospector(){

            @Override
            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return super.hasIgnoreMarker(m) || searchIgnoreCache.apply(m.getMember()) != false;
            }
        })).build(), o -> {
            throw new UnsupportedOperationException();
        });
        return value -> {
            Map<Document.Entry, List<Document.Path>> entries = summarizer.invert(summarizer.objectMapper.writeValueAsBytes(value));
            return entries.keySet().stream().map(Document.Entry::asPhrase).distinct().collect(Collectors.joining(" "));
        };
    }

    public String summarize(Object value) {
        return this.summarizer.apply(value);
    }

    @Override
    public SerializedDocument toDocument(Object value, String type, int revision, String id, String collection, Instant timestamp, Instant end, Metadata metadata) {
        byte[] data = this.objectMapper.writeValueAsBytes(value);
        return new SerializedDocument(new Document(id, type, revision, collection, timestamp, end, this.invert(data), () -> this.summarize(value), this.computeFacets(value, metadata)));
    }

    protected Set<FacetEntry> computeFacets(Object value, Metadata metadata) {
        return Stream.concat(this.getFacets(value), this.asFacets(metadata)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @NotNull
    private Stream<FacetEntry> getFacets(Object value) {
        if (value == null) {
            return Stream.empty();
        }
        List<? extends AccessibleObject> properties = ReflectionUtils.getAnnotatedProperties(value.getClass(), Facet.class);
        return properties.stream().flatMap(p -> Optional.ofNullable(ReflectionUtils.getValue(p, value)).stream().flatMap(o -> this.getFacets((AccessibleObject)p, o)));
    }

    protected Stream<FacetEntry> asFacets(Metadata metadata) {
        return metadata.entrySet().stream().map(e -> new FacetEntry("$metadata/" + (String)e.getKey(), (String)e.getValue()));
    }

    protected Stream<FacetEntry> getFacets(AccessibleObject holder, Object propertyValue) {
        Object object = propertyValue;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Collection.class, Map.class}, (Object)object, n)) {
            case -1 -> Stream.empty();
            case 0 -> {
                Collection collection = (Collection)object;
                yield collection.stream().flatMap(v -> this.getFacets(holder, v));
            }
            case 1 -> {
                Map map = (Map)object;
                yield map.entrySet().stream().flatMap(e -> this.getFacets(holder, e.getValue()).map(f -> f.toBuilder().name("%s/%s".formatted(f.getName(), String.valueOf(e.getKey()))).build()));
            }
            default -> {
                String name = ReflectionUtils.getAnnotation(holder, Facet.class).map(Facet::value).filter(s -> !s.isBlank()).orElseGet(() -> ReflectionUtils.getPropertyName(holder));
                if (ReflectionUtils.isConstant(propertyValue) || ReflectionUtils.getTypeAnnotation(propertyValue.getClass(), Facet.class) != null) {
                    String stringValue = propertyValue.toString();
                    if (stringValue.isBlank()) {
                        yield Stream.empty();
                    }
                    yield Stream.of(new FacetEntry(name, stringValue));
                }
                yield this.getFacets(propertyValue).map(f -> f.toBuilder().name("%s/%s".formatted(name, f.getName())).build());
            }
        };
    }

    protected Map<Document.Entry, List<Document.Path>> invert(byte[] json) {
        LinkedHashMap<Document.Entry, List<Document.Path>> valueMap = new LinkedHashMap<Document.Entry, List<Document.Path>>();
        try (JsonParser parser = this.objectMapper.getFactory().createParser(json);){
            JsonToken token = parser.nextToken();
            if (token != null) {
                this.processToken(token, valueMap, "", parser);
            }
        }
        return valueMap;
    }

    protected JsonToken processToken(JsonToken token, Map<Document.Entry, List<Document.Path>> valueMap, String path, JsonParser parser) {
        switch (token) {
            case START_ARRAY: {
                this.parseArray(parser, valueMap, path);
                break;
            }
            case START_OBJECT: {
                this.parseObject(parser, valueMap, path);
                break;
            }
            default: {
                this.registerValue(this.getEntryType(token), parser.getText(), path, valueMap);
            }
        }
        return parser.nextToken();
    }

    protected Document.EntryType getEntryType(JsonToken token) {
        switch (token) {
            case VALUE_STRING: {
                return Document.EntryType.TEXT;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return Document.EntryType.NUMERIC;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return Document.EntryType.BOOLEAN;
            }
            case VALUE_NULL: {
                return Document.EntryType.NULL;
            }
        }
        throw new IllegalArgumentException("Unsupported value token: " + String.valueOf((Object)token));
    }

    protected void registerValue(Document.EntryType type, String value, String path, Map<Document.Entry, List<Document.Path>> valueMap) {
        List locations = valueMap.computeIfAbsent(new Document.Entry(type, value), key -> new ArrayList());
        if (!StringUtils.isBlank(path)) {
            locations.add(new Document.Path(path));
        }
    }

    private void parseArray(JsonParser parser, Map<Document.Entry, List<Document.Path>> valueMap, String root) {
        JsonToken token = parser.nextToken();
        if (token.isStructEnd()) {
            this.registerValue(Document.EntryType.EMPTY_ARRAY, "[]", (String)root, valueMap);
        } else {
            root = ((String)root).isEmpty() ? root : (String)root + "/";
            int i = 0;
            while (!token.isStructEnd()) {
                token = this.processToken(token, valueMap, (String)root + i, parser);
                ++i;
            }
        }
    }

    protected void parseObject(JsonParser parser, Map<Document.Entry, List<Document.Path>> valueMap, String root) {
        JsonToken token = parser.nextToken();
        if (token.isStructEnd()) {
            this.registerValue(Document.EntryType.EMPTY_OBJECT, "{}", (String)root, valueMap);
        } else {
            Object path = root = ((String)root).isEmpty() ? root : (String)root + "/";
            while (!token.isStructEnd()) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    fieldName = SearchUtils.escapeFieldName(fieldName);
                    path = (String)root + fieldName;
                    token = parser.nextToken();
                    continue;
                }
                token = this.processToken(token, valueMap, (String)path, parser);
            }
        }
    }

    @Override
    public Class<JsonNode> getOutputType() {
        return JsonNode.class;
    }

    @Override
    public Data<JsonNode> convert(Data<byte[]> data) {
        return this.fromData(data, () -> DefaultDocumentSerializer.INSTANCE.deserialize(data));
    }

    @Override
    public Data<?> convertFormat(Data<byte[]> data) {
        if ("document".equals(data.getFormat())) {
            return this.convert(data);
        }
        return data;
    }

    protected Data<JsonNode> fromData(Data<byte[]> data, Supplier<Document> documentFunction) {
        if ("application/json".equals(data.getFormat())) {
            return data.map(d -> this.getObjectMapper().readTree((byte[])d));
        }
        Document document = documentFunction.get();
        Map<Document.Entry, List<Document.Path>> entries = document.getEntries();
        if (entries.isEmpty()) {
            return this.toJsonData(NullNode.getInstance(), data);
        }
        TreeMap tree = new TreeMap();
        for (Map.Entry<Document.Entry, List<Document.Path>> entry : entries.entrySet()) {
            JsonNode valueNode = this.toJsonNode(entry.getKey());
            List<Document.Path> paths = entry.getValue();
            if (paths.isEmpty()) {
                return this.toJsonData(valueNode, data);
            }
            paths.forEach(path -> {
                Map parent = tree;
                Iterator iterator2 = Document.Path.split(path.getValue()).iterator();
                while (iterator2.hasNext()) {
                    Object segment = SearchUtils.asIntegerOrString((String)iterator2.next());
                    if (iterator2.hasNext()) {
                        parent = (Map)parent.computeIfAbsent(segment, s -> new TreeMap());
                        continue;
                    }
                    JsonNode existing = parent.put(segment, valueNode);
                    if (existing == null) continue;
                    log.warn("Multiple entries share the same pointer: {} and {}", (Object)existing, (Object)valueNode);
                }
            });
        }
        return this.toJsonData(this.toJsonNode(tree), data);
    }

    protected Data<JsonNode> toJsonData(JsonNode node, Data<byte[]> data) {
        return new Data<JsonNode>(node, data.getType(), data.getRevision(), "application/json");
    }

    protected JsonNode toJsonNode(Object struct) {
        if (struct instanceof Map) {
            SortedMap map = (SortedMap)struct;
            return map.keySet().stream().findFirst().map(firstKey -> firstKey instanceof Integer ? new ArrayNode(this.objectMapper.getNodeFactory(), map.values().stream().map(this::toJsonNode).collect(Collectors.toList())) : new ObjectNode(this.objectMapper.getNodeFactory(), map.entrySet().stream().collect(Collectors.toMap(e -> {
                String key = e.getKey().toString();
                key = SearchUtils.unescapeFieldName(key);
                return key;
            }, e -> this.toJsonNode(e.getValue()))))).orElse(NullNode.getInstance());
        }
        if (struct instanceof JsonNode) {
            return (JsonNode)struct;
        }
        throw new IllegalArgumentException("Unrecognized structure: " + String.valueOf(struct));
    }

    protected JsonNode toJsonNode(Document.Entry entry) {
        return switch (entry.getType()) {
            default -> throw new MatchException(null, null);
            case Document.EntryType.TEXT -> new TextNode(entry.getValue());
            case Document.EntryType.NUMERIC -> new DecimalNode(new BigDecimal(entry.getValue()));
            case Document.EntryType.BOOLEAN -> BooleanNode.valueOf(Boolean.parseBoolean(entry.getValue()));
            case Document.EntryType.NULL -> NullNode.getInstance();
            case Document.EntryType.EMPTY_ARRAY -> new ArrayNode(this.objectMapper.getNodeFactory());
            case Document.EntryType.EMPTY_OBJECT -> new ObjectNode(this.objectMapper.getNodeFactory());
        };
    }

    @Generated
    protected JsonMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    protected ThrowingFunction<Object, String> getSummarizer() {
        return this.summarizer;
    }

    @ConstructorProperties(value={"objectMapper", "summarizer"})
    @Generated
    public JacksonInverter(JsonMapper objectMapper, ThrowingFunction<Object, String> summarizer) {
        this.objectMapper = objectMapper;
        this.summarizer = summarizer;
    }
}

