/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.serialization;

import com.google.auto.service.AutoService;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.serialization.RegisterType;
import io.fluxcapacitor.common.serialization.TypeRegistry;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.Generated;

@SupportedAnnotationTypes(value={"io.fluxcapacitor.common.serialization.RegisterType"})
@AutoService(value={Processor.class})
public class TypeRegistryProcessor
extends AbstractProcessor {
    static final String ANNOTATION = "io.fluxcapacitor.common.serialization.RegisterType";
    public static final String TYPES_FILE = "META-INF/" + TypeRegistry.class.getName();
    private static final String PREFIXES_FILE = "META-INF/type-registry-prefixes";
    private final Set<String> roundPrefixes = new LinkedHashSet<String>();
    private final AtomicReference<Object> typesResource = new AtomicReference();
    private final AtomicReference<Object> prefixesResource = new AtomicReference();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        if (!this.isNewProcess()) {
            this.storeTypes();
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.roundPrefixes.addAll(roundEnv.getRootElements().stream().flatMap(this::getPrefixes).toList());
        if (roundEnv.processingOver() && this.isNewProcess()) {
            this.storeTypes();
        }
        return true;
    }

    boolean isNewProcess() {
        return this.getTypesResource().getLastModified() == 0L;
    }

    void storeTypes() {
        Set<String> prefixes = this.updateAndGetPrefixes();
        TreeSet types = Stream.concat(this.getStoredTypes(prefixes), this.getNewTypes(prefixes)).collect(Collectors.toCollection(TreeSet::new));
        try (Writer resourceWriter = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", TYPES_FILE, new Element[0]).openWriter();){
            for (String type : types) {
                resourceWriter.write(type + "\n");
            }
        }
    }

    Stream<String> getStoredTypes(Set<String> prefixes) {
        if (this.isNewProcess()) {
            return Stream.empty();
        }
        ArrayList<String> result = new ArrayList<String>();
        try (Scanner scanner = new Scanner(this.getTypesResource().openInputStream());){
            while (scanner.hasNextLine()) {
                String type = scanner.nextLine();
                String canonicalType = type.replace("$", ".");
                if (!this.isType(type)) continue;
                if (!prefixes.stream().anyMatch(canonicalType::startsWith)) continue;
                result.add(type);
            }
        }
        return result.stream();
    }

    Stream<String> getNewTypes(Set<String> prefixes) {
        return this.processingEnv.getElementUtils().getAllModuleElements().stream().flatMap(this::getClasses).filter(t -> prefixes.stream().anyMatch(prefix -> t.getQualifiedName().toString().startsWith((String)prefix))).map(c -> this.processingEnv.getElementUtils().getBinaryName((TypeElement)c).toString());
    }

    Set<String> updateAndGetPrefixes() {
        TreeSet<String> prefixes = new TreeSet<String>(this.roundPrefixes);
        FileObject resource = this.getPrefixesResource();
        if (resource.getLastModified() != 0L) {
            try (Scanner scanner = new Scanner(resource.openInputStream());){
                while (scanner.hasNextLine()) {
                    String prefix = scanner.nextLine();
                    if (!this.isPackage(prefix) && !this.isType(prefix)) continue;
                    prefixes.add(prefix);
                }
            }
        }
        resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", PREFIXES_FILE, new Element[0]);
        try (Writer resourceWriter = resource.openWriter();){
            for (String prefix : prefixes) {
                if (!this.isPackage(prefix) && !this.isType(prefix)) continue;
                resourceWriter.write(prefix + "\n");
            }
        }
        return prefixes;
    }

    Stream<String> getPrefixes(Element element) {
        try {
            if (element.getAnnotation(RegisterType.class) != null) {
                return Stream.of(((QualifiedNameable)element).getQualifiedName().toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return element.getEnclosedElements().stream().flatMap(this::getPrefixes);
    }

    Stream<TypeElement> getClasses(Element element) {
        try {
            Stream<Object> stream;
            if (element instanceof TypeElement) {
                TypeElement t = (TypeElement)element;
                stream = Stream.of(t);
            } else {
                stream = Stream.empty();
            }
            return Stream.concat(stream, element.getEnclosedElements().stream().flatMap(this::getClasses));
        }
        catch (Throwable e) {
            this.processingEnv.getMessager().printWarning("Failed to get classes of element: " + String.valueOf(element) + ". " + e.getMessage());
            return Stream.empty();
        }
    }

    boolean isType(String fqn) {
        return this.processingEnv.getElementUtils().getTypeElement(fqn.replace("$", ".")) != null;
    }

    boolean isPackage(String fqn) {
        return this.processingEnv.getElementUtils().getPackageElement(fqn) != null;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public FileObject getTypesResource() {
        Object $value = this.typesResource.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.typesResource;
            synchronized (atomicReference) {
                $value = this.typesResource.get();
                if ($value == null) {
                    FileObject actualValue = ObjectUtils.call(() -> this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", TYPES_FILE));
                    $value = actualValue == null ? this.typesResource : actualValue;
                    this.typesResource.set($value);
                }
            }
        }
        return (FileObject)($value == this.typesResource ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public FileObject getPrefixesResource() {
        Object $value = this.prefixesResource.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.prefixesResource;
            synchronized (atomicReference) {
                $value = this.prefixesResource.get();
                if ($value == null) {
                    FileObject actualValue = ObjectUtils.call(() -> this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", PREFIXES_FILE));
                    $value = actualValue == null ? this.prefixesResource : actualValue;
                    this.prefixesResource.set($value);
                }
            }
        }
        return (FileObject)($value == this.prefixesResource ? null : $value);
    }
}

