/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.tracking;

import io.fluxcapacitor.common.api.tracking.Position;
import io.fluxcapacitor.common.tracking.PositionStore;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryPositionStore
implements PositionStore {
    private final Map<String, Position> positions = new ConcurrentHashMap<String, Position>();

    @Override
    public CompletableFuture<Void> storePosition(String consumer, int[] segment, long lastIndex) {
        this.positions.compute(consumer, (p, oldPosition) -> {
            if (oldPosition == null) {
                oldPosition = Position.newPosition();
            }
            return oldPosition.merge(new Position(segment, lastIndex));
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> resetPosition(String consumer, long lastIndex) {
        this.positions.put(consumer, new Position(new int[]{0, Position.MAX_SEGMENT}, lastIndex));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Position position(String consumer) {
        return this.positions.computeIfAbsent(consumer, c -> Position.newPosition());
    }

    @Override
    public void close() {
    }
}

