/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration;

import io.fluxcapacitor.common.MemoizingFunction;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.ThrowingRunnable;
import io.fluxcapacitor.common.application.DecryptingPropertySource;
import io.fluxcapacitor.common.application.DefaultPropertySource;
import io.fluxcapacitor.common.application.PropertySource;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.IdentityProvider;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.jackson.JacksonSerializer;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.modeling.DefaultEntityHelper;
import io.fluxcapacitor.javaclient.modeling.DefaultHandlerRepository;
import io.fluxcapacitor.javaclient.modeling.EntityParameterResolver;
import io.fluxcapacitor.javaclient.modeling.HandlerRepository;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.CacheEvictionsLogger;
import io.fluxcapacitor.javaclient.persisting.caching.DefaultCache;
import io.fluxcapacitor.javaclient.persisting.caching.NamedCache;
import io.fluxcapacitor.javaclient.persisting.caching.SelectiveCache;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultEventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultSnapshotStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.DefaultKeyValueStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.persisting.repository.AggregateRepository;
import io.fluxcapacitor.javaclient.persisting.repository.CachingAggregateRepository;
import io.fluxcapacitor.javaclient.persisting.repository.DefaultAggregateRepository;
import io.fluxcapacitor.javaclient.persisting.search.DefaultDocumentStore;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.persisting.search.client.InMemorySearchStore;
import io.fluxcapacitor.javaclient.persisting.search.client.LocalDocumentHandlerRegistry;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.AdhocDispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.CommandGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultCommandGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultErrorGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultEventGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultGenericGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultMetricsGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultQueryGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultRequestHandler;
import io.fluxcapacitor.javaclient.publishing.DefaultResultGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultWebRequestGateway;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.GenericGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.QueryGateway;
import io.fluxcapacitor.javaclient.publishing.RequestHandler;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.WebRequestGateway;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelatingInterceptor;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.publishing.correlation.DefaultCorrelationDataProvider;
import io.fluxcapacitor.javaclient.publishing.dataprotection.DataProtectionInterceptor;
import io.fluxcapacitor.javaclient.publishing.routing.MessageRoutingInterceptor;
import io.fluxcapacitor.javaclient.scheduling.DefaultScheduler;
import io.fluxcapacitor.javaclient.scheduling.ScheduledCommandHandler;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulingInterceptor;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.DefaultTracking;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.handling.DefaultHandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.DefaultResponseMapper;
import io.fluxcapacitor.javaclient.tracking.handling.DeserializingMessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.DocumentHandlerDecorator;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerDecorator;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.HasLocalHandlers;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.MessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.MetadataParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.PayloadParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.ResponseMapper;
import io.fluxcapacitor.javaclient.tracking.handling.TriggerParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.AuthenticatingInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import io.fluxcapacitor.javaclient.tracking.handling.errorreporting.ErrorReportingInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidatingInterceptor;
import io.fluxcapacitor.javaclient.tracking.metrics.HandlerMonitor;
import io.fluxcapacitor.javaclient.tracking.metrics.TrackerMonitor;
import io.fluxcapacitor.javaclient.web.DefaultWebResponseMapper;
import io.fluxcapacitor.javaclient.web.ForwardingWebConsumer;
import io.fluxcapacitor.javaclient.web.LocalServerConfig;
import io.fluxcapacitor.javaclient.web.SocketSessionParameterResolver;
import io.fluxcapacitor.javaclient.web.WebParamParameterResolver;
import io.fluxcapacitor.javaclient.web.WebPayloadParameterResolver;
import io.fluxcapacitor.javaclient.web.WebResponseCompressingInterceptor;
import io.fluxcapacitor.javaclient.web.WebResponseGateway;
import io.fluxcapacitor.javaclient.web.WebResponseMapper;
import io.fluxcapacitor.javaclient.web.WebsocketHandlerDecorator;
import io.fluxcapacitor.javaclient.web.WebsocketResponseInterceptor;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFluxCapacitor
implements FluxCapacitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFluxCapacitor.class);
    private final Map<MessageType, ? extends Tracking> trackingSupplier;
    private final Function<String, ? extends GenericGateway> customGatewaySupplier;
    private final CommandGateway commandGateway;
    private final QueryGateway queryGateway;
    private final EventGateway eventGateway;
    private final ResultGateway resultGateway;
    private final ErrorGateway errorGateway;
    private final MetricsGateway metricsGateway;
    private final WebRequestGateway webRequestGateway;
    private final AggregateRepository aggregateRepository;
    private final SnapshotStore snapshotStore;
    private final EventStore eventStore;
    private final KeyValueStore keyValueStore;
    private final DocumentStore documentStore;
    private final Scheduler scheduler;
    private final UserProvider userProvider;
    private final Cache cache;
    private final Serializer serializer;
    private final CorrelationDataProvider correlationDataProvider;
    private final IdentityProvider identityProvider;
    private final PropertySource propertySource;
    private final AtomicReference<Clock> clock = new AtomicReference<Clock>(Clock.systemUTC());
    private final Client client;
    private final ThrowingRunnable shutdownHandler;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Collection<Runnable> cleanupTasks = new CopyOnWriteArrayList<Runnable>();

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public GenericGateway customGateway(String topic) {
        return this.customGatewaySupplier.apply(topic);
    }

    @Override
    public Tracking tracking(MessageType messageType) {
        return Optional.ofNullable(this.trackingSupplier.get((Object)messageType)).orElseThrow(() -> new TrackingException(String.format("Tracking is not supported for type %s", new Object[]{messageType})));
    }

    @Override
    public void withClock(@NonNull Clock clock) {
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.clock.set(clock);
    }

    @Override
    public Clock clock() {
        return this.clock.get();
    }

    @Override
    public Registration beforeShutdown(Runnable task) {
        this.cleanupTasks.add(task);
        return () -> this.cleanupTasks.remove(task);
    }

    @Override
    public void close(boolean silently) {
        if (this.closed.compareAndSet(false, true)) {
            if (!silently) {
                log.info("Initiating controlled shutdown");
            }
            try {
                this.cleanupTasks.forEach(ObjectUtils::tryRun);
                this.shutdownHandler.run();
            }
            catch (Exception e) {
                log.error("Encountered an error during shutdown", e);
            }
            finally {
                if (FluxCapacitor.applicationInstance.get() == this) {
                    FluxCapacitor.applicationInstance.set(null);
                }
            }
            if (!silently) {
                log.info("Completed shutdown");
            }
        }
    }

    @ConstructorProperties(value={"trackingSupplier", "customGatewaySupplier", "commandGateway", "queryGateway", "eventGateway", "resultGateway", "errorGateway", "metricsGateway", "webRequestGateway", "aggregateRepository", "snapshotStore", "eventStore", "keyValueStore", "documentStore", "scheduler", "userProvider", "cache", "serializer", "correlationDataProvider", "identityProvider", "propertySource", "client", "shutdownHandler"})
    @Generated
    protected DefaultFluxCapacitor(Map<MessageType, ? extends Tracking> trackingSupplier, Function<String, ? extends GenericGateway> customGatewaySupplier, CommandGateway commandGateway, QueryGateway queryGateway, EventGateway eventGateway, ResultGateway resultGateway, ErrorGateway errorGateway, MetricsGateway metricsGateway, WebRequestGateway webRequestGateway, AggregateRepository aggregateRepository, SnapshotStore snapshotStore, EventStore eventStore, KeyValueStore keyValueStore, DocumentStore documentStore, Scheduler scheduler, UserProvider userProvider, Cache cache, Serializer serializer, CorrelationDataProvider correlationDataProvider, IdentityProvider identityProvider, PropertySource propertySource, Client client, ThrowingRunnable shutdownHandler) {
        this.trackingSupplier = trackingSupplier;
        this.customGatewaySupplier = customGatewaySupplier;
        this.commandGateway = commandGateway;
        this.queryGateway = queryGateway;
        this.eventGateway = eventGateway;
        this.resultGateway = resultGateway;
        this.errorGateway = errorGateway;
        this.metricsGateway = metricsGateway;
        this.webRequestGateway = webRequestGateway;
        this.aggregateRepository = aggregateRepository;
        this.snapshotStore = snapshotStore;
        this.eventStore = eventStore;
        this.keyValueStore = keyValueStore;
        this.documentStore = documentStore;
        this.scheduler = scheduler;
        this.userProvider = userProvider;
        this.cache = cache;
        this.serializer = serializer;
        this.correlationDataProvider = correlationDataProvider;
        this.identityProvider = identityProvider;
        this.propertySource = propertySource;
        this.client = client;
        this.shutdownHandler = shutdownHandler;
    }

    @Generated
    public Map<MessageType, ? extends Tracking> trackingSupplier() {
        return this.trackingSupplier;
    }

    @Generated
    public Function<String, ? extends GenericGateway> customGatewaySupplier() {
        return this.customGatewaySupplier;
    }

    @Override
    @Generated
    public CommandGateway commandGateway() {
        return this.commandGateway;
    }

    @Override
    @Generated
    public QueryGateway queryGateway() {
        return this.queryGateway;
    }

    @Override
    @Generated
    public EventGateway eventGateway() {
        return this.eventGateway;
    }

    @Override
    @Generated
    public ResultGateway resultGateway() {
        return this.resultGateway;
    }

    @Override
    @Generated
    public ErrorGateway errorGateway() {
        return this.errorGateway;
    }

    @Override
    @Generated
    public MetricsGateway metricsGateway() {
        return this.metricsGateway;
    }

    @Override
    @Generated
    public WebRequestGateway webRequestGateway() {
        return this.webRequestGateway;
    }

    @Override
    @Generated
    public AggregateRepository aggregateRepository() {
        return this.aggregateRepository;
    }

    @Override
    @Generated
    public SnapshotStore snapshotStore() {
        return this.snapshotStore;
    }

    @Override
    @Generated
    public EventStore eventStore() {
        return this.eventStore;
    }

    @Override
    @Generated
    public KeyValueStore keyValueStore() {
        return this.keyValueStore;
    }

    @Override
    @Generated
    public DocumentStore documentStore() {
        return this.documentStore;
    }

    @Override
    @Generated
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    @Generated
    public UserProvider userProvider() {
        return this.userProvider;
    }

    @Override
    @Generated
    public Cache cache() {
        return this.cache;
    }

    @Override
    @Generated
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    @Generated
    public CorrelationDataProvider correlationDataProvider() {
        return this.correlationDataProvider;
    }

    @Override
    @Generated
    public IdentityProvider identityProvider() {
        return this.identityProvider;
    }

    @Override
    @Generated
    public PropertySource propertySource() {
        return this.propertySource;
    }

    @Override
    @Generated
    public Client client() {
        return this.client;
    }

    @Generated
    public ThrowingRunnable shutdownHandler() {
        return this.shutdownHandler;
    }

    @Generated
    public AtomicBoolean closed() {
        return this.closed;
    }

    @Generated
    public Collection<Runnable> cleanupTasks() {
        return this.cleanupTasks;
    }

    public static class Builder
    implements FluxCapacitorBuilder {
        private Serializer serializer;
        private Serializer snapshotSerializer;
        private CorrelationDataProvider correlationDataProvider;
        private DocumentSerializer documentSerializer;
        private final Map<MessageType, ConsumerConfiguration> defaultConsumerConfigurations;
        private final Map<MessageType, List<ConsumerConfiguration>> customConsumerConfigurations;
        private final List<ParameterResolver<? super DeserializingMessage>> customParameterResolvers;
        private final Map<MessageType, List<DispatchInterceptor>> lowPrioDispatchInterceptors;
        private final Map<MessageType, List<DispatchInterceptor>> highPrioDispatchInterceptors;
        private final Map<MessageType, List<HandlerDecorator>> lowPrioHandlerDecorators;
        private final Map<MessageType, List<HandlerDecorator>> highPrioHandlerDecorators;
        private final Map<MessageType, List<BatchInterceptor>> generalBatchInterceptors;
        private DispatchInterceptor messageRoutingInterceptor;
        private SchedulingInterceptor schedulingInterceptor;
        private ForwardingWebConsumer forwardingWebConsumer;
        private Cache cache;
        private Cache relationshipsCache;
        private ResponseMapper defaultResponseMapper;
        private WebResponseMapper webResponseMapper;
        private boolean disableErrorReporting;
        private boolean disableMessageCorrelation;
        private boolean disablePayloadValidation;
        private boolean disableDataProtection;
        private boolean disableAutomaticAggregateCaching;
        private boolean disableScheduledCommandHandler;
        private boolean disableShutdownHook;
        private boolean disableTrackingMetrics;
        private boolean disableCacheEvictionMetrics;
        private boolean disableWebResponseCompression;
        private boolean disableAdhocDispatchInterceptor;
        private boolean makeApplicationInstance;
        private UserProvider userProvider;
        private IdentityProvider identityProvider;
        private PropertySource propertySource;

        public Builder() {
            this.snapshotSerializer = this.serializer = new JacksonSerializer();
            this.correlationDataProvider = DefaultCorrelationDataProvider.INSTANCE;
            this.documentSerializer = (JacksonSerializer)this.serializer;
            this.defaultConsumerConfigurations = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), this::getDefaultConsumerConfiguration));
            this.customConsumerConfigurations = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), messageType -> new ArrayList()));
            this.customParameterResolvers = new ArrayList<ParameterResolver<? super DeserializingMessage>>();
            this.lowPrioDispatchInterceptors = new HashMap<MessageType, List<DispatchInterceptor>>();
            this.highPrioDispatchInterceptors = new HashMap<MessageType, List<DispatchInterceptor>>();
            this.lowPrioHandlerDecorators = new HashMap<MessageType, List<HandlerDecorator>>();
            this.highPrioHandlerDecorators = new HashMap<MessageType, List<HandlerDecorator>>();
            this.generalBatchInterceptors = new HashMap<MessageType, List<BatchInterceptor>>();
            this.messageRoutingInterceptor = new MessageRoutingInterceptor();
            this.schedulingInterceptor = new SchedulingInterceptor();
            this.cache = new DefaultCache();
            this.relationshipsCache = new DefaultCache(100000);
            this.defaultResponseMapper = new DefaultResponseMapper();
            this.webResponseMapper = new DefaultWebResponseMapper();
            this.userProvider = UserProvider.defaultUserProvider;
            this.identityProvider = IdentityProvider.defaultIdentityProvider;
            this.propertySource = DefaultPropertySource.getInstance();
        }

        @Override
        public Builder replaceSerializer(@NonNull Serializer serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            if (this.snapshotSerializer == this.serializer) {
                this.snapshotSerializer = serializer;
            }
            if (this.documentSerializer == this.serializer && serializer instanceof DocumentSerializer) {
                this.documentSerializer = (DocumentSerializer)((Object)serializer);
            }
            this.serializer = serializer;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceCorrelationDataProvider(@NonNull UnaryOperator<CorrelationDataProvider> replaceFunction) {
            if (replaceFunction == null) {
                throw new NullPointerException("replaceFunction is marked non-null but is null");
            }
            this.correlationDataProvider = (CorrelationDataProvider)replaceFunction.apply(this.correlationDataProvider);
            return this;
        }

        @Override
        public Builder replaceSnapshotSerializer(@NonNull Serializer serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            this.snapshotSerializer = serializer;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceDocumentSerializer(@NonNull DocumentSerializer documentSerializer) {
            if (documentSerializer == null) {
                throw new NullPointerException("documentSerializer is marked non-null but is null");
            }
            this.documentSerializer = documentSerializer;
            return this;
        }

        @Override
        public FluxCapacitorBuilder registerUserProvider(@NonNull UserProvider userProvider) {
            if (userProvider == null) {
                throw new NullPointerException("userProvider is marked non-null but is null");
            }
            this.userProvider = userProvider;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replacePropertySource(UnaryOperator<PropertySource> replacer) {
            this.propertySource = (PropertySource)replacer.apply(this.propertySource);
            return this;
        }

        @Override
        public Builder configureDefaultConsumer(@NonNull MessageType messageType, @NonNull UnaryOperator<ConsumerConfiguration> updateFunction) {
            if (messageType == null) {
                throw new NullPointerException("messageType is marked non-null but is null");
            }
            if (updateFunction == null) {
                throw new NullPointerException("updateFunction is marked non-null but is null");
            }
            ConsumerConfiguration defaultConfiguration = this.defaultConsumerConfigurations.get((Object)messageType);
            ConsumerConfiguration updatedConfiguration = (ConsumerConfiguration)updateFunction.apply(defaultConfiguration);
            this.defaultConsumerConfigurations.put(messageType, updatedConfiguration);
            return this;
        }

        @Override
        public Builder addConsumerConfiguration(@NonNull ConsumerConfiguration configuration, MessageType ... messageTypes) {
            if (configuration == null) {
                throw new NullPointerException("configuration is marked non-null but is null");
            }
            if (messageTypes.length == 0) {
                messageTypes = MessageType.values();
            }
            for (MessageType messageType : messageTypes) {
                List<ConsumerConfiguration> configurations = this.customConsumerConfigurations.get((Object)messageType);
                if (configurations.stream().map(ConsumerConfiguration::getName).anyMatch(n -> Objects.equals(n, configuration.getName()))) {
                    throw new IllegalArgumentException(String.format("Consumer name %s is already in use", configuration.getName()));
                }
                configurations.add(configuration);
            }
            return this;
        }

        @Override
        public FluxCapacitorBuilder addBatchInterceptor(BatchInterceptor interceptor, MessageType ... forTypes) {
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> this.generalBatchInterceptors.computeIfAbsent((MessageType)((Object)type), t -> new ArrayList()).add(interceptor));
            return this;
        }

        @Override
        public Builder addDispatchInterceptor(@NonNull DispatchInterceptor interceptor, boolean highPriority, MessageType ... forTypes) {
            if (interceptor == null) {
                throw new NullPointerException("interceptor is marked non-null but is null");
            }
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> (highPriority ? this.highPrioDispatchInterceptors : this.lowPrioDispatchInterceptors).computeIfAbsent((MessageType)((Object)type), t -> new ArrayList()).add(interceptor));
            return this;
        }

        @Override
        public Builder addHandlerDecorator(@NonNull HandlerDecorator interceptor, boolean highPriority, MessageType ... forTypes) {
            if (interceptor == null) {
                throw new NullPointerException("interceptor is marked non-null but is null");
            }
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> (highPriority ? this.highPrioHandlerDecorators : this.lowPrioHandlerDecorators).computeIfAbsent((MessageType)((Object)type), t -> new ArrayList()).add(interceptor));
            return this;
        }

        @Override
        public Builder replaceMessageRoutingInterceptor(@NonNull DispatchInterceptor messageRoutingInterceptor) {
            if (messageRoutingInterceptor == null) {
                throw new NullPointerException("messageRoutingInterceptor is marked non-null but is null");
            }
            this.messageRoutingInterceptor = messageRoutingInterceptor;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceCache(@NonNull Cache cache) {
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            this.cache = cache;
            return this;
        }

        @Override
        public FluxCapacitorBuilder forwardWebRequestsToLocalServer(LocalServerConfig localServerConfig, UnaryOperator<ConsumerConfiguration> consumerConfigurator) {
            this.forwardingWebConsumer = new ForwardingWebConsumer(localServerConfig, (ConsumerConfiguration)consumerConfigurator.apply(this.getDefaultConsumerConfiguration(MessageType.WEBREQUEST)));
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceDefaultResponseMapper(ResponseMapper defaultResponseMapper) {
            this.defaultResponseMapper = defaultResponseMapper;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceWebResponseMapper(WebResponseMapper webResponseMapper) {
            this.webResponseMapper = webResponseMapper;
            return this;
        }

        @Override
        public FluxCapacitorBuilder withAggregateCache(Class<?> aggregateType, Cache cache) {
            this.cache = new SelectiveCache(cache, SelectiveCache.aggregateSelector(aggregateType), this.cache);
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceRelationshipsCache(UnaryOperator<Cache> replaceFunction) {
            this.relationshipsCache = (Cache)replaceFunction.apply(this.relationshipsCache);
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceIdentityProvider(UnaryOperator<IdentityProvider> replaceFunction) {
            this.identityProvider = (IdentityProvider)replaceFunction.apply(this.identityProvider);
            return this;
        }

        @Override
        public Builder addParameterResolver(@NonNull ParameterResolver<? super DeserializingMessage> parameterResolver) {
            if (parameterResolver == null) {
                throw new NullPointerException("parameterResolver is marked non-null but is null");
            }
            this.customParameterResolvers.add(parameterResolver);
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableErrorReporting() {
            this.disableErrorReporting = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableShutdownHook() {
            this.disableShutdownHook = true;
            return this;
        }

        @Override
        public Builder disableMessageCorrelation() {
            this.disableMessageCorrelation = true;
            return this;
        }

        @Override
        public Builder disablePayloadValidation() {
            this.disablePayloadValidation = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableDataProtection() {
            this.disableDataProtection = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableAutomaticAggregateCaching() {
            this.disableAutomaticAggregateCaching = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableScheduledCommandHandler() {
            this.disableScheduledCommandHandler = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableTrackingMetrics() {
            this.disableTrackingMetrics = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableCacheEvictionMetrics() {
            this.disableCacheEvictionMetrics = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableWebResponseCompression() {
            this.disableWebResponseCompression = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableAdhocDispatchInterceptor() {
            this.disableAdhocDispatchInterceptor = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder makeApplicationInstance(boolean makeApplicationInstance) {
            this.makeApplicationInstance = makeApplicationInstance;
            return this;
        }

        @Override
        public FluxCapacitor build(@NonNull Client client) {
            DecryptingPropertySource dps;
            PropertySource propertySource;
            HasLocalHandlers hasLocalHandlers;
            SearchClient searchClient;
            HandlerInterceptor interceptor;
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            Map<MessageType, DispatchInterceptor> dispatchInterceptors = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> DispatchInterceptor.noOp));
            Map<MessageType, HandlerDecorator> handlerDecorators = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> HandlerDecorator.noOp));
            HashMap<MessageType, List<ConsumerConfiguration>> consumerConfigurations = new HashMap<MessageType, List<ConsumerConfiguration>>(this.customConsumerConfigurations);
            this.defaultConsumerConfigurations.forEach((type, config) -> ((List)consumerConfigurations.get(type)).add(config.toBuilder().name(String.format("%s_%s", client.name(), config.getName())).build()));
            DefaultKeyValueStore keyValueStore = new DefaultKeyValueStore(client.getKeyValueClient(), this.serializer);
            Arrays.stream(MessageType.values()).forEach(type -> dispatchInterceptors.computeIfPresent((MessageType)((Object)type), (t, i) -> i.andThen(this.messageRoutingInterceptor)));
            if (this.userProvider != null) {
                interceptor = new AuthenticatingInterceptor(this.userProvider);
                Stream.of(MessageType.COMMAND, MessageType.QUERY, MessageType.SCHEDULE, MessageType.WEBREQUEST).forEach(arg_0 -> Builder.lambda$build$15(dispatchInterceptors, (AuthenticatingInterceptor)interceptor, handlerDecorators, arg_0));
            }
            if (!this.disableDataProtection) {
                interceptor = new DataProtectionInterceptor(keyValueStore, this.serializer);
                Stream.of(MessageType.COMMAND, MessageType.EVENT, MessageType.QUERY, MessageType.RESULT, MessageType.SCHEDULE).forEach(arg_0 -> Builder.lambda$build$18(dispatchInterceptors, (DataProtectionInterceptor)interceptor, handlerDecorators, arg_0));
            }
            if (!this.disableMessageCorrelation) {
                CorrelatingInterceptor correlatingInterceptor = new CorrelatingInterceptor();
                Arrays.stream(MessageType.values()).forEach(type -> dispatchInterceptors.compute((MessageType)((Object)type), (t, i) -> correlatingInterceptor.andThen((DispatchInterceptor)i)));
            }
            if (!this.disablePayloadValidation) {
                interceptor = new ValidatingInterceptor();
                Stream.of(MessageType.COMMAND, MessageType.QUERY).forEach(arg_0 -> Builder.lambda$build$22(handlerDecorators, (ValidatingInterceptor)interceptor, arg_0));
            }
            dispatchInterceptors.computeIfPresent(MessageType.SCHEDULE, (t, i) -> i.andThen(this.schedulingInterceptor));
            handlerDecorators.computeIfPresent(MessageType.SCHEDULE, (t, i) -> i.andThen(this.schedulingInterceptor));
            if (!this.disableTrackingMetrics) {
                TrackerMonitor batchInterceptor = new TrackerMonitor();
                HandlerMonitor handlerMonitor = new HandlerMonitor();
                EnumSet.complementOf(EnumSet.of(MessageType.METRICS)).forEach(type -> {
                    this.generalBatchInterceptors.computeIfAbsent((MessageType)((Object)type), t -> new ArrayList()).add(batchInterceptor);
                    handlerDecorators.compute((MessageType)((Object)type), (t, i) -> handlerMonitor.andThen((HandlerDecorator)i));
                });
            }
            this.lowPrioDispatchInterceptors.forEach((messageType, interceptors) -> interceptors.forEach(interceptor -> dispatchInterceptors.computeIfPresent((MessageType)((Object)messageType), (t, i) -> i.andThen((DispatchInterceptor)interceptor))));
            this.highPrioDispatchInterceptors.forEach((messageType, interceptors) -> interceptors.forEach(interceptor -> dispatchInterceptors.computeIfPresent((MessageType)((Object)messageType), (t, i) -> interceptor.andThen((DispatchInterceptor)i))));
            this.lowPrioHandlerDecorators.forEach((messageType, interceptors) -> interceptors.forEach(interceptor -> handlerDecorators.computeIfPresent((MessageType)((Object)messageType), (t, i) -> i.andThen((HandlerDecorator)interceptor))));
            this.highPrioHandlerDecorators.forEach((messageType, interceptors) -> interceptors.forEach(interceptor -> handlerDecorators.computeIfPresent((MessageType)((Object)messageType), (t, i) -> interceptor.andThen((HandlerDecorator)i))));
            handlerDecorators.computeIfPresent(MessageType.WEBREQUEST, (t, i) -> i.andThen(new WebsocketHandlerDecorator()));
            dispatchInterceptors.computeIfPresent(MessageType.WEBRESPONSE, (t, i) -> new WebsocketResponseInterceptor().andThen((DispatchInterceptor)i));
            AtomicReference<DefaultDocumentStore> documentStore = new AtomicReference<DefaultDocumentStore>();
            Supplier<DocumentStore> documentStoreSupplier = documentStore::get;
            handlerDecorators.computeIfPresent(MessageType.DOCUMENT, (t, i) -> new DocumentHandlerDecorator(documentStoreSupplier).andThen((HandlerDecorator)i));
            if (!this.disableWebResponseCompression) {
                dispatchInterceptors.computeIfPresent(MessageType.WEBRESPONSE, (t, i) -> new WebResponseCompressingInterceptor().andThen((DispatchInterceptor)i));
            }
            if (!this.disableAdhocDispatchInterceptor) {
                AdhocDispatchInterceptor adhocInterceptor = new AdhocDispatchInterceptor();
                EnumSet.allOf(MessageType.class).forEach(messageType -> dispatchInterceptors.computeIfPresent((MessageType)((Object)messageType), (t, i) -> adhocInterceptor.andThen((DispatchInterceptor)i)));
            }
            WebResponseGateway webResponseGateway = new WebResponseGateway(client.getGatewayClient(MessageType.WEBRESPONSE), this.serializer, dispatchInterceptors.get((Object)MessageType.WEBRESPONSE), this.webResponseMapper);
            ArrayList<ParameterResolver<? super DeserializingMessage>> parameterResolvers = new ArrayList<ParameterResolver<? super DeserializingMessage>>(this.customParameterResolvers);
            if (this.userProvider != null) {
                parameterResolvers.add(new UserParameterResolver(this.userProvider));
            }
            parameterResolvers.addAll(List.of(new TriggerParameterResolver(client, this.serializer), new DeserializingMessageParameterResolver(), new MetadataParameterResolver(), new MessageParameterResolver(), new SocketSessionParameterResolver(webResponseGateway), new WebParamParameterResolver(), new WebPayloadParameterResolver(!this.disablePayloadValidation, this.userProvider != null), new PayloadParameterResolver(), new EntityParameterResolver()));
            Function<Class<?>, HandlerRepository> handlerRepositorySupplier = DefaultHandlerRepository.repositorySupplier(documentStoreSupplier, this.documentSerializer);
            SearchClient searchClient2 = searchClient = client.getSearchClient();
            if (searchClient instanceof InMemorySearchStore) {
                InMemorySearchStore searchStore = (InMemorySearchStore)searchClient;
                hasLocalHandlers = new LocalDocumentHandlerRegistry(searchStore, this.localHandlerRegistry(MessageType.DOCUMENT, handlerDecorators, parameterResolvers, handlerRepositorySupplier), dispatchInterceptors.get((Object)MessageType.DOCUMENT), this.serializer);
            } else {
                hasLocalHandlers = HandlerRegistry.noOp();
            }
            documentStore.set(new DefaultDocumentStore(searchClient2, this.documentSerializer, hasLocalHandlers));
            DefaultEntityHelper entityMatcher = new DefaultEntityHelper(parameterResolvers, this.disablePayloadValidation);
            DefaultEventStore eventStore = new DefaultEventStore(client.getEventStoreClient(), client.getGatewayClient(MessageType.EVENT), this.serializer, dispatchInterceptors.get((Object)MessageType.EVENT), this.localHandlerRegistry(MessageType.EVENT, handlerDecorators, parameterResolvers, handlerRepositorySupplier));
            DefaultSnapshotStore snapshotStore = new DefaultSnapshotStore(client.getKeyValueClient(), this.snapshotSerializer, eventStore);
            NamedCache aggregateCache = new NamedCache(this.cache, id -> "$Aggregate:" + String.valueOf(id));
            AggregateRepository aggregateRepository = new DefaultAggregateRepository(eventStore, client.getEventStoreClient(), snapshotStore, aggregateCache, this.relationshipsCache, (DocumentStore)documentStore.get(), this.serializer, dispatchInterceptors.get((Object)MessageType.EVENT), entityMatcher);
            if (!this.disableAutomaticAggregateCaching) {
                aggregateRepository = new CachingAggregateRepository(aggregateRepository, client, aggregateCache, this.relationshipsCache, this.serializer);
            }
            DefaultRequestHandler defaultRequestHandler = new DefaultRequestHandler(client, MessageType.RESULT);
            DefaultErrorGateway errorGateway = new DefaultErrorGateway(this.createRequestGateway(client, MessageType.ERROR, null, defaultRequestHandler, dispatchInterceptors, handlerDecorators, parameterResolvers, handlerRepositorySupplier, this.defaultResponseMapper));
            if (!this.disableErrorReporting) {
                ErrorReportingInterceptor interceptor2 = new ErrorReportingInterceptor(errorGateway);
                Arrays.stream(MessageType.values()).forEach(type -> handlerDecorators.compute((MessageType)((Object)type), (t, i) -> interceptor2.andThen((HandlerDecorator)i)));
            }
            DefaultResultGateway resultGateway = new DefaultResultGateway(client.getGatewayClient(MessageType.RESULT), this.serializer, dispatchInterceptors.get((Object)MessageType.RESULT), this.defaultResponseMapper);
            DefaultCommandGateway commandGateway = new DefaultCommandGateway(this.createRequestGateway(client, MessageType.COMMAND, null, defaultRequestHandler, dispatchInterceptors, handlerDecorators, parameterResolvers, handlerRepositorySupplier, this.defaultResponseMapper));
            DefaultQueryGateway queryGateway = new DefaultQueryGateway(this.createRequestGateway(client, MessageType.QUERY, null, defaultRequestHandler, dispatchInterceptors, handlerDecorators, parameterResolvers, handlerRepositorySupplier, this.defaultResponseMapper));
            DefaultEventGateway eventGateway = new DefaultEventGateway(this.createRequestGateway(client, MessageType.EVENT, null, defaultRequestHandler, dispatchInterceptors, handlerDecorators, parameterResolvers, handlerRepositorySupplier, this.defaultResponseMapper));
            DefaultMetricsGateway metricsGateway = new DefaultMetricsGateway(this.createRequestGateway(client, MessageType.METRICS, null, defaultRequestHandler, dispatchInterceptors, handlerDecorators, parameterResolvers, handlerRepositorySupplier, this.defaultResponseMapper));
            DefaultRequestHandler webRequestHandler = new DefaultRequestHandler(client, MessageType.WEBRESPONSE);
            DefaultWebRequestGateway webRequestGateway = new DefaultWebRequestGateway(this.createRequestGateway(client, MessageType.WEBREQUEST, null, webRequestHandler, dispatchInterceptors, handlerDecorators, parameterResolvers, handlerRepositorySupplier, this.webResponseMapper));
            MemoizingFunction<String, GenericGateway> customGateways = ObjectUtils.memoize(topic -> this.createRequestGateway(client, MessageType.CUSTOM, (String)topic, defaultRequestHandler, dispatchInterceptors, handlerDecorators, (List<ParameterResolver<? super DeserializingMessage>>)parameterResolvers, handlerRepositorySupplier, this.defaultResponseMapper));
            Map<MessageType, Tracking> trackingMap = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> new DefaultTracking((MessageType)((Object)m), m == MessageType.WEBREQUEST ? webResponseGateway : resultGateway, (List)consumerConfigurations.get(m), this.generalBatchInterceptors.getOrDefault(m, List.of()), this.serializer, new DefaultHandlerFactory((MessageType)((Object)m), (HandlerDecorator)handlerDecorators.get((Object)(m == MessageType.NOTIFICATION ? MessageType.EVENT : m)), (List<ParameterResolver<? super DeserializingMessage>>)parameterResolvers, handlerRepositorySupplier))));
            DefaultScheduler scheduler = new DefaultScheduler(client.getSchedulingClient(), this.serializer, dispatchInterceptors.get((Object)MessageType.SCHEDULE), dispatchInterceptors.get((Object)MessageType.COMMAND), this.localHandlerRegistry(MessageType.SCHEDULE, handlerDecorators, parameterResolvers, handlerRepositorySupplier));
            if (!this.disableCacheEvictionMetrics) {
                new CacheEvictionsLogger(metricsGateway).register(this.cache);
            }
            ThrowingRunnable shutdownHandler = () -> {
                ForkJoinPool shutdownPool = new ForkJoinPool(MessageType.values().length);
                Optional.ofNullable(this.forwardingWebConsumer).ifPresent(ForwardingWebConsumer::close);
                shutdownPool.invokeAll(trackingMap.values().stream().map(t -> () -> {
                    t.close();
                    return null;
                }).collect(Collectors.toList()));
                Runnable[] runnableArray = new Runnable[3];
                runnableArray[0] = commandGateway::close;
                runnableArray[1] = queryGateway::close;
                runnableArray[2] = webRequestGateway::close;
                shutdownPool.invokeAll(Stream.of(runnableArray).map(t -> () -> {
                    t.run();
                    return null;
                }).collect(Collectors.toList()));
                defaultRequestHandler.close();
                webRequestHandler.close();
                this.cache.close();
                this.relationshipsCache.close();
                client.shutDown();
                shutdownPool.close();
            };
            FluxCapacitor fluxCapacitor = this.doBuild(trackingMap, customGateways, commandGateway, queryGateway, eventGateway, resultGateway, errorGateway, metricsGateway, webRequestGateway, aggregateRepository, snapshotStore, eventStore, keyValueStore, (DocumentStore)documentStore.get(), scheduler, this.userProvider, this.cache, this.serializer, this.correlationDataProvider, this.identityProvider, (propertySource = this.propertySource) instanceof DecryptingPropertySource ? (dps = (DecryptingPropertySource)propertySource) : new DecryptingPropertySource(this.propertySource), client, shutdownHandler);
            if (this.makeApplicationInstance) {
                FluxCapacitor.applicationInstance.set(fluxCapacitor);
            }
            Optional.ofNullable(this.forwardingWebConsumer).ifPresent(c -> c.start(fluxCapacitor));
            if (!this.disableScheduledCommandHandler) {
                fluxCapacitor.registerHandlers(new ScheduledCommandHandler());
            }
            if (!this.disableShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(fluxCapacitor::close, ObjectUtils.newThreadName("DefaultFluxCapacitor-shutdown")));
            }
            return fluxCapacitor;
        }

        protected FluxCapacitor doBuild(Map<MessageType, ? extends Tracking> trackingSupplier, Function<String, ? extends GenericGateway> customGatewaySupplier, CommandGateway commandGateway, QueryGateway queryGateway, EventGateway eventGateway, ResultGateway resultGateway, ErrorGateway errorGateway, MetricsGateway metricsGateway, WebRequestGateway webRequestGateway, AggregateRepository aggregateRepository, SnapshotStore snapshotStore, EventStore eventStore, KeyValueStore keyValueStore, DocumentStore documentStore, Scheduler scheduler, UserProvider userProvider, Cache cache, Serializer serializer, CorrelationDataProvider correlationDataProvider, IdentityProvider identityProvider, PropertySource propertySource, Client client, ThrowingRunnable shutdownHandler) {
            return new DefaultFluxCapacitor(trackingSupplier, customGatewaySupplier, commandGateway, queryGateway, eventGateway, resultGateway, errorGateway, metricsGateway, webRequestGateway, aggregateRepository, snapshotStore, eventStore, keyValueStore, documentStore, scheduler, userProvider, cache, serializer, correlationDataProvider, identityProvider, propertySource, client, shutdownHandler);
        }

        protected ConsumerConfiguration getDefaultConsumerConfiguration(MessageType messageType) {
            return ConsumerConfiguration.builder().name(messageType.name()).ignoreSegment(messageType == MessageType.NOTIFICATION).clientControlledIndex(messageType == MessageType.NOTIFICATION).build();
        }

        protected GenericGateway createRequestGateway(Client client, MessageType messageType, String topic, RequestHandler requestHandler, Map<MessageType, DispatchInterceptor> dispatchInterceptors, Map<MessageType, HandlerDecorator> handlerDecorators, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, Function<Class<?>, HandlerRepository> handlerRepositorySupplier, ResponseMapper responseMapper) {
            return new DefaultGenericGateway(client.getGatewayClient(messageType, topic), requestHandler, this.serializer, dispatchInterceptors.get((Object)messageType), messageType, topic, this.localHandlerRegistry(messageType, handlerDecorators, parameterResolvers, handlerRepositorySupplier), responseMapper);
        }

        protected HandlerRegistry localHandlerRegistry(MessageType messageType, Map<MessageType, HandlerDecorator> handlerDecorators, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, Function<Class<?>, HandlerRepository> handlerRepositorySupplier) {
            return switch (messageType) {
                case MessageType.EVENT -> new LocalHandlerRegistry(new DefaultHandlerFactory(messageType, handlerDecorators.get((Object)messageType), parameterResolvers, handlerRepositorySupplier)).andThen(new LocalHandlerRegistry(new DefaultHandlerFactory(MessageType.NOTIFICATION, handlerDecorators.get((Object)MessageType.EVENT), parameterResolvers, handlerRepositorySupplier)));
                default -> new LocalHandlerRegistry(new DefaultHandlerFactory(messageType, handlerDecorators.get((Object)messageType), parameterResolvers, handlerRepositorySupplier));
            };
        }

        private static /* synthetic */ void lambda$build$22(Map handlerDecorators, ValidatingInterceptor interceptor, MessageType type) {
            handlerDecorators.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
        }

        private static /* synthetic */ void lambda$build$18(Map dispatchInterceptors, DataProtectionInterceptor interceptor, Map handlerDecorators, MessageType type) {
            dispatchInterceptors.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
            handlerDecorators.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
        }

        private static /* synthetic */ void lambda$build$15(Map dispatchInterceptors, AuthenticatingInterceptor interceptor, Map handlerDecorators, MessageType type) {
            dispatchInterceptors.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
            handlerDecorators.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
        }
    }
}

