/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MemoizingBiFunction;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.ClientDispatchMonitor;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements Client {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    private final Map<MessageType, List<Map.Entry<ClientDispatchMonitor, Registration>>> monitors = new ConcurrentHashMap<MessageType, List<Map.Entry<ClientDispatchMonitor, Registration>>>();
    private final MemoizingBiFunction<MessageType, String, ? extends GatewayClient> gatewayClients = ObjectUtils.memoize(this::createGatewayClient);
    private final MemoizingBiFunction<MessageType, String, ? extends TrackingClient> trackingClients = ObjectUtils.memoize(this::createTrackingClient);
    private final AtomicReference<Object> eventStoreClient = new AtomicReference();
    private final AtomicReference<Object> schedulingClient = new AtomicReference();
    private final AtomicReference<Object> keyValueClient = new AtomicReference();
    private final AtomicReference<Object> searchClient = new AtomicReference();
    protected final Set<Runnable> shutdownTasks = new CopyOnWriteArraySet<Runnable>();

    protected abstract GatewayClient createGatewayClient(MessageType var1, String var2);

    protected abstract TrackingClient createTrackingClient(MessageType var1, String var2);

    protected abstract EventStoreClient createEventStoreClient();

    protected abstract SchedulingClient createSchedulingClient();

    protected abstract KeyValueClient createKeyValueClient();

    protected abstract SearchClient createSearchClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayClient getGatewayClient(MessageType messageType, String topic) {
        switch (messageType) {
            case DOCUMENT: 
            case CUSTOM: {
                Objects.requireNonNull(topic);
                break;
            }
            default: {
                if (topic == null) break;
                throw new IllegalArgumentException("Topic is not supported for message type: " + String.valueOf((Object)messageType));
            }
        }
        if (!this.gatewayClients.isCached(messageType, topic)) {
            MemoizingBiFunction<MessageType, String, ? extends GatewayClient> memoizingBiFunction = this.gatewayClients;
            synchronized (memoizingBiFunction) {
                if (!this.gatewayClients.isCached(messageType, topic)) {
                    GatewayClient result = (GatewayClient)this.gatewayClients.apply(messageType, topic);
                    this.monitors.getOrDefault((Object)messageType, Collections.emptyList()).forEach(entry -> entry.setValue(result.registerMonitor(messages -> ((ClientDispatchMonitor)entry.getKey()).accept(messageType, topic, (List<SerializedMessage>)messages))));
                    return result;
                }
            }
        }
        return (GatewayClient)this.gatewayClients.apply(messageType, topic);
    }

    @Override
    public Registration monitorDispatch(ClientDispatchMonitor monitor, MessageType ... messageTypes) {
        if (messageTypes.length == 0) {
            messageTypes = MessageType.values();
        }
        return Arrays.stream(messageTypes).map(t -> {
            List list = this.monitors.computeIfAbsent((MessageType)((Object)t), k -> new CopyOnWriteArrayList());
            AbstractMap.SimpleEntry<ClientDispatchMonitor, Object> entry = new AbstractMap.SimpleEntry<ClientDispatchMonitor, Object>(monitor, null);
            list.add(entry);
            return () -> {
                list.remove(entry);
                Optional.ofNullable((Registration)entry.getValue()).ifPresent(Registration::cancel);
            };
        }).reduce(Registration::merge).orElseGet(Registration::noOp);
    }

    @Override
    public TrackingClient getTrackingClient(MessageType messageType, String topic) {
        switch (messageType) {
            case DOCUMENT: 
            case CUSTOM: {
                Objects.requireNonNull(topic);
                break;
            }
            default: {
                topic = null;
            }
        }
        return (TrackingClient)this.trackingClients.apply(messageType, topic);
    }

    @Override
    public void shutDown() {
        this.shutdownTasks.forEach(ObjectUtils::tryRun);
        this.trackingClients.forEach(ObjectUtils.asConsumer(AutoCloseable::close));
        this.gatewayClients.forEach(ObjectUtils.asConsumer(AutoCloseable::close));
        this.getEventStoreClient().close();
        this.getSchedulingClient().close();
        this.getKeyValueClient().close();
        this.getSearchClient().close();
    }

    @Override
    public Registration beforeShutdown(Runnable task) {
        this.shutdownTasks.add(task);
        return () -> this.shutdownTasks.remove(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public EventStoreClient getEventStoreClient() {
        Object $value = this.eventStoreClient.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.eventStoreClient;
            synchronized (atomicReference) {
                $value = this.eventStoreClient.get();
                if ($value == null) {
                    EventStoreClient actualValue = this.createEventStoreClient();
                    $value = actualValue == null ? this.eventStoreClient : actualValue;
                    this.eventStoreClient.set($value);
                }
            }
        }
        return (EventStoreClient)($value == this.eventStoreClient ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public SchedulingClient getSchedulingClient() {
        Object $value = this.schedulingClient.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.schedulingClient;
            synchronized (atomicReference) {
                $value = this.schedulingClient.get();
                if ($value == null) {
                    SchedulingClient actualValue = this.createSchedulingClient();
                    $value = actualValue == null ? this.schedulingClient : actualValue;
                    this.schedulingClient.set($value);
                }
            }
        }
        return (SchedulingClient)($value == this.schedulingClient ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public KeyValueClient getKeyValueClient() {
        Object $value = this.keyValueClient.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.keyValueClient;
            synchronized (atomicReference) {
                $value = this.keyValueClient.get();
                if ($value == null) {
                    KeyValueClient actualValue = this.createKeyValueClient();
                    $value = actualValue == null ? this.keyValueClient : actualValue;
                    this.keyValueClient.set($value);
                }
            }
        }
        return (KeyValueClient)($value == this.keyValueClient ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public SearchClient getSearchClient() {
        Object $value = this.searchClient.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.searchClient;
            synchronized (atomicReference) {
                $value = this.searchClient.get();
                if ($value == null) {
                    SearchClient actualValue = this.createSearchClient();
                    $value = actualValue == null ? this.searchClient : actualValue;
                    this.searchClient.set($value);
                }
            }
        }
        return (SearchClient)($value == this.searchClient ? null : $value);
    }
}

