/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.caching;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.CacheEvictionEvent;
import io.fluxcapacitor.javaclient.persisting.caching.DefaultCache;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;

public class SelectiveCache
implements Cache {
    private final Cache delegate;
    private final Predicate<Object> selector;
    private final Cache nextCache;

    public static Predicate<Object> aggregateSelector(Class<?> type) {
        return v -> {
            if (v instanceof Entity) {
                Entity aggregateRoot = (Entity)v;
                return Optional.ofNullable(aggregateRoot.get()).map(r -> type.isAssignableFrom(r.getClass())).orElseGet(() -> type.isAssignableFrom(aggregateRoot.type()));
            }
            return false;
        };
    }

    public SelectiveCache(Cache nextCache, Predicate<Object> selector) {
        this(new DefaultCache(), selector, nextCache);
    }

    @Override
    public Object put(Object id, Object value) {
        if (this.selector.test(value)) {
            Object delegateValue = this.delegate.put(id, value);
            Object nextCacheValue = this.nextCache.remove(id);
            return delegateValue == null ? nextCacheValue : delegateValue;
        }
        Object nextCacheValue = this.nextCache.put(id, value);
        Object delegateValue = this.delegate.remove(id);
        return nextCacheValue == null ? delegateValue : nextCacheValue;
    }

    @Override
    public Object putIfAbsent(Object id, Object value) {
        if (this.selector.test(value)) {
            Object delegateValue = this.delegate.putIfAbsent(id, value);
            Object nextCacheValue = this.nextCache.remove(id);
            return delegateValue == null ? nextCacheValue : delegateValue;
        }
        Object nextCacheValue = this.nextCache.putIfAbsent(id, value);
        Object delegateValue = this.delegate.remove(id);
        return nextCacheValue == null ? delegateValue : nextCacheValue;
    }

    @Override
    public <T> T computeIfAbsent(Object id, Function<? super Object, T> mappingFunction) {
        return (T)this.compute(id, (k, v) -> v == null ? mappingFunction.apply(id) : v);
    }

    @Override
    public <T> T computeIfPresent(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return (T)this.compute(id, (k, v) -> v == null ? null : mappingFunction.apply(k, v));
    }

    @Override
    public <T> T compute(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        AtomicReference result = new AtomicReference();
        Object nextCacheResult = this.nextCache.compute(id, (k, v) -> {
            Object delegateResult = this.delegate.compute(id, (k2, v2) -> {
                Object r = mappingFunction.apply(id, v2 == null ? v : v2);
                result.set(r);
                if (this.selector.test(r)) {
                    return r;
                }
                return null;
            });
            if (this.selector.test(delegateResult)) {
                result.set(delegateResult);
                return null;
            }
            return result.get();
        });
        return (T)(nextCacheResult == null ? result.get() : nextCacheResult);
    }

    @Override
    public <T> T get(Object id) {
        return (T)Optional.ofNullable(this.delegate.get(id)).orElseGet(() -> this.nextCache.get(id));
    }

    @Override
    public boolean containsKey(Object id) {
        return this.delegate.containsKey(id) || this.nextCache.containsKey(id);
    }

    @Override
    public <T> T remove(Object id) {
        Object delegateValue = this.delegate.remove(id);
        Object nextCacheValue = this.nextCache.remove(id);
        return delegateValue == null ? nextCacheValue : delegateValue;
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.nextCache.clear();
    }

    @Override
    public <T> void modifyEach(BiFunction<? super Object, ? super T, ? extends T> modifierFunction) {
        this.delegate.modifyEach(modifierFunction);
        this.nextCache.modifyEach(modifierFunction);
    }

    @Override
    public int size() {
        return this.delegate.size() + this.nextCache.size();
    }

    @Override
    public Registration registerEvictionListener(Consumer<CacheEvictionEvent> listener) {
        return this.delegate.registerEvictionListener(listener).merge(this.nextCache.registerEvictionListener(listener));
    }

    @Override
    public void close() {
        this.delegate.close();
        this.nextCache.close();
    }

    @ConstructorProperties(value={"delegate", "selector", "nextCache"})
    @Generated
    public SelectiveCache(Cache delegate, Predicate<Object> selector, Cache nextCache) {
        this.delegate = delegate;
        this.selector = selector;
        this.nextCache = nextCache;
    }
}

