/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.GetRelationships;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.api.modeling.RepairRelationships;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.tracking.client.InMemoryMessageStore;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class InMemoryEventStore
extends InMemoryMessageStore
implements EventStoreClient {
    private final Map<String, List<SerializedMessage>> appliedEvents = new ConcurrentHashMap<String, List<SerializedMessage>>();
    private final Map<String, Map<String, String>> relationships = new ConcurrentHashMap<String, Map<String, String>>();

    public InMemoryEventStore() {
        this(Duration.ofMinutes(2L));
    }

    public InMemoryEventStore(Duration messageExpiration) {
        super(MessageType.EVENT, messageExpiration);
    }

    @Override
    public CompletableFuture<Void> storeEvents(String aggregateId, List<SerializedMessage> events, boolean storeOnly, Guarantee guarantee) {
        this.appliedEvents.computeIfAbsent(aggregateId, id -> new CopyOnWriteArrayList()).addAll(events);
        if (storeOnly) {
            return CompletableFuture.completedFuture(null);
        }
        return super.append(events);
    }

    @Override
    public CompletableFuture<Void> updateRelationships(UpdateRelationships request) {
        Function<Relationship, Map> computeIfAbsent = r -> this.relationships.computeIfAbsent(r.getEntityId(), entityId -> Collections.synchronizedMap(new LinkedHashMap()));
        request.getDissociations().forEach(r -> ((Map)computeIfAbsent.apply((Relationship)r)).remove(r.getAggregateId()));
        request.getAssociations().forEach(r -> ((Map)computeIfAbsent.apply((Relationship)r)).put(r.getAggregateId(), r.getAggregateType()));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> repairRelationships(RepairRelationships request) {
        this.relationships.values().forEach(mapping -> mapping.remove(request.getAggregateId()));
        this.relationships.values().removeIf(Map::isEmpty);
        request.getEntityIds().forEach(e -> this.relationships.computeIfAbsent((String)e, entityId -> Collections.synchronizedMap(new LinkedHashMap())).put(request.getAggregateId(), request.getAggregateType()));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public AggregateEventStream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber, int maxSize) {
        List allEvents = this.appliedEvents.getOrDefault(aggregateId, Collections.emptyList());
        List<Object> section = allEvents.subList(Math.min(1 + (int)lastSequenceNumber, allEvents.size()), allEvents.size());
        if (maxSize > 0) {
            section = section.stream().limit(maxSize).toList();
        }
        long maxSequenceNumber = lastSequenceNumber + (long)section.size();
        return new AggregateEventStream<SerializedMessage>(section.stream(), aggregateId, () -> maxSequenceNumber);
    }

    @Override
    public CompletableFuture<Void> deleteEvents(String aggregateId, Guarantee guarantee) {
        this.appliedEvents.remove(aggregateId);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Map<String, String> getAggregateIds(GetAggregateIds request) {
        return Map.copyOf(this.relationships.getOrDefault(request.getEntityId(), Collections.emptyMap()));
    }

    @Override
    public List<Relationship> getRelationships(GetRelationships request) {
        return this.relationships.getOrDefault(request.getEntityId(), Collections.emptyMap()).entrySet().stream().map(e -> Relationship.builder().entityId(request.getEntityId()).aggregateId((String)e.getKey()).aggregateType((String)e.getValue()).build()).toList();
    }

    @Override
    public String toString() {
        return "InMemoryEventStore";
    }
}

