/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.repository;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.api.modeling.RepairRelationships;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Aggregate;
import io.fluxcapacitor.javaclient.modeling.AppliedEvent;
import io.fluxcapacitor.javaclient.modeling.DefaultEntityHelper;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.EventPublication;
import io.fluxcapacitor.javaclient.modeling.EventPublicationStrategy;
import io.fluxcapacitor.javaclient.modeling.ImmutableAggregateRoot;
import io.fluxcapacitor.javaclient.modeling.ImmutableEntity;
import io.fluxcapacitor.javaclient.modeling.ModifiableAggregateRoot;
import io.fluxcapacitor.javaclient.modeling.NoOpEntity;
import io.fluxcapacitor.javaclient.modeling.SideEffectFreeEntity;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.NoOpCache;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.NoOpSnapshotStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.NoSnapshotTrigger;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.PeriodicSnapshotTrigger;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotTrigger;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.repository.AggregateRepository;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAggregateRepository
implements AggregateRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAggregateRepository.class);
    private final EventStore eventStore;
    private final EventStoreClient eventStoreClient;
    private final SnapshotStore snapshotStore;
    private final Cache aggregateCache;
    private final Cache relationshipsCache;
    private final DocumentStore documentStore;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final EntityHelper entityHelper;
    private final Function<Class<?>, AnnotatedAggregateRepository<?>> delegates = ObjectUtils.memoize(x$0 -> new AnnotatedAggregateRepository(x$0));

    @Override
    public <T> Entity<T> load(@NonNull Object aggregateId, Class<T> type) {
        if (aggregateId == null) {
            throw new NullPointerException("aggregateId is marked non-null but is null");
        }
        if (Entity.isLoading()) {
            return new NoOpEntity(() -> this.delegates.apply(type).load(aggregateId));
        }
        return this.delegates.apply(type).load(aggregateId);
    }

    @Override
    public <T> Entity<T> loadFor(@NonNull Object entityId, Class<?> defaultType) {
        Entity<?> result;
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        Map<String, Class<?>> aggregates = this.getAggregatesFor(entityId);
        if (aggregates.isEmpty()) {
            return this.load(entityId, defaultType);
        }
        if (aggregates.containsKey(entityId.toString()) && !(result = this.load(entityId, aggregates.get(entityId.toString()))).isEmpty()) {
            return result;
        }
        if (aggregates.size() > 1) {
            log.debug("Found multiple aggregates containing entity {}. Loading the most recent one.", entityId);
        }
        return aggregates.entrySet().stream().filter(e -> !Void.class.equals(e.getValue())).reduce((a, b) -> b).map(e -> this.load(e.getKey(), (Class)e.getValue())).orElseGet(() -> this.load(entityId, defaultType));
    }

    @Override
    public <T> Entity<T> asEntity(T entityValue) {
        AnnotatedAggregateRepository<?> repository = this.delegates.apply(entityValue == null ? Object.class : entityValue.getClass());
        return repository.fromValue(entityValue);
    }

    @Override
    public Map<String, Class<?>> getAggregatesFor(@NonNull Object entityId) {
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        LinkedHashMap result = new LinkedHashMap(ModifiableAggregateRoot.getActiveAggregatesFor(entityId));
        this.relationshipsCache.computeIfAbsent(entityId.toString(), id -> this.eventStoreClient.getAggregatesFor(id.toString()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ReflectionUtils.classForName(this.serializer.upcastType((String)e.getValue()), Void.class), (a, b) -> b, LinkedHashMap::new))).entrySet().forEach(e -> result.putIfAbsent((String)e.getKey(), (Class)e.getValue()));
        return result;
    }

    @Override
    public CompletableFuture<Void> deleteAggregate(Object aggregateId) {
        Class<Void> type = this.getAggregatesFor(aggregateId).getOrDefault(aggregateId.toString(), Void.class);
        return this.delegates.apply(type).delete(aggregateId);
    }

    @Override
    public CompletableFuture<Void> repairRelationships(Entity<?> aggregate) {
        aggregate = aggregate.root();
        return this.eventStoreClient.repairRelationships(new RepairRelationships(aggregate.id().toString(), aggregate.type().getName(), aggregate.relationships().stream().map(Relationship::getEntityId).collect(Collectors.toSet()), Guarantee.STORED));
    }

    @ConstructorProperties(value={"eventStore", "eventStoreClient", "snapshotStore", "aggregateCache", "relationshipsCache", "documentStore", "serializer", "dispatchInterceptor", "entityHelper"})
    @Generated
    public DefaultAggregateRepository(EventStore eventStore, EventStoreClient eventStoreClient, SnapshotStore snapshotStore, Cache aggregateCache, Cache relationshipsCache, DocumentStore documentStore, Serializer serializer, DispatchInterceptor dispatchInterceptor, EntityHelper entityHelper) {
        this.eventStore = eventStore;
        this.eventStoreClient = eventStoreClient;
        this.snapshotStore = snapshotStore;
        this.aggregateCache = aggregateCache;
        this.relationshipsCache = relationshipsCache;
        this.documentStore = documentStore;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.entityHelper = entityHelper;
    }

    @Generated
    private EventStore eventStore() {
        return this.eventStore;
    }

    @Generated
    private EventStoreClient eventStoreClient() {
        return this.eventStoreClient;
    }

    @Generated
    private SnapshotStore snapshotStore() {
        return this.snapshotStore;
    }

    @Generated
    private Cache aggregateCache() {
        return this.aggregateCache;
    }

    @Generated
    private Cache relationshipsCache() {
        return this.relationshipsCache;
    }

    @Generated
    private DocumentStore documentStore() {
        return this.documentStore;
    }

    @Generated
    private Serializer serializer() {
        return this.serializer;
    }

    @Generated
    private DispatchInterceptor dispatchInterceptor() {
        return this.dispatchInterceptor;
    }

    @Generated
    private EntityHelper entityHelper() {
        return this.entityHelper;
    }

    @Generated
    private Function<Class<?>, AnnotatedAggregateRepository<?>> delegates() {
        return this.delegates;
    }

    public class AnnotatedAggregateRepository<T> {
        private final Class<T> type;
        private final Cache aggregateCache;
        private final Cache relationshipsCache;
        private final boolean eventSourced;
        private final boolean commitInBatch;
        private final EventPublication eventPublication;
        private final EventPublicationStrategy publicationStrategy;
        private final SnapshotTrigger snapshotTrigger;
        private final SnapshotStore snapshotStore;
        private final boolean searchable;
        private final String collection;
        private final Function<Entity<?>, Instant> timestampFunction;
        private final Function<Entity<?>, Instant> endFunction;
        private final String idProperty;
        private final boolean ignoreUnknownEvents;

        public AnnotatedAggregateRepository(Class<T> type) {
            this.type = type;
            Aggregate annotation = DefaultEntityHelper.getRootAnnotation(type);
            this.aggregateCache = annotation.cached() ? DefaultAggregateRepository.this.aggregateCache : NoOpCache.INSTANCE;
            this.relationshipsCache = annotation.cached() ? DefaultAggregateRepository.this.relationshipsCache : NoOpCache.INSTANCE;
            this.eventSourced = annotation.eventSourced();
            this.commitInBatch = annotation.commitInBatch();
            this.eventPublication = annotation.eventPublication();
            this.publicationStrategy = annotation.publicationStrategy();
            int snapshotPeriod = annotation.eventSourced() || annotation.searchable() ? annotation.snapshotPeriod() : 1;
            this.snapshotTrigger = snapshotPeriod > 0 ? new PeriodicSnapshotTrigger(snapshotPeriod) : NoSnapshotTrigger.INSTANCE;
            this.snapshotStore = snapshotPeriod > 0 ? DefaultAggregateRepository.this.snapshotStore : NoOpSnapshotStore.INSTANCE;
            this.searchable = annotation.searchable();
            this.collection = Optional.of(annotation).map(Aggregate::collection).filter(s -> !s.isEmpty()).orElse(type.getSimpleName());
            this.idProperty = ReflectionUtils.getAnnotatedProperty(type, EntityId.class).map(ReflectionUtils::getName).orElse(null);
            AtomicBoolean warnedAboutMissingTimePath = new AtomicBoolean();
            this.timestampFunction = Optional.of(annotation).map(Aggregate::timestampPath).filter(s -> !s.isBlank()).map(s -> aggregateRoot -> ReflectionUtils.readProperty(s, aggregateRoot.get()).map(t -> Instant.from((TemporalAccessor)t)).orElseGet(() -> {
                if (aggregateRoot.isPresent()) {
                    if (ReflectionUtils.hasProperty(s, aggregateRoot.get())) {
                        return null;
                    }
                    if (warnedAboutMissingTimePath.compareAndSet(false, true)) {
                        log.warn("Aggregate type {} does not declare a timestamp property at '{}'", (Object)aggregateRoot.get().getClass().getSimpleName(), s);
                    }
                }
                return aggregateRoot.timestamp();
            })).orElse(Entity::timestamp);
            AtomicBoolean warnedAboutMissingEndPath = new AtomicBoolean();
            this.endFunction = Optional.of(annotation).map(Aggregate::endPath).filter(s -> !s.isBlank()).map(s -> aggregateRoot -> ReflectionUtils.readProperty(s, aggregateRoot.get()).map(t -> Instant.from((TemporalAccessor)t)).orElseGet(() -> {
                if (aggregateRoot.isPresent()) {
                    if (ReflectionUtils.hasProperty(s, aggregateRoot.get())) {
                        return null;
                    }
                    if (warnedAboutMissingEndPath.compareAndSet(false, true)) {
                        log.warn("Aggregate type {} does not declare an end timestamp property at '{}'", (Object)aggregateRoot.get().getClass().getSimpleName(), s);
                    }
                }
                return aggregateRoot.timestamp();
            })).orElse(this.timestampFunction);
            this.ignoreUnknownEvents = annotation.ignoreUnknownEvents();
        }

        public Entity<T> fromValue(T value) {
            return new SideEffectFreeEntity(((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableEntity.ImmutableEntityBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)ImmutableAggregateRoot.builder().idProperty(this.idProperty)).id(ReflectionUtils.readProperty(this.idProperty, value).orElse(null))).value(value)).type(value != null ? value.getClass() : Object.class)).timestamp(FluxCapacitor.currentTime())).entityHelper(DefaultAggregateRepository.this.entityHelper)).eventStore(DefaultAggregateRepository.this.eventStore)).serializer(DefaultAggregateRepository.this.serializer)).sequenceNumber(0L)).build());
        }

        public CompletableFuture<Void> delete(Object id) {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            String aggregateId = id.toString();
            this.aggregateCache.remove(aggregateId);
            this.relationshipsCache.modifyEach((entityId, map) -> {
                map.remove(aggregateId);
                return map.isEmpty() ? null : map;
            });
            futures.add(DefaultAggregateRepository.this.eventStoreClient.repairRelationships(new RepairRelationships(aggregateId, this.type.getName(), Collections.emptySet(), Guarantee.STORED)));
            futures.add(DefaultAggregateRepository.this.eventStoreClient.deleteEvents(aggregateId, Guarantee.STORED));
            futures.add(this.snapshotStore.deleteSnapshot(id));
            if (this.searchable) {
                futures.add(DefaultAggregateRepository.this.documentStore.deleteDocument(id, this.collection));
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        }

        public Entity<T> load(Object id) {
            return ModifiableAggregateRoot.load(id, () -> this.aggregateCache.compute(id.toString(), (stringId, v) -> {
                if (v != null) {
                    if (this.type.isAssignableFrom(v.type())) {
                        return v;
                    }
                    if (v.isPresent()) {
                        log.warn("Cache already contains a non-empty aggregate with id {} of type {} that is not assignable to requested type {}. This is likely to cause issues. Loading the aggregate again..", id, v.type(), this.type);
                    }
                }
                return this.eventSourceModel(this.loadSnapshot(id));
            }), this.commitInBatch, this.eventPublication, this.publicationStrategy, DefaultAggregateRepository.this.entityHelper, DefaultAggregateRepository.this.serializer, DefaultAggregateRepository.this.dispatchInterceptor, this::commit);
        }

        protected Entity<T> loadSnapshot(Object id) {
            Object builder = ((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)ImmutableAggregateRoot.builder().id(id)).type(this.type)).idProperty(this.idProperty)).entityHelper(DefaultAggregateRepository.this.entityHelper)).serializer(DefaultAggregateRepository.this.serializer)).eventStore(DefaultAggregateRepository.this.eventStore);
            return (this.searchable && !this.eventSourced ? DefaultAggregateRepository.this.documentStore.fetchDocument(id, this.collection).map(d -> ((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)builder.value(d)).build()) : this.snapshotStore.getSnapshot(id).map(a -> ImmutableAggregateRoot.from(a, DefaultAggregateRepository.this.entityHelper, DefaultAggregateRepository.this.serializer, DefaultAggregateRepository.this.eventStore))).filter(a -> {
                boolean assignable;
                boolean bl = assignable = a.get() == null || this.type.isAssignableFrom(a.get().getClass());
                if (!assignable) {
                    log.warn("Stored aggregate snapshot with id {} of type {} is not assignable to the requested type {}. Ignoring the snapshot.", id, a.type(), this.type);
                }
                return assignable;
            }).map(a -> a).orElseGet(() -> builder.build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Entity<T> eventSourceModel(Entity<T> model) {
            try {
                if (!this.eventSourced) return model;
                AggregateEventStream<DeserializingMessage> eventStream = DefaultAggregateRepository.this.eventStore.getEvents(model.id().toString(), model.sequenceNumber(), -1, this.ignoreUnknownEvents);
                Iterator<DeserializingMessage> iterator2 = eventStream.iterator();
                boolean wasLoading = Entity.isLoading();
                try {
                    Entity.loading.set(true);
                    while (iterator2.hasNext()) {
                        Class<?> t;
                        DeserializingMessage next = iterator2.next();
                        if (model.isEmpty() && (t = Entity.getAggregateType(next)) != null && !t.equals(this.type) && this.type.isAssignableFrom(t)) {
                            model = model.withType(t);
                        }
                        try {
                            model = model.apply(next);
                        }
                        catch (Throwable e) {
                            throw new EventSourcingException(String.format("Failed to apply event %s to aggregate %s.", next.getIndex(), model.id()), e);
                        }
                    }
                    return model.withSequenceNumber(eventStream.getLastSequenceNumber().orElse(model.sequenceNumber()));
                }
                finally {
                    Entity.loading.set(wasLoading);
                }
            }
            catch (EventSourcingException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new EventSourcingException("Failed to apply events to aggregate " + String.valueOf(model.id()), e);
            }
        }

        public void commit(Entity<?> after, List<AppliedEvent> unpublishedEvents, Entity<?> before) {
            if (after.type() != null && !Objects.equals(after.type(), this.type)) {
                DefaultAggregateRepository.this.delegates.apply(after.type()).commit(after, unpublishedEvents, before);
                return;
            }
            try {
                this.aggregateCache.compute(after.id().toString(), (stringId, current) -> current == null || Objects.equals(before.lastEventId(), current.lastEventId()) || unpublishedEvents.isEmpty() ? after : current.apply(unpublishedEvents.stream().map(AppliedEvent::getEvent).toList()));
                Set<Relationship> associations = after.associations(before);
                Set<Relationship> dissociations = after.dissociations(before);
                dissociations.forEach(r -> this.relationshipsCache.computeIfPresent(r.getEntityId(), (id, map) -> {
                    map.remove(r.getAggregateId());
                    return map;
                }));
                associations.forEach(r -> this.relationshipsCache.computeIfPresent(r.getEntityId(), (id, map) -> {
                    map.put(r.getAggregateId(), after.type());
                    return map;
                }));
                if (!associations.isEmpty() || !dissociations.isEmpty()) {
                    DefaultAggregateRepository.this.eventStoreClient.updateRelationships(new UpdateRelationships(associations, dissociations, Guarantee.STORED)).get();
                }
                if (!unpublishedEvents.isEmpty()) {
                    this.storeEvents(after.id().toString(), unpublishedEvents);
                    if (this.snapshotTrigger.shouldCreateSnapshot(after, unpublishedEvents)) {
                        this.snapshotStore.storeSnapshot(after);
                    }
                }
                if (this.searchable) {
                    Object value = after.get();
                    if (value == null) {
                        DefaultAggregateRepository.this.documentStore.deleteDocument(after.id().toString(), this.collection);
                    } else {
                        DefaultAggregateRepository.this.documentStore.index(value, (Object)after.id().toString(), (Object)this.collection, this.timestampFunction.apply(after), this.endFunction.apply(after)).get();
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to commit aggregate {}", after.id(), (Object)e);
                this.aggregateCache.remove(after.id().toString());
            }
        }

        void storeEvents(String aggregateId, List<AppliedEvent> appliedEvents) {
            FluxCapacitor.getOptionally().ifPresent(fc -> appliedEvents.forEach(e -> e.getEvent().getSerializedObject().setSource(fc.client().id())));
            ArrayList<AppliedEvent> currentBatch = new ArrayList<AppliedEvent>();
            EventPublicationStrategy currentStrategy = null;
            for (AppliedEvent event : appliedEvents) {
                if (event.getPublicationStrategy() != currentStrategy && currentStrategy != null) {
                    DefaultAggregateRepository.this.eventStore.storeEvents((Object)aggregateId, currentBatch.stream().map(AppliedEvent::getEvent).toList(), currentStrategy).get();
                    currentBatch.clear();
                }
                currentStrategy = event.getPublicationStrategy();
                currentBatch.add(event);
            }
            if (!currentBatch.isEmpty()) {
                DefaultAggregateRepository.this.eventStore.storeEvents((Object)aggregateId, currentBatch.stream().map(AppliedEvent::getEvent).toList(), currentStrategy).get();
            }
        }
    }
}

