/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.SearchParameters;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.persisting.search.IndexOperation;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;

public class DefaultIndexOperation
implements IndexOperation {
    final transient DocumentStore documentStore;
    final Object value;
    @NonNull
    Object collection;
    @NonNull
    Object id;
    @NonNull
    Metadata metadata = Metadata.empty();
    Instant start;
    Instant end;
    boolean ifNotExists;

    public DefaultIndexOperation(DocumentStore documentStore, @NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        SearchParameters searchParams = Optional.ofNullable(ClientUtils.getSearchParameters(object.getClass())).orElse(SearchParameters.defaultSearchParameters);
        this.documentStore = documentStore;
        this.value = object;
        this.collection = Optional.ofNullable(searchParams.getCollection()).orElseGet(object.getClass()::getSimpleName);
        this.start = ReflectionUtils.readProperty(searchParams.getTimestampPath(), object).orElse(null);
        this.end = ReflectionUtils.hasProperty(searchParams.getEndPath(), object) ? (Instant)ReflectionUtils.readProperty(searchParams.getEndPath(), object).orElse(null) : this.start;
        this.id = ReflectionUtils.getAnnotatedPropertyValue(object, EntityId.class).map(Object::toString).orElseGet(() -> FluxCapacitor.currentIdentityProvider().nextTechnicalId());
    }

    @Override
    public CompletableFuture<Void> index(Guarantee guarantee) {
        return this.documentStore.index(this.value, this.id, this.collection, this.start, this.end, this.metadata, guarantee, this.ifNotExists);
    }

    @Override
    public IndexOperation copy() {
        return new DefaultIndexOperation(this.documentStore, this.value, this.collection, this.id, this.metadata, this.start, this.end, this.ifNotExists);
    }

    @Generated
    public DocumentStore documentStore() {
        return this.documentStore;
    }

    @Generated
    public Object value() {
        return this.value;
    }

    @NonNull
    @Generated
    public Object collection() {
        return this.collection;
    }

    @Override
    @NonNull
    @Generated
    public Object id() {
        return this.id;
    }

    @Override
    @NonNull
    @Generated
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    @Generated
    public Instant start() {
        return this.start;
    }

    @Override
    @Generated
    public Instant end() {
        return this.end;
    }

    @Override
    @Generated
    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Generated
    public DefaultIndexOperation collection(@NonNull Object collection) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        this.collection = collection;
        return this;
    }

    @Override
    @Generated
    public DefaultIndexOperation id(@NonNull Object id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        return this;
    }

    @Override
    @Generated
    public DefaultIndexOperation metadata(@NonNull Metadata metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.metadata = metadata;
        return this;
    }

    @Override
    @Generated
    public DefaultIndexOperation start(Instant start) {
        this.start = start;
        return this;
    }

    @Override
    @Generated
    public DefaultIndexOperation end(Instant end) {
        this.end = end;
        return this;
    }

    @Override
    @Generated
    public DefaultIndexOperation ifNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultIndexOperation)) {
            return false;
        }
        DefaultIndexOperation other = (DefaultIndexOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.ifNotExists() != other.ifNotExists()) {
            return false;
        }
        Object this$value = this.value();
        Object other$value = other.value();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Object this$collection = this.collection();
        Object other$collection = other.collection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        Object this$id = this.id();
        Object other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Metadata this$metadata = this.metadata();
        Metadata other$metadata = other.metadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Instant this$start = this.start();
        Instant other$start = other.start();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Instant this$end = this.end();
        Instant other$end = other.end();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultIndexOperation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ifNotExists() ? 79 : 97);
        Object $value = this.value();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Object $collection = this.collection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        Object $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Metadata $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Instant $start = this.start();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Instant $end = this.end();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultIndexOperation(documentStore=" + String.valueOf(this.documentStore()) + ", value=" + String.valueOf(this.value()) + ", collection=" + String.valueOf(this.collection()) + ", id=" + String.valueOf(this.id()) + ", metadata=" + String.valueOf(this.metadata()) + ", start=" + String.valueOf(this.start()) + ", end=" + String.valueOf(this.end()) + ", ifNotExists=" + this.ifNotExists() + ")";
    }

    @ConstructorProperties(value={"documentStore", "value", "collection", "id", "metadata", "start", "end", "ifNotExists"})
    @Generated
    public DefaultIndexOperation(DocumentStore documentStore, Object value, @NonNull Object collection, @NonNull Object id, @NonNull Metadata metadata, Instant start, Instant end, boolean ifNotExists) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.documentStore = documentStore;
        this.value = value;
        this.collection = collection;
        this.id = id;
        this.metadata = metadata;
        this.start = start;
        this.end = end;
        this.ifNotExists = ifNotExists;
    }
}

