/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.persisting.search.client.InMemorySearchStore;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.HasLocalHandlers;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;

public class LocalDocumentHandlerRegistry
implements HasLocalHandlers {
    private final InMemorySearchStore searchStore;
    private final HandlerRegistry handlerRegistry;
    private final DispatchInterceptor dispatchInterceptor;
    private final Serializer serializer;
    private final AtomicBoolean initialized = new AtomicBoolean();

    @Override
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        if (this.initialized.compareAndSet(false, true)) {
            this.searchStore.registerMonitor((collection, messages) -> this.serializer.deserializeMessages(messages.stream(), MessageType.DOCUMENT, (String)collection).forEach(message -> {
                this.dispatchInterceptor.monitorDispatch(message.toMessage(), MessageType.DOCUMENT, (String)collection);
                this.handle((DeserializingMessage)message);
            }));
        }
        return this.handlerRegistry.registerHandler(target, handlerFilter);
    }

    @ConstructorProperties(value={"searchStore", "handlerRegistry", "dispatchInterceptor", "serializer"})
    @Generated
    public LocalDocumentHandlerRegistry(InMemorySearchStore searchStore, HandlerRegistry handlerRegistry, DispatchInterceptor dispatchInterceptor, Serializer serializer) {
        this.searchStore = searchStore;
        this.handlerRegistry = handlerRegistry;
        this.dispatchInterceptor = dispatchInterceptor;
        this.serializer = serializer;
    }

    @Generated
    public Optional<CompletableFuture<Object>> handle(DeserializingMessage message) {
        return this.handlerRegistry.handle(message);
    }

    @Generated
    public HandlerRegistry andThen(HandlerRegistry next) {
        return this.handlerRegistry.andThen(next);
    }

    @Generated
    public HandlerRegistry orThen(HandlerRegistry next) {
        return this.handlerRegistry.orThen(next);
    }

    @Override
    @Generated
    public Registration registerHandler(Object target) {
        return this.handlerRegistry.registerHandler(target);
    }

    @Override
    @Generated
    public boolean hasLocalHandlers() {
        return this.handlerRegistry.hasLocalHandlers();
    }

    @Override
    @Generated
    public void setSelfHandlerFilter(HandlerFilter selfHandlerFilter) {
        this.handlerRegistry.setSelfHandlerFilter(selfHandlerFilter);
    }
}

