/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import java.util.Optional;

@FunctionalInterface
public interface DispatchInterceptor {
    public static final DispatchInterceptor noOp = (m, messageType, topic) -> m;

    public Message interceptDispatch(Message var1, MessageType var2, String var3);

    default public SerializedMessage modifySerializedMessage(SerializedMessage serializedMessage, Message message, MessageType messageType, String topic) {
        return serializedMessage;
    }

    default public void monitorDispatch(Message message, MessageType messageType, String topic) {
    }

    default public DispatchInterceptor andThen(final DispatchInterceptor nextInterceptor) {
        return new DispatchInterceptor(){

            @Override
            public Message interceptDispatch(Message m, MessageType t, String topic) {
                return Optional.ofNullable(DispatchInterceptor.this.interceptDispatch(m, t, topic)).map(message -> nextInterceptor.interceptDispatch((Message)message, t, topic)).orElse(null);
            }

            @Override
            public void monitorDispatch(Message message, MessageType messageType, String topic) {
                DispatchInterceptor.this.monitorDispatch(message, messageType, topic);
                nextInterceptor.monitorDispatch(message, messageType, topic);
            }

            @Override
            public SerializedMessage modifySerializedMessage(SerializedMessage s, Message m, MessageType type, String topic) {
                return Optional.ofNullable(DispatchInterceptor.this.modifySerializedMessage(s, m, type, topic)).map(message -> nextInterceptor.modifySerializedMessage((SerializedMessage)message, m, type, topic)).orElse(null);
            }
        };
    }
}

