/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.client.InMemoryScheduleStore;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.LocalTrackingClient;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;

public class LocalSchedulingClient
extends LocalTrackingClient
implements SchedulingClient {
    public LocalSchedulingClient(Duration messageExpiration) {
        super(new InMemoryScheduleStore(messageExpiration), MessageType.SCHEDULE);
    }

    @Override
    public InMemoryScheduleStore getMessageStore() {
        return (InMemoryScheduleStore)super.getMessageStore();
    }

    @Override
    public void close() {
        super.close();
    }

    @Generated
    public CompletableFuture<Void> append(SerializedMessage ... messages) {
        return this.getMessageStore().append(messages);
    }

    @Override
    @Generated
    public CompletableFuture<Void> schedule(Guarantee guarantee, SerializedSchedule ... schedules) {
        return this.getMessageStore().schedule(guarantee, schedules);
    }

    @Override
    @Generated
    public CompletableFuture<Void> cancelSchedule(String scheduleId, Guarantee guarantee) {
        return this.getMessageStore().cancelSchedule(scheduleId, guarantee);
    }

    @Override
    @Generated
    public SerializedSchedule getSchedule(String scheduleId) {
        return this.getMessageStore().getSchedule(scheduleId);
    }

    @Generated
    public CompletableFuture<Void> append(List<SerializedMessage> messages) {
        return this.getMessageStore().append(messages);
    }

    @Generated
    public void setClock(Clock clock) {
        this.getMessageStore().setClock(clock);
    }

    @Generated
    public List<Schedule> getSchedules(Serializer serializer) {
        return this.getMessageStore().getSchedules(serializer);
    }

    @Generated
    public List<Schedule> removeExpiredSchedules(Serializer serializer) {
        return this.getMessageStore().removeExpiredSchedules(serializer);
    }

    @Generated
    public List<SerializedMessage> getBatch(Long minIndex, int maxSize, boolean inclusive) {
        return this.getMessageStore().getBatch(minIndex, maxSize, inclusive);
    }

    @Generated
    public void notifyMonitors() {
        this.getMessageStore().notifyMonitors();
    }

    @Override
    @Generated
    public Registration registerMonitor(Consumer<List<SerializedMessage>> monitor) {
        return this.getMessageStore().registerMonitor(monitor);
    }

    @Override
    @Generated
    public MessageType getMessageType() {
        return this.getMessageStore().getMessageType();
    }

    @Generated
    public Duration getRetentionTime() {
        return this.getMessageStore().getRetentionTime();
    }

    @Generated
    public void setRetentionTime(Duration retentionTime) {
        this.getMessageStore().setRetentionTime(retentionTime);
    }

    @Generated
    public List<SerializedMessage> getBatch(Long minIndex, int maxSize) {
        return this.getMessageStore().getBatch(minIndex, maxSize);
    }

    @Generated
    public <T extends MessageStore> T unwrap(Class<T> type) {
        return this.getMessageStore().unwrap(type);
    }

    @Override
    @Generated
    public CompletableFuture<Void> schedule(SerializedSchedule ... schedules) {
        return this.getMessageStore().schedule(schedules);
    }

    @Override
    @Generated
    public CompletableFuture<Void> cancelSchedule(String scheduleId) {
        return this.getMessageStore().cancelSchedule(scheduleId);
    }

    @Override
    @Generated
    public boolean hasSchedule(String scheduleId) {
        return this.getMessageStore().hasSchedule(scheduleId);
    }
}

