/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.ClaimSegmentResult;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Position;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface TrackingClient
extends AutoCloseable {
    default public MessageBatch readAndWait(String consumer, String trackerId, Long lastIndex, ConsumerConfiguration configuration) {
        return this.read(consumer, trackerId, lastIndex, configuration).get();
    }

    public CompletableFuture<MessageBatch> read(String var1, String var2, Long var3, ConsumerConfiguration var4);

    public List<SerializedMessage> readFromIndex(long var1, int var3);

    public CompletableFuture<ClaimSegmentResult> claimSegment(String var1, String var2, Long var3, ConsumerConfiguration var4);

    default public CompletableFuture<Void> storePosition(String consumer, int[] segment, long lastIndex) {
        return this.storePosition(consumer, segment, lastIndex, Guarantee.STORED);
    }

    public CompletableFuture<Void> storePosition(String var1, int[] var2, long var3, Guarantee var5);

    default public CompletableFuture<Void> resetPosition(String consumer, long lastIndex) {
        return this.resetPosition(consumer, lastIndex, Guarantee.STORED);
    }

    public CompletableFuture<Void> resetPosition(String var1, long var2, Guarantee var4);

    public Position getPosition(String var1);

    default public CompletableFuture<Void> disconnectTracker(String consumer, String trackerId, boolean sendFinalEmptyBatch) {
        return this.disconnectTracker(consumer, trackerId, sendFinalEmptyBatch, Guarantee.SENT);
    }

    public CompletableFuture<Void> disconnectTracker(String var1, String var2, boolean var3, Guarantee var4);

    public MessageType getMessageType();

    public String getTopic();

    @Override
    public void close();
}

