/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HasLocalHandlers;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;

public interface HandlerRegistry
extends HasLocalHandlers {
    public static HandlerRegistry noOp() {
        return NoOpHandlerRegistry.INSTANCE;
    }

    public Optional<CompletableFuture<Object>> handle(DeserializingMessage var1);

    default public HandlerRegistry andThen(HandlerRegistry next) {
        return new MergedHandlerRegistry(this, next);
    }

    default public HandlerRegistry orThen(HandlerRegistry next) {
        return new MergedHandlerRegistry(this, this, next){

            @Override
            public Optional<CompletableFuture<Object>> handle(DeserializingMessage message) {
                return this.first.handle(message).or(() -> this.second.handle(message));
            }
        };
    }

    public static enum NoOpHandlerRegistry implements HandlerRegistry
    {
        INSTANCE;


        @Override
        public Optional<CompletableFuture<Object>> handle(DeserializingMessage message) {
            return Optional.empty();
        }

        @Override
        public boolean hasLocalHandlers() {
            return false;
        }

        @Override
        public void setSelfHandlerFilter(HandlerFilter selfHandlerFilter) {
        }

        @Override
        public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
            return Registration.noOp();
        }
    }

    public static class MergedHandlerRegistry
    implements HandlerRegistry {
        protected final HandlerRegistry first;
        protected final HandlerRegistry second;

        @Override
        public Optional<CompletableFuture<Object>> handle(DeserializingMessage message) {
            Optional<CompletableFuture<Object>> firstResult = this.first.handle(message);
            Optional<CompletableFuture<Object>> secondResult = this.second.handle(message);
            return firstResult.isPresent() ? secondResult.map(messageCompletableFuture -> ((CompletableFuture)firstResult.get()).thenCombine((CompletionStage)messageCompletableFuture, (a, b) -> a)).or(() -> firstResult) : secondResult;
        }

        @Override
        public Registration registerHandler(Object target) {
            return this.first.registerHandler(target).merge(this.second.registerHandler(target));
        }

        @Override
        public boolean hasLocalHandlers() {
            return this.first.hasLocalHandlers() || this.second.hasLocalHandlers();
        }

        @Override
        public void setSelfHandlerFilter(HandlerFilter selfHandlerFilter) {
            this.first.setSelfHandlerFilter(selfHandlerFilter);
            this.second.setSelfHandlerFilter(selfHandlerFilter);
        }

        @Override
        public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
            return this.first.registerHandler(target, handlerFilter).merge(this.second.registerHandler(target, handlerFilter));
        }

        @ConstructorProperties(value={"first", "second"})
        @Generated
        public MergedHandlerRegistry(HandlerRegistry first, HandlerRegistry second) {
            this.first = first;
            this.second = second;
        }
    }
}

