/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Pair;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.ServicePathBuilder;
import io.fluxcapacitor.common.tracking.HasMessageStore;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.ClientDispatchMonitor;
import io.fluxcapacitor.javaclient.configuration.client.LocalClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.LocalSchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.testserver.metrics.DefaultMetricsLog;
import io.fluxcapacitor.testserver.metrics.MetricsLog;
import io.fluxcapacitor.testserver.metrics.NoOpMetricsLog;
import io.fluxcapacitor.testserver.scheduling.TestServerScheduleStore;
import io.fluxcapacitor.testserver.websocket.ConsumerEndpoint;
import io.fluxcapacitor.testserver.websocket.EventSourcingEndpoint;
import io.fluxcapacitor.testserver.websocket.KeyValueEndPoint;
import io.fluxcapacitor.testserver.websocket.ProducerEndpoint;
import io.fluxcapacitor.testserver.websocket.SchedulingEndpoint;
import io.fluxcapacitor.testserver.websocket.SearchEndpoint;
import io.fluxcapacitor.testserver.websocket.WebsocketDeploymentUtils;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Headers;
import jakarta.websocket.Session;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestServer.class);
    private static final Function<String, Client> clients = ObjectUtils.memoize(projectId -> new TestServerProject(LocalClient.newInstance()));
    private static final Function<String, MetricsLog> metricsLogSupplier = ObjectUtils.memoize(projectId -> new DefaultMetricsLog(TestServer.getMessageStore(projectId, MessageType.METRICS)));

    public static void main(String[] args2) {
        TestServer.start(Integer.getInteger("port", 8080));
    }

    public static void start(int port) {
        PathHandler pathHandler = Handlers.path();
        for (MessageType messageType : Arrays.asList(MessageType.METRICS, MessageType.EVENT, MessageType.COMMAND, MessageType.QUERY, MessageType.RESULT, MessageType.ERROR, MessageType.WEBREQUEST, MessageType.WEBRESPONSE)) {
            pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ProducerEndpoint(TestServer.getMessageStore(projectId, messageType)).metricsLog(messageType == MessageType.METRICS ? new NoOpMetricsLog() : metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.producerPath(messageType)), pathHandler);
            pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint(TestServer.getMessageStore(projectId, messageType), messageType).metricsLog(messageType == MessageType.METRICS ? new NoOpMetricsLog() : metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.consumerPath(messageType)), pathHandler);
        }
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint(TestServer.getMessageStore(projectId, MessageType.NOTIFICATION), MessageType.NOTIFICATION).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.consumerPath(MessageType.NOTIFICATION)), pathHandler);
        for (MessageType messageType : MessageType.values()) {
            switch (messageType) {
                case DOCUMENT: 
                case CUSTOM: {
                    pathHandler = WebsocketDeploymentUtils.deployFromSession(ObjectUtils.memoize((projectId, topic) -> new ConsumerEndpoint(TestServer.getMessageStore(projectId, messageType, topic), messageType).metricsLog(metricsLogSupplier.apply((String)projectId))).compose(s -> new Pair<String, String>(WebsocketDeploymentUtils.getProjectId(s), TestServer.getTopic(s))), String.format("/%s/", ServicePathBuilder.consumerPath(messageType)), pathHandler);
                }
            }
        }
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new EventSourcingEndpoint(clients.apply((String)projectId).getEventStoreClient()).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.eventSourcingPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new KeyValueEndPoint(clients.apply((String)projectId).getKeyValueClient()).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.keyValuePath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new SearchEndpoint(clients.apply((String)projectId).getSearchClient()).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.searchPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new SchedulingEndpoint(clients.apply((String)projectId).getSchedulingClient()).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.schedulingPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint((MessageStore)((Object)clients.apply((String)projectId).getSchedulingClient()), MessageType.SCHEDULE).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.consumerPath(MessageType.SCHEDULE)), pathHandler);
        pathHandler = pathHandler.addPrefixPath("/health", exchange -> {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
            exchange.getResponseSender().send("Healthy");
        });
        GracefulShutdownHandler shutdownHandler = new GracefulShutdownHandler(pathHandler);
        Undertow server = Undertow.builder().addHttpListener(port, "0.0.0.0").setHandler(shutdownHandler).build();
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Initiating controlled shutdown");
            shutdownHandler.shutdown();
            try {
                shutdownHandler.awaitShutdown(1000L);
            }
            catch (InterruptedException e) {
                log.warn("Thread to kill server was interrupted");
                Thread.currentThread().interrupt();
            }
        }, ObjectUtils.newThreadName("TestServer-shutdown")));
        log.info("Flux Capacitor test server running on port {}", (Object)port);
    }

    private static MessageStore getMessageStore(String projectId, MessageType messageType) {
        return TestServer.getMessageStore(projectId, messageType, null);
    }

    private static MessageStore getMessageStore(String projectId, MessageType messageType, String topic) {
        if (messageType == MessageType.NOTIFICATION) {
            messageType = MessageType.EVENT;
        }
        HasMessageStore client = (HasMessageStore)((Object)clients.apply(projectId).getTrackingClient(messageType, topic));
        return client.getMessageStore();
    }

    static String getTopic(Session s) {
        return Optional.ofNullable(s.getRequestParameterMap().get("topic")).map(List::getFirst).orElseThrow(() -> new IllegalStateException("Topic parameter missing"));
    }

    static StoreIdentifier getStoreIdentifier(MessageType messageType, Session s) {
        return new StoreIdentifier(WebsocketDeploymentUtils.getProjectId(s), messageType, Optional.ofNullable(s.getRequestParameterMap().get("topic")).map(List::getFirst).orElseThrow(() -> new IllegalStateException("Topic parameter missing")));
    }

    public static final class StoreIdentifier {
        private final String projectId;
        private final MessageType messageType;
        private final String topic;

        @ConstructorProperties(value={"projectId", "messageType", "topic"})
        @Generated
        public StoreIdentifier(String projectId, MessageType messageType, String topic) {
            this.projectId = projectId;
            this.messageType = messageType;
            this.topic = topic;
        }

        @Generated
        public String getProjectId() {
            return this.projectId;
        }

        @Generated
        public MessageType getMessageType() {
            return this.messageType;
        }

        @Generated
        public String getTopic() {
            return this.topic;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StoreIdentifier)) {
                return false;
            }
            StoreIdentifier other = (StoreIdentifier)o;
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            MessageType this$messageType = this.getMessageType();
            MessageType other$messageType = other.getMessageType();
            if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            MessageType $messageType = this.getMessageType();
            result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestServer.StoreIdentifier(projectId=" + this.getProjectId() + ", messageType=" + String.valueOf((Object)this.getMessageType()) + ", topic=" + this.getTopic() + ")";
        }

        @Generated
        public StoreIdentifier withMessageType(MessageType messageType) {
            return this.messageType == messageType ? this : new StoreIdentifier(this.projectId, messageType, this.topic);
        }
    }

    static class TestServerProject
    implements Client {
        private final LocalClient delegate;

        @Override
        public SchedulingClient getSchedulingClient() {
            return new TestServerScheduleStore(((LocalSchedulingClient)this.delegate.getSchedulingClient()).getMessageStore());
        }

        @ConstructorProperties(value={"delegate"})
        @Generated
        public TestServerProject(LocalClient delegate) {
            this.delegate = delegate;
        }

        @Override
        @Generated
        public String name() {
            return this.delegate.name();
        }

        @Override
        @Generated
        public String applicationId() {
            return this.delegate.applicationId();
        }

        @Override
        @Generated
        public String id() {
            return this.delegate.id();
        }

        @Override
        @Generated
        public GatewayClient getGatewayClient(MessageType messageType, String topic) {
            return this.delegate.getGatewayClient(messageType, topic);
        }

        @Override
        @Generated
        public Registration monitorDispatch(ClientDispatchMonitor monitor, MessageType ... messageTypes) {
            return this.delegate.monitorDispatch(monitor, messageTypes);
        }

        @Override
        @Generated
        public TrackingClient getTrackingClient(MessageType messageType, String topic) {
            return this.delegate.getTrackingClient(messageType, topic);
        }

        @Override
        @Generated
        public void shutDown() {
            this.delegate.shutDown();
        }

        @Override
        @Generated
        public Registration beforeShutdown(Runnable task) {
            return this.delegate.beforeShutdown(task);
        }

        @Override
        @Generated
        public EventStoreClient getEventStoreClient() {
            return this.delegate.getEventStoreClient();
        }

        @Override
        @Generated
        public KeyValueClient getKeyValueClient() {
            return this.delegate.getKeyValueClient();
        }

        @Override
        @Generated
        public SearchClient getSearchClient() {
            return this.delegate.getSearchClient();
        }

        @Override
        @Generated
        public GatewayClient getGatewayClient(MessageType messageType) {
            return this.delegate.getGatewayClient(messageType);
        }

        @Override
        @Generated
        public TrackingClient getTrackingClient(MessageType messageType) {
            return this.delegate.getTrackingClient(messageType);
        }

        @Override
        @Generated
        public Client unwrap() {
            return this.delegate.unwrap();
        }
    }
}

