/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.metrics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.ClientEvent;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.serialization.Revision;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.testserver.metrics.MetricsLog;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsLog
implements MetricsLog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricsLog.class);
    private final MessageStore store;
    private final ObjectMapper objectMapper;
    private final ExecutorService workerPool;

    public DefaultMetricsLog(MessageStore store) {
        this(store, Executors.newSingleThreadExecutor(ObjectUtils.newThreadFactory("DefaultMetricsLog")));
    }

    public DefaultMetricsLog(MessageStore store, ExecutorService workerPool) {
        this(store, new ObjectMapper(), workerPool);
    }

    @Override
    public void registerMetrics(ClientEvent event, Metadata metadata) {
        this.workerPool.submit(() -> {
            try {
                Revision revision = event.getClass().getAnnotation(Revision.class);
                byte[] payload = this.objectMapper.writeValueAsBytes(event);
                this.store.append(new SerializedMessage(new Data<byte[]>(payload, event.getClass().getName(), revision == null ? 0 : revision.value(), "application/json"), metadata, UUID.randomUUID().toString(), System.currentTimeMillis()));
            }
            catch (JsonProcessingException e) {
                log.error("Failed to serialize metrics {}", (Object)event, (Object)e);
            }
        });
    }

    @ConstructorProperties(value={"store", "objectMapper", "workerPool"})
    @Generated
    public DefaultMetricsLog(MessageStore store, ObjectMapper objectMapper, ExecutorService workerPool) {
        this.store = store;
        this.objectMapper = objectMapper;
        this.workerPool = workerPool;
    }
}

