/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.scheduling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.common.tracking.InMemoryTaskScheduler;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.common.tracking.TaskScheduler;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.client.InMemoryScheduleStore;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;

public class TestServerScheduleStore
implements MessageStore,
SchedulingClient {
    private final TaskScheduler scheduler = new InMemoryTaskScheduler();
    private final InMemoryScheduleStore delegate;
    private volatile Deadline upcomingDeadline;

    public TestServerScheduleStore(InMemoryScheduleStore delegate) {
        this.delegate = delegate;
        this.getBatch(IndexUtils.indexForCurrentTime(), 1).stream().findFirst().map(SerializedMessage::getIndex).ifPresent(this::rescheduleNextDeadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompletableFuture<Void> schedule(Guarantee guarantee, SerializedSchedule ... schedules) {
        long now = FluxCapacitor.currentClock().millis();
        try {
            CompletableFuture<Void> completableFuture = this.delegate.schedule(guarantee, schedules);
            return completableFuture;
        }
        finally {
            Arrays.stream(schedules).mapToLong(SerializedSchedule::getTimestamp).filter(t -> t > now).map(IndexUtils::indexFromMillis).findFirst().ifPresent(this::rescheduleNextDeadline);
        }
    }

    @Override
    public List<SerializedMessage> getBatch(Long minIndex, int maxSize) {
        return this.getBatch(minIndex, maxSize, false);
    }

    @Override
    public synchronized List<SerializedMessage> getBatch(Long minIndex, int maxSize, boolean inclusive) {
        List<SerializedMessage> unfiltered = this.delegate.getBatch(minIndex == null ? -1L : (inclusive ? minIndex : minIndex + 1L), maxSize);
        List<SerializedMessage> filtered = this.delegate.getBatch(minIndex, maxSize, inclusive);
        unfiltered.stream().filter(m -> !filtered.contains(m)).map(SerializedMessage::getIndex).min(Comparator.naturalOrder()).ifPresent(this::rescheduleNextDeadline);
        return filtered;
    }

    protected void rescheduleNextDeadline(long nextIndex) {
        long nextDeadline = IndexUtils.millisFromIndex(nextIndex);
        if (this.upcomingDeadline == null || nextDeadline < this.upcomingDeadline.getTimestamp()) {
            if (this.upcomingDeadline != null) {
                this.upcomingDeadline.getScheduleToken().cancel();
            }
            Registration token = this.scheduler.schedule(nextDeadline, () -> {
                this.upcomingDeadline = null;
                this.delegate.notifyMonitors();
            });
            this.upcomingDeadline = new Deadline(nextDeadline, token);
        }
    }

    @Override
    @Generated
    public CompletableFuture<Void> append(SerializedMessage ... messages) {
        return this.delegate.append(messages);
    }

    @Override
    @Generated
    public CompletableFuture<Void> cancelSchedule(String scheduleId, Guarantee guarantee) {
        return this.delegate.cancelSchedule(scheduleId, guarantee);
    }

    @Override
    @Generated
    public SerializedSchedule getSchedule(String scheduleId) {
        return this.delegate.getSchedule(scheduleId);
    }

    @Override
    @Generated
    public CompletableFuture<Void> append(List<SerializedMessage> messages) {
        return this.delegate.append(messages);
    }

    @Generated
    public void setClock(Clock clock) {
        this.delegate.setClock(clock);
    }

    @Generated
    public List<Schedule> getSchedules(Serializer serializer) {
        return this.delegate.getSchedules(serializer);
    }

    @Generated
    public List<Schedule> removeExpiredSchedules(Serializer serializer) {
        return this.delegate.removeExpiredSchedules(serializer);
    }

    @Generated
    public void notifyMonitors() {
        this.delegate.notifyMonitors();
    }

    @Override
    @Generated
    public Registration registerMonitor(Consumer<List<SerializedMessage>> monitor) {
        return this.delegate.registerMonitor(monitor);
    }

    @Override
    @Generated
    public void close() {
        this.delegate.close();
    }

    @Generated
    public MessageType getMessageType() {
        return this.delegate.getMessageType();
    }

    @Generated
    public Duration getRetentionTime() {
        return this.delegate.getRetentionTime();
    }

    @Override
    @Generated
    public void setRetentionTime(Duration retentionTime) {
        this.delegate.setRetentionTime(retentionTime);
    }

    @Override
    @Generated
    public <T extends MessageStore> T unwrap(Class<T> type) {
        return this.delegate.unwrap(type);
    }

    @Override
    @Generated
    public MessageStore getMessageStore() {
        return this.delegate.getMessageStore();
    }

    @Override
    @Generated
    public CompletableFuture<Void> schedule(SerializedSchedule ... schedules) {
        return this.delegate.schedule(schedules);
    }

    @Override
    @Generated
    public CompletableFuture<Void> cancelSchedule(String scheduleId) {
        return this.delegate.cancelSchedule(scheduleId);
    }

    @Override
    @Generated
    public boolean hasSchedule(String scheduleId) {
        return this.delegate.hasSchedule(scheduleId);
    }

    static final class Deadline {
        private final long timestamp;
        private final Registration scheduleToken;

        @ConstructorProperties(value={"timestamp", "scheduleToken"})
        @Generated
        public Deadline(long timestamp, Registration scheduleToken) {
            this.timestamp = timestamp;
            this.scheduleToken = scheduleToken;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public Registration getScheduleToken() {
            return this.scheduleToken;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Deadline)) {
                return false;
            }
            Deadline other = (Deadline)o;
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            Registration this$scheduleToken = this.getScheduleToken();
            Registration other$scheduleToken = other.getScheduleToken();
            return !(this$scheduleToken == null ? other$scheduleToken != null : !this$scheduleToken.equals(other$scheduleToken));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            Registration $scheduleToken = this.getScheduleToken();
            result = result * 59 + ($scheduleToken == null ? 43 : $scheduleToken.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestServerScheduleStore.Deadline(timestamp=" + this.getTimestamp() + ", scheduleToken=" + String.valueOf(this.getScheduleToken()) + ")";
        }
    }
}

