/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.websocket;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.keyvalue.DeleteValue;
import io.fluxcapacitor.common.api.keyvalue.GetValue;
import io.fluxcapacitor.common.api.keyvalue.GetValueResult;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import io.fluxcapacitor.common.api.keyvalue.StoreValueIfAbsent;
import io.fluxcapacitor.common.api.keyvalue.StoreValues;
import io.fluxcapacitor.common.api.keyvalue.StoreValuesAndWait;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.testserver.websocket.Handle;
import io.fluxcapacitor.testserver.websocket.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class KeyValueEndPoint
extends WebsocketEndpoint {
    private final KeyValueClient keyValueStore;

    @Handle
    public void handle(StoreValues storeValues) {
        for (KeyValuePair value : storeValues.getValues()) {
            this.keyValueStore.putValue(value.getKey(), value.getValue(), Guarantee.NONE);
        }
    }

    @Handle
    CompletableFuture<Void> handle(StoreValuesAndWait storeValues) {
        return CompletableFuture.allOf((CompletableFuture[])storeValues.getValues().stream().map(v -> this.keyValueStore.putValue(v.getKey(), v.getValue(), storeValues.getGuarantee())).toArray(CompletableFuture[]::new));
    }

    @Handle
    CompletableFuture<Boolean> handle(StoreValueIfAbsent r) {
        return this.keyValueStore.putValueIfAbsent(r.getValue().getKey(), r.getValue().getValue());
    }

    @Handle
    GetValueResult handle(GetValue getValue) {
        return new GetValueResult(getValue.getRequestId(), this.keyValueStore.getValue(getValue.getKey()));
    }

    @Handle
    CompletableFuture<Void> handle(DeleteValue deleteValue) {
        return this.keyValueStore.deleteValue(deleteValue.getKey(), deleteValue.getGuarantee());
    }

    @ConstructorProperties(value={"keyValueStore"})
    @Generated
    public KeyValueEndPoint(KeyValueClient keyValueStore) {
        this.keyValueStore = keyValueStore;
    }
}

