/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.websocket;

import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.publishing.Append;
import io.fluxcapacitor.common.api.publishing.SetRetentionTime;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.testserver.websocket.Handle;
import io.fluxcapacitor.testserver.websocket.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerEndpoint
extends WebsocketEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerEndpoint.class);
    private final MessageStore store;

    @Handle
    CompletableFuture<Void> handle(Append request) {
        return this.store.append((SerializedMessage[])request.getMessages().toArray(SerializedMessage[]::new));
    }

    @Handle
    void handle(SetRetentionTime request) {
        this.store.setRetentionTime(Optional.ofNullable(request.getRetentionTimeInSeconds()).map(Duration::ofSeconds).orElse(null));
    }

    @ConstructorProperties(value={"store"})
    @Generated
    public ProducerEndpoint(MessageStore store) {
        this.store = store;
    }
}

