/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.websocket;

import io.fluxcapacitor.common.api.scheduling.CancelSchedule;
import io.fluxcapacitor.common.api.scheduling.GetSchedule;
import io.fluxcapacitor.common.api.scheduling.GetScheduleResult;
import io.fluxcapacitor.common.api.scheduling.Schedule;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.testserver.websocket.Handle;
import io.fluxcapacitor.testserver.websocket.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class SchedulingEndpoint
extends WebsocketEndpoint {
    private final SchedulingClient store;

    @Handle
    CompletableFuture<Void> handle(Schedule schedule) {
        return this.store.schedule(schedule.getGuarantee(), (SerializedSchedule[])schedule.getMessages().toArray(SerializedSchedule[]::new));
    }

    @Handle
    CompletableFuture<Void> handle(CancelSchedule request) {
        return this.store.cancelSchedule(request.getScheduleId(), request.getGuarantee());
    }

    @Handle
    GetScheduleResult handle(GetSchedule request) {
        return new GetScheduleResult(request.getRequestId(), this.store.getSchedule(request.getScheduleId()));
    }

    @ConstructorProperties(value={"store"})
    @Generated
    public SchedulingEndpoint(SchedulingClient store) {
        this.store = store;
    }
}

