/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.websocket;

import io.fluxcapacitor.common.api.search.BulkUpdate;
import io.fluxcapacitor.common.api.search.BulkUpdateDocuments;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DeleteCollection;
import io.fluxcapacitor.common.api.search.DeleteDocumentById;
import io.fluxcapacitor.common.api.search.DeleteDocuments;
import io.fluxcapacitor.common.api.search.DocumentUpdate;
import io.fluxcapacitor.common.api.search.GetDocument;
import io.fluxcapacitor.common.api.search.GetDocumentResult;
import io.fluxcapacitor.common.api.search.GetDocumentStats;
import io.fluxcapacitor.common.api.search.GetDocumentStatsResult;
import io.fluxcapacitor.common.api.search.GetFacetStats;
import io.fluxcapacitor.common.api.search.GetFacetStatsResult;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.GetSearchHistogramResult;
import io.fluxcapacitor.common.api.search.IndexDocuments;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchDocumentsResult;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.testserver.websocket.Handle;
import io.fluxcapacitor.testserver.websocket.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEndpoint
extends WebsocketEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchEndpoint.class);
    private final SearchClient store;

    @Handle
    CompletableFuture<Void> handle(IndexDocuments request) {
        return this.store.index(request.getDocuments(), request.getGuarantee(), request.isIfNotExists());
    }

    @Handle
    CompletableFuture<Void> handle(BulkUpdateDocuments request) {
        Map<BulkUpdate.Type, List<DocumentUpdate>> updatesByType = request.getUpdates().stream().filter(Objects::nonNull).collect(Collectors.toMap(a -> String.format("%s_%s", a.getCollection(), a.getId()), UnaryOperator.identity(), (a, b) -> b)).values().stream().collect(Collectors.groupingBy(DocumentUpdate::getType));
        ArrayList results = new ArrayList();
        Optional.ofNullable(updatesByType.get((Object)BulkUpdate.Type.index)).ifPresent(updates -> {
            List<SerializedDocument> documents = updates.stream().map(DocumentUpdate::getObject).toList();
            results.add(this.store.index(documents, request.getGuarantee(), false));
        });
        Optional.ofNullable(updatesByType.get((Object)BulkUpdate.Type.indexIfNotExists)).ifPresent(updates -> {
            List<SerializedDocument> documents = updates.stream().map(DocumentUpdate::getObject).toList();
            results.add(this.store.index(documents, request.getGuarantee(), true));
        });
        updatesByType.getOrDefault((Object)BulkUpdate.Type.delete, Collections.emptyList()).forEach(delete -> this.store.delete(delete.getId(), delete.getCollection(), request.getGuarantee()));
        return CompletableFuture.allOf((CompletableFuture[])results.toArray(CompletableFuture[]::new));
    }

    @Handle
    public SearchDocumentsResult handle(SearchDocuments request) {
        try {
            Stream<SearchHit<SerializedDocument>> result = this.store.search(request, -1);
            return new SearchDocumentsResult(request.getRequestId(), result.map(SearchHit::getValue).toList());
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new SearchDocumentsResult(request.getRequestId(), Collections.emptyList());
        }
    }

    @Handle
    public GetSearchHistogramResult handle(GetSearchHistogram request) {
        try {
            return new GetSearchHistogramResult(request.getRequestId(), this.store.fetchHistogram(request));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new GetSearchHistogramResult(request.getRequestId(), new SearchHistogram(request.getQuery().getSince(), request.getQuery().getBefore(), Collections.emptyList()));
        }
    }

    @Handle
    GetDocumentStatsResult handle(GetDocumentStats request) {
        try {
            return new GetDocumentStatsResult(request.getRequestId(), this.store.fetchStatistics(request.getQuery(), request.getFields(), request.getGroupBy()));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new GetDocumentStatsResult(request.getRequestId(), Collections.emptyList());
        }
    }

    @Handle
    GetDocumentResult handle(GetDocument request) {
        try {
            return new GetDocumentResult(request.getRequestId(), this.store.fetch(request).orElse(null));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new GetDocumentResult(request.getRequestId(), null);
        }
    }

    @Handle
    CompletableFuture<Void> handle(DeleteDocuments request) {
        return this.store.delete(request.getQuery(), request.getGuarantee());
    }

    @Handle
    void handle(DeleteDocumentById request) {
        this.store.delete(request.getId(), request.getCollection(), request.getGuarantee());
    }

    @Handle
    void handle(DeleteCollection request) {
        this.store.deleteCollection(request.getCollection(), request.getGuarantee());
    }

    @Handle
    void handle(CreateAuditTrail request) {
        this.store.createAuditTrail(request);
    }

    @Handle
    GetFacetStatsResult handle(GetFacetStats request) {
        try {
            return new GetFacetStatsResult(request.getRequestId(), this.store.fetchFacetStats(request.getQuery()));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new GetFacetStatsResult(request.getRequestId(), Collections.emptyList());
        }
    }

    @ConstructorProperties(value={"store"})
    @Generated
    public SearchEndpoint(SearchClient store) {
        this.store = store;
    }
}

