/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.websocket;

import io.fluxcapacitor.common.MemoizingFunction;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.testserver.websocket.MultiClientEndpoint;
import io.undertow.Undertow;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class WebsocketDeploymentUtils {
    private static final ByteBufferPool bufferPool = new DefaultByteBufferPool(false, 1024, 100, 12);

    public static PathHandler deploy(Function<String, Endpoint> endpointSupplier, String path, PathHandler pathHandler) {
        return WebsocketDeploymentUtils.deployFromSession((MemoizingFunction<Session, Endpoint>)ClientUtils.memoize(endpointSupplier).compose(WebsocketDeploymentUtils::getProjectId), path, pathHandler);
    }

    public static PathHandler deployFromSession(final MemoizingFunction<Session, Endpoint> endpointSupplier, String path, PathHandler pathHandler) {
        ServerEndpointConfig config = ServerEndpointConfig.Builder.create(MultiClientEndpoint.class, "/").configurator(new ServerEndpointConfig.Configurator(){
            final MultiClientEndpoint endpoint;
            {
                this.endpoint = new MultiClientEndpoint(endpointSupplier);
            }

            @Override
            public <T> T getEndpointInstance(Class<T> endpointClass) {
                return endpointClass.cast(this.endpoint);
            }
        }).build();
        DeploymentManager deploymentManager = Servlets.defaultContainer().addDeployment(Servlets.deployment().setContextPath("/").addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", WebsocketDeploymentUtils.createWebsocketDeploymentInfo().addEndpoint(config)).setDeploymentName(path).setClassLoader(Undertow.class.getClassLoader()));
        deploymentManager.deploy();
        return pathHandler.addPrefixPath(path, deploymentManager.start());
    }

    public static WebSocketDeploymentInfo createWebsocketDeploymentInfo() {
        return new WebSocketDeploymentInfo().setBuffers(bufferPool).setWorker(WebsocketDeploymentUtils.createWorker());
    }

    public static String getProjectId(Session session) {
        return Optional.ofNullable(session.getRequestParameterMap().get("projectId")).map(List::getFirst).orElse("public");
    }

    private static XnioWorker createWorker() {
        return Xnio.getInstance().createWorker(OptionMap.create(Options.THREAD_DAEMON, true));
    }
}

