/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.Router;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.annotation.Transactional;
import io.jooby.exception.MethodNotAllowedException;
import io.jooby.exception.NotAcceptableException;
import io.jooby.exception.NotFoundException;
import io.jooby.exception.StatusCodeException;
import io.jooby.exception.UnsupportedMediaType;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class Route {
    public static final Handler NOT_FOUND = ctx -> ctx.sendError(new NotFoundException(ctx.getRequestPath()));
    public static final Handler METHOD_NOT_ALLOWED = ctx -> {
        ctx.setResetHeadersOnError(false);
        if (ctx.getMethod().equals("OPTIONS")) {
            return ctx.send(StatusCode.OK);
        }
        List allow = Optional.ofNullable(ctx.getResponseHeader("Allow")).map(it -> Arrays.asList(it.split(","))).orElseGet(Collections::emptyList);
        return ctx.sendError(new MethodNotAllowedException(ctx.getMethod(), allow));
    };
    public static final Handler REQUEST_ENTITY_TOO_LARGE = ctx -> ctx.setResponseCode(StatusCode.REQUEST_ENTITY_TOO_LARGE).sendError(new StatusCodeException(StatusCode.REQUEST_ENTITY_TOO_LARGE));
    public static final Before ACCEPT = ctx -> {
        List<MediaType> produceTypes = ctx.getRoute().getProduces();
        MediaType contentType = ctx.accept(produceTypes);
        if (contentType == null) {
            throw new NotAcceptableException(ctx.header("Accept").valueOrNull());
        }
        ctx.setDefaultResponseType(contentType);
    };
    public static final Before SUPPORT_MEDIA_TYPE = ctx -> {
        if (!ctx.isPreflight()) {
            MediaType contentType = ctx.getRequestType();
            if (contentType == null) {
                throw new UnsupportedMediaType(null);
            }
            if (ctx.getRoute().getConsumes().stream().noneMatch(contentType::matches)) {
                throw new UnsupportedMediaType(contentType.getValue());
            }
        }
    };
    public static final Handler FAVICON = ctx -> ctx.send(StatusCode.NOT_FOUND);
    private static final List EMPTY_LIST = Collections.emptyList();
    private static final Map EMPTY_MAP = Collections.emptyMap();
    private Map<String, MessageDecoder> decoders = EMPTY_MAP;
    private final String pattern;
    private final String method;
    private List<String> pathKeys = EMPTY_LIST;
    private Filter filter;
    private Handler handler;
    private After after;
    private Handler pipeline;
    private MessageEncoder encoder;
    private Type returnType;
    private Object handle;
    private List<MediaType> produces = EMPTY_LIST;
    private List<MediaType> consumes = EMPTY_LIST;
    private Map<String, Object> attributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private Set<String> supportedMethod;
    private String executorKey;
    private List<String> tags = EMPTY_LIST;
    private String summary;
    private String description;
    private Boolean nonBlocking;
    private MvcMethod mvcMethod;
    private boolean httpHead;

    public Route(@NonNull String method, @NonNull String pattern, @NonNull Handler handler) {
        this.method = method.toUpperCase();
        this.pattern = pattern;
        this.handler = handler;
        this.handle = handler;
    }

    @NonNull
    public String getPattern() {
        return this.pattern;
    }

    @NonNull
    public String getMethod() {
        return this.method;
    }

    @NonNull
    public List<String> getPathKeys() {
        return this.pathKeys;
    }

    @NonNull
    public Route setPathKeys(@NonNull List<String> pathKeys) {
        this.pathKeys = pathKeys;
        return this;
    }

    @NonNull
    public Handler getHandler() {
        return this.handler;
    }

    @NonNull
    public Handler getPipeline() {
        if (this.pipeline == null) {
            this.pipeline = this.computePipeline();
        }
        return this.pipeline;
    }

    @NonNull
    public String reverse(@NonNull Map<String, Object> keys2) {
        return Router.reverse(this.getPattern(), keys2);
    }

    @NonNull
    public String reverse(Object ... values2) {
        return Router.reverse(this.getPattern(), values2);
    }

    @NonNull
    public Object getHandle() {
        return this.handle;
    }

    @Nullable
    public After getAfter() {
        return this.after;
    }

    @NonNull
    public Route setAfter(@NonNull After after) {
        this.after = after;
        return this;
    }

    @Nullable
    public Filter getFilter() {
        return this.filter;
    }

    @NonNull
    public Route setFilter(@Nullable Filter filter) {
        this.filter = filter;
        return this;
    }

    @NonNull
    public Route setHandle(@NonNull Object handle) {
        this.handle = handle;
        return this;
    }

    @NonNull
    public Route setPipeline(Handler pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @NonNull
    public MessageEncoder getEncoder() {
        return this.encoder;
    }

    @NonNull
    public Route setEncoder(@NonNull MessageEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    @NonNull
    public boolean isNonBlocking() {
        return this.nonBlocking == Boolean.TRUE;
    }

    public boolean isNonBlockingSet() {
        return this.nonBlocking != null;
    }

    @NonNull
    public Route setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
        return this;
    }

    @Deprecated
    @Nullable
    public Type getReturnType() {
        return this.returnType;
    }

    @Deprecated
    @NonNull
    public Route setReturnType(@Nullable Type returnType) {
        this.returnType = returnType;
        return this;
    }

    @NonNull
    public List<MediaType> getProduces() {
        return this.produces;
    }

    @NonNull
    public Route produces(MediaType ... produces) {
        return this.setProduces(Arrays.asList(produces));
    }

    @NonNull
    public Route setProduces(@NonNull Collection<MediaType> produces) {
        if (!produces.isEmpty()) {
            if (this.produces == EMPTY_LIST) {
                this.produces = new ArrayList<MediaType>();
            }
            this.produces.addAll(produces);
        }
        return this;
    }

    @NonNull
    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    @NonNull
    public Route consumes(MediaType ... consumes) {
        return this.setConsumes(Arrays.asList(consumes));
    }

    @NonNull
    public Route setConsumes(@NonNull Collection<MediaType> consumes) {
        if (!consumes.isEmpty()) {
            if (this.consumes == EMPTY_LIST) {
                this.consumes = new ArrayList<MediaType>();
            }
            this.consumes.addAll(consumes);
        }
        return this;
    }

    @NonNull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public <T> T attribute(@NonNull String name) {
        return (T)this.attributes.get(name);
    }

    @NonNull
    public Route setAttributes(@NonNull Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    @NonNull
    public Route attribute(@NonNull String name, @NonNull Object value) {
        if (this.attributes == EMPTY_MAP) {
            this.attributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
        this.attributes.put(name, value);
        return this;
    }

    @NonNull
    public MessageDecoder decoder(@NonNull MediaType contentType) {
        return this.decoders.getOrDefault(contentType.getValue(), MessageDecoder.UNSUPPORTED_MEDIA_TYPE);
    }

    @NonNull
    public Map<String, MessageDecoder> getDecoders() {
        return this.decoders;
    }

    @NonNull
    public Route setDecoders(@NonNull Map<String, MessageDecoder> decoders) {
        this.decoders = decoders;
        return this;
    }

    public boolean isHttpOptions() {
        return this.isHttpMethod("OPTIONS");
    }

    public boolean isHttpTrace() {
        return this.isHttpMethod("TRACE");
    }

    public boolean isHttpHead() {
        return this.httpHead;
    }

    @NonNull
    public Route setHttpOptions(boolean enabled) {
        this.addHttpMethod(enabled, "OPTIONS");
        return this;
    }

    @NonNull
    public Route setHttpTrace(boolean enabled) {
        this.addHttpMethod(enabled, "TRACE");
        return this;
    }

    @NonNull
    public Route setHttpHead(boolean enabled) {
        this.addHttpMethod(enabled, "HEAD");
        this.httpHead = enabled;
        return this;
    }

    @Nullable
    public String getExecutorKey() {
        return this.executorKey;
    }

    @NonNull
    public Route setExecutorKey(@Nullable String executorKey) {
        this.executorKey = executorKey;
        return this;
    }

    @NonNull
    public List<String> getTags() {
        return this.tags;
    }

    @NonNull
    public Route setTags(@NonNull List<String> tags) {
        if (this.tags == EMPTY_LIST) {
            this.tags = new ArrayList<String>();
        }
        this.tags.addAll(tags);
        return this;
    }

    @NonNull
    public Route addTag(@NonNull String tag) {
        if (this.tags == EMPTY_LIST) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
        return this;
    }

    @NonNull
    public Route tags(String ... tags) {
        return this.setTags(Arrays.asList(tags));
    }

    @Nullable
    public String getSummary() {
        return this.summary;
    }

    @NonNull
    public Route summary(@Nullable String summary) {
        return this.setSummary(summary);
    }

    @NonNull
    public Route setSummary(@Nullable String summary) {
        this.summary = summary;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Route setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @NonNull
    public Route description(@Nullable String description) {
        return this.setDescription(description);
    }

    public boolean isTransactional(boolean defaultValue) {
        Object attribute = this.attribute(Transactional.ATTRIBUTE);
        if (attribute == null) {
            return defaultValue;
        }
        if (attribute instanceof Boolean) {
            return (Boolean)attribute;
        }
        throw new RuntimeException("Invalid value for route attribute " + Transactional.ATTRIBUTE + ": " + String.valueOf(attribute));
    }

    @Nullable
    public MvcMethod getMvcMethod() {
        return this.mvcMethod;
    }

    @NonNull
    public Route setMvcMethod(@Nullable MvcMethod mvcMethod) {
        this.mvcMethod = mvcMethod;
        return this;
    }

    @NonNull
    public Route mvcMethod(@Nullable MvcMethod mvcMethod) {
        return this.setMvcMethod(mvcMethod);
    }

    public String toString() {
        return this.method + " " + this.pattern;
    }

    private boolean isHttpMethod(String httpMethod) {
        return this.supportedMethod != null && this.supportedMethod.contains(httpMethod);
    }

    private void addHttpMethod(boolean enabled, String httpMethod) {
        if (this.supportedMethod == null) {
            this.supportedMethod = new HashSet<String>();
        }
        if (enabled) {
            this.supportedMethod.add(httpMethod);
        } else {
            this.supportedMethod.remove(httpMethod);
        }
    }

    private Handler computePipeline() {
        Handler pipeline = this.computeHeadPipeline();
        if (this.after != null) {
            pipeline = pipeline.then(this.after);
        }
        return pipeline;
    }

    private Handler computeHeadPipeline() {
        Handler pipeline = this.filter == null ? this.handler : this.filter.then(this.handler);
        return pipeline;
    }

    public static interface Handler
    extends Serializable,
    Aware {
        @NonNull
        public Object apply(@NonNull Context var1) throws Exception;

        @NonNull
        default public Handler then(@NonNull After next) {
            return ctx -> {
                Object result;
                Throwable cause = null;
                Object value = null;
                try {
                    value = this.apply(ctx);
                }
                catch (Throwable x) {
                    cause = x;
                    ctx.setResponseCode(ctx.getRouter().errorCode(cause));
                }
                try {
                    if (ctx.isResponseStarted()) {
                        result = Context.readOnly(ctx);
                        next.apply((Context)result, value, cause);
                    } else {
                        result = value;
                        next.apply(ctx, value, cause);
                    }
                }
                catch (Throwable x) {
                    result = null;
                    if (cause == null) {
                        cause = x;
                    }
                    cause.addSuppressed(x);
                }
                if (cause == null) {
                    return result;
                }
                if (ctx.isResponseStarted()) {
                    return ctx;
                }
                throw SneakyThrows.propagate(cause);
            };
        }
    }

    public static interface After {
        @NonNull
        default public After then(@NonNull After next) {
            return (ctx, result, failure) -> {
                next.apply(ctx, result, failure);
                this.apply(ctx, result, failure);
            };
        }

        public void apply(@NonNull Context var1, @Nullable Object var2, @Nullable Throwable var3) throws Exception;
    }

    public static interface Filter
    extends Aware {
        @NonNull
        public Handler apply(@NonNull Handler var1);

        @NonNull
        default public Filter then(@NonNull Filter next) {
            return h -> this.apply(next.apply(h));
        }

        @NonNull
        default public Handler then(final @NonNull Handler next) {
            return new Handler(){

                @Override
                @NonNull
                public Object apply(@NonNull Context ctx) throws Exception {
                    return this.apply(next).apply(ctx);
                }

                @Override
                public void setRoute(Route route) {
                    this.setRoute(route);
                    next.setRoute(route);
                }
            };
        }
    }

    public record MvcMethod(@NonNull Class<?> declaringClass, @NonNull String name, @NonNull Class<?> returnType, Class<?>[] parameterTypes) {
        public Method toMethod() {
            try {
                return this.declaringClass.getDeclaredMethod(this.name, this.parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw SneakyThrows.propagate(e);
            }
        }

        public MethodHandle toMethodHandle() {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType methodType = MethodType.methodType(this.returnType, this.parameterTypes);
            try {
                return lookup.findVirtual(this.declaringClass, this.name, methodType);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw SneakyThrows.propagate(e);
            }
        }
    }

    public static interface Before
    extends Filter {
        @Override
        @NonNull
        default public Handler apply(@NonNull Handler next) {
            return ctx -> {
                this.apply(ctx);
                return next.apply(ctx);
            };
        }

        public void apply(@NonNull Context var1) throws Exception;

        @NonNull
        default public Before then(@NonNull Before next) {
            return ctx -> {
                this.apply(ctx);
                if (!ctx.isResponseStarted()) {
                    next.apply(ctx);
                }
            };
        }

        @Override
        @NonNull
        default public Handler then(@NonNull Handler next) {
            return ctx -> {
                this.apply(ctx);
                if (!ctx.isResponseStarted()) {
                    return next.apply(ctx);
                }
                return ctx;
            };
        }
    }

    public static interface Aware {
        default public void setRoute(Route route) {
        }
    }

    public static interface Complete {
        public void apply(@NonNull Context var1) throws Exception;
    }

    @Deprecated
    public static interface Decorator
    extends Filter {
    }
}

