/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.BeanConverter;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.Environment;
import io.jooby.ErrorHandler;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.MvcExtension;
import io.jooby.Registry;
import io.jooby.Route;
import io.jooby.RouteSet;
import io.jooby.RouterOption;
import io.jooby.ServerOptions;
import io.jooby.ServerSentEmitter;
import io.jooby.ServiceRegistry;
import io.jooby.SessionStore;
import io.jooby.StatusCode;
import io.jooby.ValueConverter;
import io.jooby.WebSocket;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.exception.MissingValueException;
import io.jooby.handler.AssetHandler;
import io.jooby.handler.AssetSource;
import jakarta.inject.Provider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;

public interface Router
extends Registry {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String PATCH = "PATCH";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String TRACE = "TRACE";
    public static final List<String> METHODS = List.of("GET", "POST", "PUT", "DELETE", "PATCH", "HEAD", "OPTIONS", "TRACE");
    public static final String WS = "WS";
    public static final String SSE = "SSE";

    @NonNull
    public Config getConfig();

    @NonNull
    public Environment getEnvironment();

    @NonNull
    public List<Locale> getLocales();

    @NonNull
    public Map<String, Object> getAttributes();

    @NonNull
    default public <T> T attribute(@NonNull String key) {
        Object attribute = this.getAttributes().get(key);
        if (attribute == null) {
            throw new MissingValueException(key);
        }
        return (T)attribute;
    }

    @NonNull
    default public Router attribute(@NonNull String key, Object value) {
        this.getAttributes().put(key, value);
        return this;
    }

    @NonNull
    public ServiceRegistry getServices();

    @NonNull
    public Router setContextPath(@NonNull String var1);

    @NonNull
    public String getContextPath();

    public boolean isTrustProxy();

    public boolean isStarted();

    public boolean isStopped();

    @NonNull
    public Router setTrustProxy(boolean var1);

    @NonNull
    public Router setHiddenMethod(@NonNull String var1);

    @NonNull
    public Router setHiddenMethod(@NonNull Function<Context, Optional<String>> var1);

    @NonNull
    public Router setCurrentUser(@NonNull Function<Context, Object> var1);

    @NonNull
    public Router setContextAsService(boolean var1);

    @NonNull
    public Router domain(@NonNull String var1, @NonNull Router var2);

    @NonNull
    public RouteSet domain(@NonNull String var1, @NonNull Runnable var2);

    @NonNull
    public Router mount(@NonNull Predicate<Context> var1, @NonNull Router var2);

    @NonNull
    public RouteSet mount(@NonNull Predicate<Context> var1, @NonNull Runnable var2);

    @NonNull
    public Router mount(@NonNull String var1, @NonNull Router var2);

    @NonNull
    public Router mount(@NonNull Router var1);

    @NonNull
    public Router mvc(@NonNull MvcExtension var1);

    @Deprecated
    @NonNull
    public Router mvc(@NonNull Class var1);

    @Deprecated
    @NonNull
    public <T> Router mvc(@NonNull Class<T> var1, @NonNull Provider<T> var2);

    @Deprecated
    @NonNull
    public Router mvc(@NonNull Object var1);

    @NonNull
    public Route ws(@NonNull String var1, @NonNull WebSocket.Initializer var2);

    @NonNull
    public Route sse(@NonNull String var1, @NonNull ServerSentEmitter.Handler var2);

    @NonNull
    public List<Route> getRoutes();

    @NonNull
    public Router encoder(@NonNull MessageEncoder var1);

    @NonNull
    public Router encoder(@NonNull MediaType var1, @NonNull MessageEncoder var2);

    @NonNull
    public Path getTmpdir();

    @NonNull
    public Router decoder(@NonNull MediaType var1, @NonNull MessageDecoder var2);

    @NonNull
    public Executor getWorker();

    @NonNull
    public Router setWorker(@NonNull Executor var1);

    @NonNull
    public Router setDefaultWorker(@NonNull Executor var1);

    @NonNull
    public DataBufferFactory getBufferFactory();

    @NonNull
    public Router setBufferFactory(@NonNull DataBufferFactory var1);

    @NonNull
    public Router use(@NonNull Route.Filter var1);

    @Deprecated
    @NonNull
    default public Router decorator(@NonNull Route.Decorator filter) {
        return this.use(filter);
    }

    @NonNull
    public Router before(@NonNull Route.Before var1);

    @NonNull
    public Router after(@NonNull Route.After var1);

    @NonNull
    public Router dispatch(@NonNull Runnable var1);

    @NonNull
    public Router dispatch(@NonNull Executor var1, @NonNull Runnable var2);

    @NonNull
    public RouteSet routes(@NonNull Runnable var1);

    @NonNull
    public RouteSet path(@NonNull String var1, @NonNull Runnable var2);

    @NonNull
    default public Route get(@NonNull String pattern, @NonNull Route.Handler handler) {
        return this.route(GET, pattern, handler);
    }

    @NonNull
    default public Route post(@NonNull String pattern, @NonNull Route.Handler handler) {
        return this.route(POST, pattern, handler);
    }

    @NonNull
    default public Route put(@NonNull String pattern, @NonNull Route.Handler handler) {
        return this.route(PUT, pattern, handler);
    }

    @NonNull
    default public Route delete(@NonNull String pattern, @NonNull Route.Handler handler) {
        return this.route(DELETE, pattern, handler);
    }

    @NonNull
    default public Route patch(@NonNull String pattern, @NonNull Route.Handler handler) {
        return this.route(PATCH, pattern, handler);
    }

    @NonNull
    default public Route head(@NonNull String pattern, @NonNull Route.Handler handler) {
        return this.route(HEAD, pattern, handler);
    }

    @NonNull
    default public Route options(@NonNull String pattern, @NonNull Route.Handler handler) {
        return this.route(OPTIONS, pattern, handler);
    }

    @NonNull
    default public Route trace(@NonNull String pattern, @NonNull Route.Handler handler) {
        return this.route(TRACE, pattern, handler);
    }

    @NonNull
    default public AssetHandler assets(@NonNull String pattern, @NonNull Path source) {
        return this.assets(pattern, AssetSource.create(source), new AssetSource[0]);
    }

    @NonNull
    default public AssetHandler assets(@NonNull String pattern, @NonNull String source) {
        Path path = Stream.of(source.split("/")).reduce(Paths.get(System.getProperty("user.dir"), new String[0]), Path::resolve, Path::resolve);
        if (Files.exists(path, new LinkOption[0])) {
            return this.assets(pattern, path);
        }
        return this.assets(pattern, AssetSource.create(this.getClass().getClassLoader(), source), new AssetSource[0]);
    }

    @NonNull
    default public AssetHandler assets(@NonNull String pattern, @NonNull AssetSource source, AssetSource ... sources) {
        AssetSource[] allSources;
        if (sources.length == 0) {
            allSources = new AssetSource[]{source};
        } else {
            allSources = new AssetSource[1 + sources.length];
            allSources[0] = source;
            System.arraycopy(sources, 0, allSources, 1, sources.length);
        }
        return this.assets(pattern, new AssetHandler(allSources));
    }

    @NonNull
    default public AssetHandler assets(@NonNull String pattern, @NonNull AssetHandler handler) {
        this.route(GET, pattern, handler);
        return handler;
    }

    @NonNull
    public Route route(@NonNull String var1, @NonNull String var2, @NonNull Route.Handler var3);

    @NonNull
    public Match match(@NonNull Context var1);

    public boolean match(@NonNull String var1, @NonNull String var2);

    @NonNull
    public Router errorCode(@NonNull Class<? extends Throwable> var1, @NonNull StatusCode var2);

    @NonNull
    public StatusCode errorCode(@NonNull Throwable var1);

    @NonNull
    default public Router error(@NonNull StatusCode statusCode, @NonNull ErrorHandler handler) {
        return this.error(statusCode::equals, handler);
    }

    @NonNull
    default public Router error(@NonNull Class<? extends Throwable> type, @NonNull ErrorHandler handler) {
        return this.error((ctx, x, statusCode) -> {
            if (type.isInstance(x) || type.isInstance(x.getCause())) {
                handler.apply(ctx, x, statusCode);
            }
        });
    }

    @NonNull
    default public Router error(@NonNull Predicate<StatusCode> predicate, @NonNull ErrorHandler handler) {
        return this.error((ctx, x, statusCode) -> {
            if (predicate.test(statusCode)) {
                handler.apply(ctx, x, statusCode);
            }
        });
    }

    @NonNull
    public Router error(@NonNull ErrorHandler var1);

    @NonNull
    public ErrorHandler getErrorHandler();

    @NonNull
    public Logger getLog();

    @NonNull
    public Set<RouterOption> getRouterOptions();

    @NonNull
    public Router setRouterOptions(RouterOption ... var1);

    @NonNull
    public SessionStore getSessionStore();

    @NonNull
    public Router setSessionStore(@NonNull SessionStore var1);

    @NonNull
    default public Executor executor(@NonNull String name) {
        return this.require(Executor.class, name);
    }

    @NonNull
    public Router executor(@NonNull String var1, @NonNull Executor var2);

    @NonNull
    public Cookie getFlashCookie();

    @NonNull
    public Router setFlashCookie(@NonNull Cookie var1);

    @NonNull
    public Router converter(@NonNull ValueConverter var1);

    @NonNull
    public List<ValueConverter> getConverters();

    @NonNull
    public List<BeanConverter> getBeanConverters();

    @NonNull
    public ServerOptions getServerOptions();

    @NonNull
    public static String leadingSlash(@Nullable String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return "/";
        }
        return path.charAt(0) == '/' ? path : "/" + path;
    }

    @NonNull
    public static String noTrailingSlash(@NonNull String path) {
        StringBuilder buff = new StringBuilder(path);
        for (int i = buff.length() - 1; i > 0 && buff.charAt(i) == '/'; --i) {
            buff.setLength(i);
        }
        if (path.length() != buff.length()) {
            return buff.toString();
        }
        return path;
    }

    @NonNull
    public static String normalizePath(@Nullable String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return "/";
        }
        int len = path.length();
        boolean modified = false;
        int p = 0;
        char[] buff = new char[len + 1];
        if (path.charAt(0) != '/') {
            buff[p++] = 47;
            modified = true;
        }
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (ch != '/') {
                buff[p++] = ch;
                continue;
            }
            if (i == 0 || path.charAt(i - 1) != '/') {
                buff[p++] = ch;
                continue;
            }
            modified = true;
        }
        return modified ? new String(buff, 0, p) : path;
    }

    @NonNull
    public static List<String> pathKeys(@NonNull String pattern) {
        return Router.pathKeys(pattern, (k, v) -> {});
    }

    @NonNull
    public static List<String> pathKeys(@NonNull String pattern, BiConsumer<String, String> consumer) {
        ArrayList<String> result = new ArrayList<String>();
        int start = -1;
        int end = Integer.MAX_VALUE;
        int len = pattern.length();
        int curly = 0;
        for (int i = 0; i < len; ++i) {
            String id;
            char ch = pattern.charAt(i);
            if (ch == '{') {
                if (curly == 0) {
                    start = i + 1;
                    end = Integer.MAX_VALUE;
                }
                ++curly;
                continue;
            }
            if (ch == ':') {
                end = i;
                continue;
            }
            if (ch == '}') {
                if (--curly != 0) continue;
                id = pattern.substring(start, Math.min(i, end));
                String value = end == Integer.MAX_VALUE ? null : pattern.substring(end + 1, i);
                consumer.accept(id, value);
                result.add(id);
                start = -1;
                end = Integer.MAX_VALUE;
                continue;
            }
            if (ch != '*') continue;
            id = i == len - 1 ? "*" : pattern.substring(i + 1);
            result.add(id);
            consumer.accept(id, "\\.*");
            i = len;
        }
        return switch (result.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList((String)result.get(0));
            default -> Collections.unmodifiableList(result);
        };
    }

    @NonNull
    public static List<String> expandOptionalVariables(@NonNull String pattern) {
        if (pattern == null || pattern.isEmpty() || pattern.equals("/")) {
            return Collections.singletonList("/");
        }
        int len = pattern.length();
        AtomicInteger key = new AtomicInteger();
        HashMap<Integer, StringBuilder> paths = new HashMap<Integer, StringBuilder>();
        BiConsumer<Integer, StringBuilder> pathAppender = (index, segment) -> {
            for (int i = index.intValue(); i < index - 1; ++i) {
                ((StringBuilder)paths.get(i)).append((CharSequence)segment);
            }
            paths.computeIfAbsent((Integer)index, current -> {
                StringBuilder previous;
                StringBuilder value = new StringBuilder();
                if (current > 0 && !(previous = (StringBuilder)paths.get(current - 1)).toString().equals("/")) {
                    value.append((CharSequence)previous);
                }
                return value;
            }).append((CharSequence)segment);
        };
        StringBuilder segment2 = new StringBuilder();
        boolean isLastOptional = false;
        int i = 0;
        while (i < len) {
            char ch = pattern.charAt(i);
            if (ch == '/') {
                if (segment2.length() > 0) {
                    pathAppender.accept(key.get(), segment2);
                    segment2.setLength(0);
                }
                segment2.append(ch);
                ++i;
                continue;
            }
            if (ch == '{') {
                segment2.append(ch);
                int curly = 1;
                int j = i + 1;
                while (j < len) {
                    char next = pattern.charAt(j++);
                    segment2.append(next);
                    if (next == '{') {
                        ++curly;
                        continue;
                    }
                    if (next != '}' || --curly != 0) continue;
                    break;
                }
                if (j < len && pattern.charAt(j) == '?') {
                    ++j;
                    isLastOptional = true;
                    if (paths.isEmpty()) {
                        paths.put(0, new StringBuilder("/"));
                    }
                    pathAppender.accept(key.incrementAndGet(), segment2);
                } else {
                    isLastOptional = false;
                    pathAppender.accept(key.get(), segment2);
                }
                segment2.setLength(0);
                i = j;
                continue;
            }
            segment2.append(ch);
            ++i;
        }
        if (paths.isEmpty()) {
            return Collections.singletonList(pattern);
        }
        if (!segment2.isEmpty()) {
            pathAppender.accept(key.get(), segment2);
            if (isLastOptional) {
                paths.put(key.incrementAndGet(), segment2);
            }
        }
        return paths.values().stream().map(StringBuilder::toString).collect(Collectors.toList());
    }

    @NonNull
    public static String reverse(@NonNull String pattern, Object ... values2) {
        HashMap<String, Object> keys2 = new HashMap<String, Object>();
        IntStream.range(0, values2.length).forEach(k -> keys2.put(Integer.toString(k), values2[k]));
        return Router.reverse(pattern, keys2);
    }

    @NonNull
    public static String reverse(@NonNull String pattern, @NonNull Map<String, Object> keys2) {
        StringBuilder path = new StringBuilder();
        int start = 0;
        int end = Integer.MAX_VALUE;
        int len = pattern.length();
        int keyIdx = 0;
        for (int i = 0; i < len; ++i) {
            Object value;
            String id;
            char ch = pattern.charAt(i);
            if (ch == '{') {
                path.append(pattern, start, i);
                start = i + 1;
                end = Integer.MAX_VALUE;
                continue;
            }
            if (ch == ':') {
                end = i;
                continue;
            }
            if (ch == '}') {
                id = pattern.substring(start, Math.min(i, end));
                value = keys2.getOrDefault(id, keys2.get(Integer.toString(keyIdx++)));
                Objects.requireNonNull(value, "Missing key: '" + id + "'");
                path.append(value);
                start = i + 1;
                end = Integer.MAX_VALUE;
                continue;
            }
            if (ch != '*') continue;
            path.append(pattern, start, i);
            id = i == len - 1 ? "*" : pattern.substring(i + 1);
            value = keys2.getOrDefault(id, keys2.get(Integer.toString(keyIdx++)));
            Objects.requireNonNull(value, "Missing key: '" + id + "'");
            path.append(value);
            start = len;
            i = len;
        }
        if (path.isEmpty()) {
            return pattern;
        }
        if (start > 0) {
            path.append(pattern, start, len);
        }
        return path.toString();
    }

    public static interface Match {
        public boolean matches();

        @NonNull
        public Route route();

        public Object execute(@NonNull Context var1, @NonNull Route.Handler var2);

        default public Object execute(@NonNull Context context) {
            return this.execute(context, this.route().getPipeline());
        }

        @NonNull
        public Map<String, String> pathMap();
    }
}

