/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Jooby;
import io.jooby.ServerOptions;
import io.jooby.internal.MutedServer;
import java.io.EOFException;
import java.io.IOException;
import java.net.BindException;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

public interface Server {
    @NonNull
    public Server setOptions(@NonNull ServerOptions var1);

    @NonNull
    public String getName();

    @NonNull
    public ServerOptions getOptions();

    @NonNull
    public Server start(@NonNull Jooby var1);

    @NonNull
    default public List<String> getLoggerOff() {
        return Collections.emptyList();
    }

    @NonNull
    public Server stop();

    public static void addConnectionLost(@NonNull Predicate<Throwable> predicate) {
        Base.connectionLostListeners.add(predicate);
    }

    public static void addAddressInUse(@NonNull Predicate<Throwable> predicate) {
        Base.addressInUseListeners.add(predicate);
    }

    public static boolean connectionLost(@Nullable Throwable cause) {
        for (Predicate<Throwable> connectionLost : Base.connectionLostListeners) {
            if (!connectionLost.test(cause)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAddressInUse(@Nullable Throwable cause) {
        for (Predicate<Throwable> addressInUse : Base.addressInUseListeners) {
            if (!addressInUse.test(cause)) continue;
            return true;
        }
        return false;
    }

    public static abstract class Base
    implements Server {
        private static final Predicate<Throwable> CONNECTION_LOST = cause -> {
            String message;
            if (cause instanceof IOException && (message = cause.getMessage()) != null) {
                String msg = message.toLowerCase();
                return msg.contains("reset by peer") || msg.contains("broken pipe") || msg.contains("forcibly closed") || msg.contains("connection reset");
            }
            return cause instanceof ClosedChannelException || cause instanceof EOFException;
        };
        private static final Predicate<Throwable> ADDRESS_IN_USE = cause -> cause instanceof BindException || Optional.ofNullable(cause).map(Throwable::getMessage).map(String::toLowerCase).filter(msg -> msg.contains("address already in use")).isPresent();
        private static final List<Predicate<Throwable>> connectionLostListeners = new CopyOnWriteArrayList<Predicate<Throwable>>(Collections.singletonList(CONNECTION_LOST));
        private static final List<Predicate<Throwable>> addressInUseListeners = new CopyOnWriteArrayList<Predicate<Throwable>>(Collections.singletonList(ADDRESS_IN_USE));
        private static final boolean useShutdownHook = Boolean.parseBoolean(System.getProperty("jooby.useShutdownHook", "true"));
        private final AtomicBoolean stopping = new AtomicBoolean();

        protected void fireStart(@NonNull List<Jooby> applications, @NonNull Executor defaultWorker) {
            for (Jooby app : applications) {
                app.setDefaultWorker(defaultWorker).start(this);
            }
        }

        protected void fireReady(@NonNull List<Jooby> applications) {
            for (Jooby app : applications) {
                app.ready(this);
            }
        }

        protected void fireStop(@NonNull List<Jooby> applications) {
            if (this.stopping.compareAndSet(false, true) && applications != null) {
                for (Jooby app : applications) {
                    app.stop();
                }
            }
        }

        protected void addShutdownHook() {
            if (useShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(MutedServer.mute(this, new String[0])::stop));
            }
        }
    }
}

