/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.SneakyThrows;
import io.jooby.SslOptions;
import io.jooby.SslProvider;
import io.jooby.internal.SslContextProvider;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLContext;

public class ServerOptions {
    public static final int SERVER_PORT = Integer.parseInt(System.getProperty("server.port", "8080"));
    public static final int SEVER_SECURE_PORT = Integer.parseInt(System.getProperty("server.securePort", "8443"));
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    public static final int _4KB = 4096;
    public static final int _8KB = 8192;
    public static final int _16KB = 16384;
    public static final int _10MB = 0xA00000;
    private static final String LOCAL_HOST = "0.0.0.0";
    private int bufferSize = 16384;
    public static final int IO_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    public static final int WORKER_THREADS = Runtime.getRuntime().availableProcessors() * 8;
    private int port = SERVER_PORT;
    private Integer ioThreads;
    private Integer workerThreads;
    private boolean defaultHeaders = true;
    private String server;
    private int maxRequestSize = 0xA00000;
    private String host = "0.0.0.0";
    private SslOptions ssl;
    private Integer securePort;
    private boolean httpsOnly;
    private Integer compressionLevel;
    private Boolean http2;
    private Boolean expectContinue;

    @NonNull
    public static Optional<ServerOptions> from(@NonNull Config conf) {
        if (conf.hasPath("server")) {
            ServerOptions options = new ServerOptions();
            if (conf.hasPath("server.port")) {
                options.setPort(conf.getInt("server.port"));
            }
            if (conf.hasPath("server.securePort")) {
                options.setSecurePort(conf.getInt("server.securePort"));
            }
            if (conf.hasPath("server.ioThreads")) {
                options.setIoThreads(conf.getInt("server.ioThreads"));
            }
            if (conf.hasPath("server.name")) {
                options.setServer(conf.getString("server.name"));
            }
            if (conf.hasPath("server.bufferSize")) {
                options.setBufferSize(conf.getInt("server.bufferSize"));
            }
            if (conf.hasPath("server.defaultHeaders")) {
                options.setDefaultHeaders(conf.getBoolean("server.defaultHeaders"));
            }
            if (conf.hasPath("server.gzip")) {
                throw new UnsupportedOperationException("server.gzip was removed, use server.compressionLevel instead.");
            }
            if (conf.hasPath("server.compressionLevel")) {
                options.setCompressionLevel(conf.getInt("server.compressionLevel"));
            }
            if (conf.hasPath("server.maxRequestSize")) {
                options.setMaxRequestSize((int)conf.getMemorySize("server.maxRequestSize").toBytes());
            }
            if (conf.hasPath("server.workerThreads")) {
                options.setWorkerThreads(conf.getInt("server.workerThreads"));
            }
            if (conf.hasPath("server.host")) {
                options.setHost(conf.getString("server.host"));
            }
            if (conf.hasPath("server.expectContinue")) {
                options.setExpectContinue(conf.getBoolean("server.expectContinue"));
            }
            SslOptions.from(conf, "server.ssl").ifPresent(options::setSsl);
            if (conf.hasPath("server.httpsOnly")) {
                options.httpsOnly = conf.getBoolean("server.httpsOnly");
            }
            if (conf.hasPath("server.http2")) {
                options.setHttp2(conf.getBoolean("server.http2"));
            }
            return Optional.of(options);
        }
        return Optional.empty();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(Optional.ofNullable(this.server).orElse("server")).append(" {");
        buff.append("port: ").append(this.port);
        if (!"jetty".equals(this.server)) {
            buff.append(", ioThreads: ").append(Optional.ofNullable(this.ioThreads).orElse(IO_THREADS));
        }
        buff.append(", workerThreads: ").append(this.getWorkerThreads());
        buff.append(", bufferSize: ").append(this.bufferSize);
        buff.append(", maxRequestSize: ").append(this.maxRequestSize);
        buff.append(", httpsOnly: ").append(this.httpsOnly);
        if (this.compressionLevel != null) {
            buff.append(", gzip");
        }
        buff.append("}");
        return buff.toString();
    }

    @NonNull
    public ServerOptions setServer(@NonNull String server) {
        this.server = server;
        return this;
    }

    @NonNull
    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    @NonNull
    public ServerOptions setPort(int port) {
        this.port = port == 0 ? ServerOptions.randomPort() : port;
        return this;
    }

    @Nullable
    public Integer getSecurePort() {
        return this.securePort;
    }

    public boolean isSSLEnabled() {
        return this.securePort != null || this.ssl != null;
    }

    @NonNull
    public ServerOptions setSecurePort(@Nullable Integer securePort) {
        this.securePort = securePort == null ? null : Integer.valueOf(securePort == 0 ? ServerOptions.randomPort() : securePort);
        return this;
    }

    public boolean isHttpsOnly() {
        return this.httpsOnly;
    }

    @NonNull
    public ServerOptions setHttpsOnly(boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public int getIoThreads() {
        return this.getIoThreads(IO_THREADS);
    }

    public int getIoThreads(int defaultIoThreads) {
        return this.ioThreads == null ? defaultIoThreads : this.ioThreads;
    }

    @NonNull
    public ServerOptions setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
        return this;
    }

    public int getWorkerThreads() {
        return this.getWorkerThreads(WORKER_THREADS);
    }

    public int getWorkerThreads(int defaultWorkerThreads) {
        return this.workerThreads == null ? defaultWorkerThreads : this.workerThreads;
    }

    @NonNull
    public ServerOptions setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    @Nullable
    public Integer getCompressionLevel() {
        return this.compressionLevel;
    }

    @NonNull
    public ServerOptions setCompressionLevel(@Nullable Integer compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public boolean getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @NonNull
    public ServerOptions setDefaultHeaders(boolean defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @NonNull
    public ServerOptions setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    @NonNull
    public ServerOptions setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host == null || host.trim().length() == 0 || "localhost".equalsIgnoreCase(host.trim()) ? LOCAL_HOST : host;
    }

    @Nullable
    public SslOptions getSsl() {
        return this.ssl;
    }

    @NonNull
    public ServerOptions setSsl(@Nullable SslOptions ssl) {
        this.ssl = ssl;
        return this;
    }

    @Nullable
    public Boolean isHttp2() {
        return this.http2;
    }

    public ServerOptions setHttp2(@Nullable Boolean http2) {
        this.http2 = http2;
        return this;
    }

    @Nullable
    public Boolean isExpectContinue() {
        return this.expectContinue;
    }

    public ServerOptions setExpectContinue(@Nullable Boolean expectContinue) {
        this.expectContinue = expectContinue;
        return this;
    }

    @Nullable
    public SSLContext getSSLContext(@NonNull ClassLoader loader) {
        if (this.isSSLEnabled()) {
            SSLContext sslContext;
            this.setSecurePort(Optional.ofNullable(this.securePort).orElse(SEVER_SECURE_PORT));
            SslOptions options = Optional.ofNullable(this.ssl).orElseGet(SslOptions::selfSigned);
            this.setSsl(options);
            if (options.getSslContext() == null) {
                SslContextProvider sslContextProvider = Stream.of(SslContextProvider.providers()).filter(it -> it.supports(options.getType())).findFirst().orElseThrow(() -> new UnsupportedOperationException("SSL Type: " + options.getType()));
                String providerName = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(SslProvider.class).iterator(), 16), false).findFirst().map(provider -> {
                    String name = provider.getName();
                    if (Security.getProvider(name) == null) {
                        Security.addProvider(provider.create());
                    }
                    return name;
                }).orElse(null);
                sslContext = sslContextProvider.create(loader, providerName, options);
            } else {
                sslContext = options.getSslContext();
            }
            LinkedHashSet<String> supportedProtocols = new LinkedHashSet<String>(Arrays.asList(sslContext.getDefaultSSLParameters().getProtocols()));
            LinkedHashSet<String> protocols = new LinkedHashSet<String>(options.getProtocol());
            protocols.retainAll(supportedProtocols);
            if (protocols.isEmpty()) {
                throw new IllegalArgumentException("Unsupported protocol: " + String.valueOf(options.getProtocol()));
            }
            this.ssl.setProtocol(new ArrayList<String>(protocols));
            return sslContext;
        }
        return null;
    }

    private static int randomPort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            socket.setReuseAddress(true);
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException x) {
                throw SneakyThrows.propagate(x);
            }
        }
        socket.close();
        return n;
    }
}

