/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Registry;
import io.jooby.ServiceKey;
import io.jooby.exception.RegistryException;
import jakarta.inject.Provider;
import java.util.Map;
import java.util.Set;

public interface ServiceRegistry
extends Registry {
    @NonNull
    public Set<ServiceKey<?>> keySet();

    @NonNull
    public Set<Map.Entry<ServiceKey<?>, Provider<?>>> entrySet();

    @NonNull
    default public <T> T get(@NonNull ServiceKey<T> key) {
        T service = this.getOrNull(key);
        if (service == null) {
            throw new RegistryException("Service not found: " + String.valueOf(key));
        }
        return service;
    }

    @NonNull
    default public <T> T get(@NonNull Class<T> type) {
        return this.get(ServiceKey.key(type));
    }

    @Nullable
    public <T> T getOrNull(@NonNull ServiceKey<T> var1);

    @Nullable
    default public <T> T getOrNull(@NonNull Class<T> type) {
        return this.getOrNull(ServiceKey.key(type));
    }

    @Nullable
    default public <T> T put(@NonNull Class<T> type, Provider<T> service) {
        return (T)this.put(ServiceKey.key(type), (T)service);
    }

    @Nullable
    public <T> T put(@NonNull ServiceKey<T> var1, Provider<T> var2);

    @Nullable
    default public <T> T put(@NonNull Class<T> type, T service) {
        return this.put(ServiceKey.key(type), service);
    }

    @Nullable
    public <T> T put(@NonNull ServiceKey<T> var1, T var2);

    @Nullable
    public <T> T putIfAbsent(@NonNull ServiceKey<T> var1, T var2);

    @Nullable
    default public <T> T putIfAbsent(@NonNull Class<T> type, T service) {
        return this.putIfAbsent(ServiceKey.key(type), service);
    }

    @Nullable
    public <T> T putIfAbsent(@NonNull ServiceKey<T> var1, Provider<T> var2);

    @Nullable
    default public <T> T putIfAbsent(@NonNull Class<T> type, Provider<T> service) {
        return this.putIfAbsent(ServiceKey.key(type), service);
    }

    @Override
    @NonNull
    default public <T> T require(@NonNull Class<T> type) {
        return this.get(ServiceKey.key(type));
    }

    @Override
    @NonNull
    default public <T> T require(@NonNull Class<T> type, @NonNull String name) {
        return this.get(ServiceKey.key(type, name));
    }

    @Override
    @NonNull
    default public <T> T require(@NonNull ServiceKey<T> key) throws RegistryException {
        return this.get(key);
    }
}

