/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.internal.MultipleSessionToken;
import java.security.SecureRandom;
import java.util.Base64;

public interface SessionToken {
    public static final Cookie SID = new Cookie("jooby.sid").setMaxAge(-1L).setHttpOnly(true).setPath("/");
    public static final SecureRandom RND = new SecureRandom();
    public static final int ID_SIZE = 30;

    @NonNull
    default public String newToken() {
        byte[] bytes = new byte[30];
        RND.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    @Nullable
    public String findToken(@NonNull Context var1);

    public void saveToken(@NonNull Context var1, @NonNull String var2);

    public void deleteToken(@NonNull Context var1, @NonNull String var2);

    @NonNull
    public static SessionToken cookieId(@NonNull Cookie cookie) {
        return new CookieID(cookie);
    }

    @NonNull
    public static SessionToken signedCookie(@NonNull Cookie cookie) {
        return new SignedCookie(cookie);
    }

    @NonNull
    public static SessionToken header(@NonNull String name) {
        return new HeaderID(name);
    }

    @NonNull
    public static SessionToken combine(SessionToken ... tokens) {
        return new MultipleSessionToken(tokens);
    }

    public static class CookieID
    implements SessionToken {
        private final Cookie cookie;

        public CookieID(@NonNull Cookie cookie) {
            this.cookie = cookie;
        }

        @Override
        @Nullable
        public String findToken(@NonNull Context ctx) {
            return ctx.cookieMap().get(this.cookie.getName());
        }

        @Override
        public void saveToken(@NonNull Context ctx, @NonNull String token) {
            ctx.setResponseCookie(this.cookie.clone().setValue(token));
        }

        @Override
        public void deleteToken(@NonNull Context ctx, @NonNull String token) {
            ctx.setResponseCookie(this.cookie.clone().setValue(token).setMaxAge(0L));
        }
    }

    public static class SignedCookie
    implements SessionToken {
        private final Cookie cookie;

        public SignedCookie(@NonNull Cookie cookie) {
            this.cookie = cookie;
        }

        @Override
        @Nullable
        public String findToken(@NonNull Context ctx) {
            return ctx.cookieMap().get(this.cookie.getName());
        }

        @Override
        public void saveToken(@NonNull Context ctx, @NonNull String token) {
            ctx.setResponseCookie(this.cookie.clone().setValue(token));
        }

        @Override
        public void deleteToken(@NonNull Context ctx, @NonNull String token) {
            ctx.setResponseCookie(this.cookie.clone().setMaxAge(0L));
        }
    }

    public static class HeaderID
    implements SessionToken {
        private final String name;

        public HeaderID(@NonNull String name) {
            this.name = name;
        }

        @Override
        @Nullable
        public String findToken(@NonNull Context ctx) {
            return ctx.headerMap().get(this.name);
        }

        @Override
        public void saveToken(@NonNull Context ctx, @NonNull String token) {
            ctx.setResponseHeader(this.name, token);
        }

        @Override
        public void deleteToken(@NonNull Context ctx, @NonNull String token) {
            ctx.removeResponseHeader(this.name);
        }
    }
}

