/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.exception.ProvisioningException;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Usage
extends RuntimeException {
    public Usage(@NonNull String message, @NonNull String id) {
        super(message + "\nFor more details, please visit: " + System.getProperty("jooby.host", "https://jooby.io") + "/usage#" + id);
    }

    @NonNull
    public static Usage mvcRouterNotFound(@NonNull Class mvcRoute) {
        return Usage.apt("Router not found: `" + mvcRoute.getName() + "`. Make sure Jooby annotation processor is configured properly.", "router-not-found");
    }

    @NonNull
    public static Usage parameterNameNotPresent(@NonNull Parameter parameter) {
        Executable executable = parameter.getDeclaringExecutable();
        int p = Stream.of(executable.getParameters()).collect(Collectors.toList()).indexOf(parameter);
        String message = "Unable to provision parameter at position: '" + p + "', require by: " + ProvisioningException.toString(parameter.getDeclaringExecutable()) + ". Parameter's name is missing";
        return new Usage(message, "bean-converter-parameter-name-missing");
    }

    private static Usage apt(String message, String id) {
        return new Usage(message, "annotation-processing-tool-" + id);
    }
}

