/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.SneakyThrows;
import io.jooby.WebSocketCloseStatus;
import io.jooby.WebSocketConfigurer;
import io.jooby.WebSocketMessage;
import io.jooby.buffer.DataBuffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public interface WebSocket {
    public static final int MAX_BUFFER_SIZE = 131072;

    @NonNull
    public Context getContext();

    @NonNull
    default public Map<String, Object> getAttributes() {
        return this.getContext().getAttributes();
    }

    @NonNull
    default public <T> T attribute(@NonNull String key) {
        return this.getContext().getAttribute(key);
    }

    @NonNull
    default public WebSocket attribute(@NonNull String key, Object value) {
        this.getContext().setAttribute(key, value);
        return this;
    }

    @NonNull
    public List<WebSocket> getSessions();

    public boolean isOpen();

    public void forEach(SneakyThrows.Consumer<WebSocket> var1);

    @NonNull
    default public WebSocket send(@NonNull String message) {
        return this.send(message, WriteCallback.NOOP);
    }

    @NonNull
    public WebSocket send(@NonNull String var1, @NonNull WriteCallback var2);

    @NonNull
    default public WebSocket send(@NonNull byte[] message) {
        return this.send(message, WriteCallback.NOOP);
    }

    @NonNull
    default public WebSocket send(@NonNull byte[] message, @NonNull WriteCallback callback) {
        return this.send(ByteBuffer.wrap(message), callback);
    }

    @NonNull
    default public WebSocket send(@NonNull ByteBuffer message) {
        return this.send(message, WriteCallback.NOOP);
    }

    @NonNull
    public WebSocket send(@NonNull ByteBuffer var1, @NonNull WriteCallback var2);

    @NonNull
    default public WebSocket send(@NonNull DataBuffer message) {
        return this.send(message, WriteCallback.NOOP);
    }

    @NonNull
    public WebSocket send(@NonNull DataBuffer var1, @NonNull WriteCallback var2);

    @NonNull
    default public WebSocket sendBinary(@NonNull String message) {
        return this.sendBinary(message, WriteCallback.NOOP);
    }

    @NonNull
    public WebSocket sendBinary(@NonNull String var1, @NonNull WriteCallback var2);

    @NonNull
    default public WebSocket sendBinary(@NonNull byte[] message) {
        return this.sendBinary(message, WriteCallback.NOOP);
    }

    @NonNull
    default public WebSocket sendBinary(@NonNull byte[] message, @NonNull WriteCallback callback) {
        return this.sendBinary(ByteBuffer.wrap(message), callback);
    }

    @NonNull
    default public WebSocket sendBinary(@NonNull ByteBuffer message) {
        return this.sendBinary(message, WriteCallback.NOOP);
    }

    @NonNull
    public WebSocket sendBinary(@NonNull ByteBuffer var1, @NonNull WriteCallback var2);

    @NonNull
    default public WebSocket sendBinary(@NonNull DataBuffer message) {
        return this.sendBinary(message, WriteCallback.NOOP);
    }

    @NonNull
    public WebSocket sendBinary(@NonNull DataBuffer var1, @NonNull WriteCallback var2);

    @NonNull
    default public WebSocket render(@NonNull Object value) {
        return this.render(value, WriteCallback.NOOP);
    }

    @NonNull
    public WebSocket render(@NonNull Object var1, @NonNull WriteCallback var2);

    @NonNull
    default public WebSocket renderBinary(@NonNull Object value) {
        return this.renderBinary(value, WriteCallback.NOOP);
    }

    @NonNull
    public WebSocket renderBinary(@NonNull Object var1, @NonNull WriteCallback var2);

    @NonNull
    default public WebSocket close() {
        return this.close(WebSocketCloseStatus.NORMAL);
    }

    @NonNull
    public WebSocket close(@NonNull WebSocketCloseStatus var1);

    public static interface WriteCallback {
        public static final WriteCallback NOOP = (ws, cause) -> {};

        public void operationComplete(@NonNull WebSocket var1, @Nullable Throwable var2);
    }

    public static interface OnError {
        public void onError(@NonNull WebSocket var1, @NonNull Throwable var2);
    }

    public static interface OnClose {
        public void onClose(@NonNull WebSocket var1, @NonNull WebSocketCloseStatus var2);
    }

    public static interface OnMessage {
        public void onMessage(@NonNull WebSocket var1, @NonNull WebSocketMessage var2);
    }

    public static interface OnConnect {
        public void onConnect(@NonNull WebSocket var1);
    }

    public static interface Initializer {
        public void init(@NonNull Context var1, @NonNull WebSocketConfigurer var2);
    }
}

