/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.buffer;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.buffer.Assert;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.buffer.DataBufferInputStream;
import io.jooby.buffer.DataBufferOutputStream;
import io.jooby.buffer.DataBufferWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.function.IntPredicate;

public interface DataBuffer {
    public DataBufferFactory factory();

    public int indexOf(IntPredicate var1, int var2);

    public int lastIndexOf(IntPredicate var1, int var2);

    public int readableByteCount();

    public int writableByteCount();

    public int capacity();

    public DataBuffer duplicate();

    public DataBuffer ensureWritable(int var1);

    public int readPosition();

    public DataBuffer readPosition(int var1);

    public int writePosition();

    public DataBuffer writePosition(int var1);

    public byte getByte(int var1);

    public byte read();

    public DataBuffer read(byte[] var1);

    public DataBuffer read(byte[] var1, int var2, int var3);

    public DataBuffer write(byte var1);

    public DataBuffer write(byte[] var1);

    public DataBuffer write(byte[] var1, int var2, int var3);

    public DataBuffer write(DataBuffer ... var1);

    public DataBuffer write(ByteBuffer ... var1);

    default public DataBuffer write(CharSequence charSequence, Charset charset) {
        Assert.notNull(charSequence, "CharSequence must not be null");
        Assert.notNull(charset, "Charset must not be null");
        if (!charSequence.isEmpty()) {
            this.write(CharBuffer.wrap(charSequence), charset);
        }
        return this;
    }

    default public DataBuffer write(CharBuffer src, Charset charset) {
        CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int averageSize = (int)Math.ceil((float)src.remaining() * encoder.averageBytesPerChar());
        this.ensureWritable(averageSize);
        while (true) {
            CoderResult cr;
            if (src.hasRemaining()) {
                try (ByteBufferIterator iterator2 = this.writableByteBuffers();){
                    Assert.state(iterator2.hasNext(), "No ByteBuffer available");
                    ByteBuffer dest = (ByteBuffer)iterator2.next();
                    cr = encoder.encode(src, dest, true);
                    if (cr.isUnderflow()) {
                        cr = encoder.flush(dest);
                    }
                    this.writePosition(this.writePosition() + dest.position());
                }
            } else {
                cr = CoderResult.UNDERFLOW;
            }
            if (cr.isUnderflow()) break;
            if (!cr.isOverflow()) continue;
            int maxSize = (int)Math.ceil((float)src.remaining() * encoder.maxBytesPerChar());
            this.ensureWritable(maxSize);
        }
        return this;
    }

    public DataBuffer split(int var1);

    default public void toByteBuffer(ByteBuffer dest) {
        this.toByteBuffer(this.readPosition(), dest, dest.position(), this.readableByteCount());
    }

    public void toByteBuffer(int var1, ByteBuffer var2, int var3, int var4);

    public ByteBufferIterator readableByteBuffers();

    public ByteBufferIterator writableByteBuffers();

    default public InputStream asInputStream() {
        return new DataBufferInputStream(this, false);
    }

    default public InputStream asInputStream(boolean releaseOnClose) {
        return new DataBufferInputStream(this, releaseOnClose);
    }

    default public OutputStream asOutputStream() {
        return new DataBufferOutputStream(this);
    }

    default public Writer asWriter() {
        return this.asWriter(StandardCharsets.UTF_8);
    }

    default public Writer asWriter(@NonNull Charset charset) {
        return new DataBufferWriter(this, charset);
    }

    default public String toString(Charset charset) {
        Assert.notNull(charset, "Charset must not be null");
        return this.toString(this.readPosition(), this.readableByteCount(), charset);
    }

    public String toString(int var1, int var2, Charset var3);

    public DataBuffer clear();

    public Context send(Context var1);

    public static interface ByteBufferIterator
    extends Iterator<ByteBuffer>,
    Closeable {
        @Override
        public void close();
    }
}

