/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Route;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogHandler
implements Route.Filter {
    private static final String USER_AGENT = "User-Agent";
    private static final String REFERER = "Referer";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withZone(ZoneId.systemDefault());
    private static final String DASH = "-";
    private static final char SP = ' ';
    private static final char BL = '[';
    private static final char BR = ']';
    private static final char Q = '\"';
    private static final Function<Context, String> USER_OR_DASH = ctx -> Optional.ofNullable(ctx.getUser()).map(Object::toString).orElse(DASH);
    private static final int MESSAGE_SIZE = 256;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Function<Context, String> userId;
    private Consumer<String> logRecord = this.log::info;
    private Function<Long, String> df;
    private List<String> requestHeaders = Collections.emptyList();
    private List<String> responseHeaders = Collections.emptyList();

    public AccessLogHandler(@NonNull Function<Context, String> userId) {
        this.userId = Objects.requireNonNull(userId, "User ID provider required.");
        this.dateFormatter(FORMATTER);
    }

    public AccessLogHandler() {
        this(USER_OR_DASH);
    }

    @Override
    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        long timestamp = System.currentTimeMillis();
        return ctx -> {
            String remoteAddr = ctx.getRemoteAddress();
            ctx.onComplete(context -> {
                StringBuilder sb = new StringBuilder(256);
                sb.append(remoteAddr);
                sb.append(' ').append(DASH).append(' ');
                sb.append(this.userId.apply(ctx));
                sb.append(' ');
                sb.append('[').append(this.df.apply(timestamp)).append(']');
                sb.append(' ');
                sb.append('\"').append(ctx.getMethod());
                sb.append(' ');
                sb.append(ctx.getRequestPath());
                sb.append(ctx.queryString());
                sb.append(' ');
                sb.append(ctx.getProtocol());
                sb.append('\"').append(' ');
                sb.append(ctx.getResponseCode().value());
                sb.append(' ');
                long responseLength = ctx.getResponseLength();
                sb.append(responseLength >= 0L ? Long.valueOf(responseLength) : DASH);
                long now = System.currentTimeMillis();
                sb.append(' ');
                sb.append(now - timestamp);
                this.appendHeaders(sb, this.requestHeaders, h -> ctx.header((String)h).valueOrNull());
                this.appendHeaders(sb, this.responseHeaders, h -> ctx.getResponseHeader((String)h));
                this.logRecord.accept(sb.toString());
            });
            return next.apply(ctx);
        };
    }

    private void appendHeaders(StringBuilder buff, List<String> requestHeaders, Function<String, String> headers) {
        for (String header : requestHeaders) {
            String value = headers.apply(header);
            if (value == null) {
                buff.append(' ').append('\"').append(DASH).append('\"');
                continue;
            }
            buff.append(' ').append('\"').append(value).append('\"');
        }
    }

    @NonNull
    public AccessLogHandler log(@NonNull Consumer<String> log) {
        this.logRecord = Objects.requireNonNull(log, "Consumer is required.");
        return this;
    }

    @NonNull
    public AccessLogHandler dateFormatter(@NonNull DateTimeFormatter formatter) {
        return this.dateFormatter((Long ts) -> formatter.format(Instant.ofEpochMilli(ts)));
    }

    @NonNull
    public AccessLogHandler dateFormatter(Function<Long, String> formatter) {
        Objects.requireNonNull(formatter, "Formatter required.");
        this.df = formatter;
        return this;
    }

    @NonNull
    public AccessLogHandler dateFormatter(@NonNull ZoneId zoneId) {
        return this.dateFormatter(FORMATTER.withZone(zoneId));
    }

    @NonNull
    public AccessLogHandler extended() {
        return this.requestHeader(USER_AGENT, REFERER);
    }

    @NonNull
    public AccessLogHandler requestHeader(String ... names) {
        this.requestHeaders = Arrays.asList(names);
        return this;
    }

    @NonNull
    public AccessLogHandler responseHeader(String ... names) {
        this.responseHeaders = Arrays.asList(names);
        return this;
    }
}

