/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.handler;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Cors {
    private static final int _30 = 30;
    private Matcher<String> origin;
    private boolean credentials;
    private Matcher<String> methods;
    private Matcher<List<String>> headers;
    private Duration maxAge;
    private List<String> exposedHeaders = Collections.emptyList();

    public Cors() {
        this.setOrigin("*");
        this.setUseCredentials(true);
        this.setMethods("GET", "POST");
        this.setHeaders("X-Requested-With", "Content-Type", "Accept", "Origin");
        this.setMaxAge(Duration.ofMinutes(30L));
    }

    public boolean getUseCredentials() {
        return this.credentials;
    }

    public Cors setUseCredentials(boolean credentials) {
        this.credentials = credentials;
        return this;
    }

    public boolean anyOrigin() {
        return this.origin.wild;
    }

    public List<String> getOrigin() {
        return this.origin.values;
    }

    public boolean allowOrigin(String origin) {
        return this.origin.test(origin);
    }

    public Cors setOrigin(String ... origin) {
        return this.setOrigin(Arrays.asList(origin));
    }

    public Cors setOrigin(List<String> origin) {
        this.origin = Cors.firstMatch(Objects.requireNonNull(origin, "Origins are required."));
        return this;
    }

    public boolean allowMethod(String method) {
        return this.methods.test(method);
    }

    public List<String> getMethods() {
        return this.methods.values;
    }

    public Cors setMethods(String ... methods2) {
        return this.setMethods(Arrays.asList(methods2));
    }

    public Cors setMethods(List<String> methods2) {
        this.methods = Cors.firstMatch(methods2);
        return this;
    }

    public boolean anyHeader() {
        return this.headers.wild;
    }

    public boolean allowHeader(String ... headers) {
        return this.allowHeaders(Arrays.asList(headers));
    }

    public boolean allowHeaders(List<String> headers) {
        return this.headers.test(headers);
    }

    public List<String> getHeaders() {
        return this.headers.values;
    }

    public Cors setHeaders(String ... headers) {
        return this.setHeaders(Arrays.asList(headers));
    }

    public Cors setHeaders(List<String> headers) {
        this.headers = Cors.allMatch(headers);
        return this;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public Cors setExposedHeaders(String ... exposedHeaders) {
        return this.setExposedHeaders(Arrays.asList(exposedHeaders));
    }

    public Cors setExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = Objects.requireNonNull(exposedHeaders, "Exposed headers are required.");
        return this;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public Cors setMaxAge(Duration preflightMaxAge) {
        this.maxAge = preflightMaxAge;
        return this;
    }

    @NonNull
    public static Cors from(@NonNull Config conf) {
        Config cors = conf.hasPath("cors") ? conf.getConfig("cors") : conf;
        Cors options = new Cors();
        if (cors.hasPath("origin")) {
            options.setOrigin(Cors.list(cors.getAnyRef("origin")));
        }
        if (cors.hasPath("credentials")) {
            options.setUseCredentials(cors.getBoolean("credentials"));
        }
        if (cors.hasPath("methods")) {
            options.setMethods(Cors.list(cors.getAnyRef("methods")));
        }
        if (cors.hasPath("headers")) {
            options.setHeaders(Cors.list(cors.getAnyRef("headers")));
        }
        if (cors.hasPath("maxAge")) {
            options.setMaxAge(Duration.ofSeconds(cors.getDuration("maxAge", TimeUnit.SECONDS)));
        }
        if (cors.hasPath("exposedHeaders")) {
            options.setExposedHeaders(Cors.list(cors.getAnyRef("exposedHeaders")));
        }
        return options;
    }

    private static List<String> list(Object value) {
        return value instanceof List ? (List<String>)value : Collections.singletonList(value.toString());
    }

    private static Matcher<List<String>> allMatch(List<String> values2) {
        Matcher<String> predicate = Cors.firstMatch(values2);
        Predicate<List> allmatch = it -> it.stream().allMatch(predicate);
        return new Matcher<List<String>>(values2, allmatch);
    }

    private static Matcher<String> firstMatch(List<String> values2) {
        List patterns = values2.stream().map(Cors::rewrite).collect(Collectors.toList());
        Predicate<String> predicate = it -> patterns.stream().filter(pattern -> pattern.matcher((CharSequence)it).matches()).findFirst().isPresent();
        return new Matcher<String>(values2, predicate);
    }

    private static Pattern rewrite(String origin) {
        return Pattern.compile(origin.replace(".", "\\.").replace("*", ".*"), 2);
    }

    private static class Matcher<T>
    implements Predicate<T> {
        private List<String> values;
        private Predicate<T> predicate;
        private boolean wild;

        Matcher(List<String> values2, Predicate<T> predicate) {
            this.values = values2;
            this.predicate = predicate;
            this.wild = values2.contains("*");
        }

        @Override
        public boolean test(T value) {
            return this.predicate.test(value);
        }

        public String toString() {
            return this.values.toString();
        }
    }
}

