/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.ValueNode;
import io.jooby.exception.MissingValueException;
import io.jooby.exception.TypeMismatchException;
import io.jooby.internal.MissingValue;
import io.jooby.internal.SingleValue;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ArrayValue
implements ValueNode {
    private final Context ctx;
    private final String name;
    private final List<ValueNode> list = new ArrayList<ValueNode>(5);

    public ArrayValue(Context ctx, String name) {
        this.ctx = ctx;
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    public ArrayValue add(ValueNode value) {
        this.list.add(value);
        return this;
    }

    public ArrayValue add(List<String> values2) {
        for (String value : values2) {
            this.add(value);
        }
        return this;
    }

    public ArrayValue add(String value) {
        return this.add(new SingleValue(this.ctx, this.name, value));
    }

    @Override
    @NonNull
    public ValueNode get(int index) {
        try {
            return this.list.get(index);
        }
        catch (IndexOutOfBoundsException x) {
            return new MissingValue(this.name + "[" + index + "]");
        }
    }

    @Override
    @NonNull
    public ValueNode get(@NonNull String name) {
        return new MissingValue(this.name + "." + name);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    @NonNull
    public String value() {
        String name = this.name();
        throw new TypeMismatchException(name == null ? this.getClass().getSimpleName() : name, (Type)((Object)String.class));
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    @NonNull
    public Iterator<ValueNode> iterator() {
        return this.list.iterator();
    }

    @Override
    @NonNull
    public <T> T to(@NonNull Class<T> type) {
        return this.ctx.convert(this.list.get(0), type);
    }

    @Override
    @Nullable
    public <T> T toNullable(@NonNull Class<T> type) {
        return this.list.isEmpty() ? null : (T)this.ctx.convertOrNull(this.list.get(0), type);
    }

    @Override
    @NonNull
    public <T> List<T> toList(@NonNull Class<T> type) {
        return this.collect(new ArrayList(this.list.size()), type);
    }

    @Override
    @NonNull
    public <T> Optional<T> toOptional(@NonNull Class<T> type) {
        try {
            return Optional.ofNullable(this.to(type));
        }
        catch (MissingValueException x) {
            return Optional.empty();
        }
    }

    @Override
    @NonNull
    public <T> Set<T> toSet(@NonNull Class<T> type) {
        return this.collect(new LinkedHashSet(this.list.size()), type);
    }

    @Override
    @NonNull
    public Map<String, List<String>> toMultimap() {
        ArrayList values2 = new ArrayList();
        this.list.forEach(it -> it.toMultimap().values().forEach(values2::addAll));
        return Map.of(this.name, values2);
    }

    @Override
    @NonNull
    public List<String> toList() {
        return this.collect(new ArrayList(), String.class);
    }

    @Override
    @NonNull
    public Set<String> toSet() {
        return this.collect(new LinkedHashSet(), String.class);
    }

    private <T, C extends Collection<T>> C collect(C collection, Class<T> type) {
        for (ValueNode node : this.list) {
            collection.add(node.to(type));
        }
        return collection;
    }
}

