/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.handler.Asset;
import io.jooby.handler.AssetSource;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FolderDiskAssetSource
implements AssetSource {
    private Path location;

    public FolderDiskAssetSource(@NonNull Path location) {
        this.location = location.normalize().toAbsolutePath();
    }

    @Override
    @Nullable
    public Asset resolve(@NonNull String path) {
        Path resource = this.location.resolve(path).normalize().toAbsolutePath();
        if (resource.startsWith(this.location)) {
            Path index;
            if (Files.isRegularFile(resource, new LinkOption[0])) {
                return Asset.create(resource);
            }
            if (Files.isDirectory(resource, new LinkOption[0]) && Files.isRegularFile(index = resource.resolve("index.html"), new LinkOption[0])) {
                return Asset.create(index);
            }
        }
        return null;
    }

    public String toString() {
        return this.location.toString();
    }
}

