/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.FileDownload;
import io.jooby.ForwardingContext;
import io.jooby.MediaType;
import io.jooby.MessageEncoder;
import io.jooby.Route;
import io.jooby.Sender;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.buffer.DataBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class HeadContext
extends ForwardingContext {
    public HeadContext(@NonNull Context context) {
        super(context);
    }

    @Override
    @NonNull
    public Context send(@NonNull Path file) {
        try {
            this.ctx.setResponseLength(Files.size(file));
            this.checkSizeHeaders();
            this.ctx.setResponseType(MediaType.byFile(file));
            this.ctx.send(StatusCode.OK);
            return this;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    public Context send(@NonNull byte[] data) {
        this.ctx.setResponseLength(data.length);
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull String data) {
        return this.send(data, StandardCharsets.UTF_8);
    }

    @Override
    @NonNull
    public Context send(@NonNull ByteBuffer data) {
        this.ctx.setResponseLength(data.remaining());
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull DataBuffer data) {
        this.ctx.setResponseLength(data.readableByteCount());
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull FileChannel file) {
        try {
            this.ctx.setResponseLength(file.size());
            this.checkSizeHeaders();
            this.ctx.send(StatusCode.OK);
            return this;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    public Context send(@NonNull FileDownload file) {
        this.ctx.setResponseLength(file.getFileSize());
        this.ctx.setResponseType(file.getContentType());
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull InputStream input) {
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull StatusCode statusCode) {
        this.ctx.send(statusCode);
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull ReadableByteChannel channel) {
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return this;
    }

    @Override
    @NonNull
    public Context send(@NonNull String data, @NonNull Charset charset) {
        this.ctx.setResponseLength(data.getBytes(charset).length);
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return this;
    }

    @Override
    @NonNull
    public Context render(@NonNull Object value) {
        try {
            Route route = this.getRoute();
            MessageEncoder encoder = route.getEncoder();
            DataBuffer bytes = encoder.encode(this, value);
            if (bytes == null) {
                if (!this.isResponseStarted()) {
                    throw new IllegalStateException("The response was not encoded");
                }
            } else {
                this.send(bytes);
            }
            return this;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate(x);
        }
    }

    @Override
    @NonNull
    public Sender responseSender() {
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return new NoopSender();
    }

    @Override
    @NonNull
    public OutputStream responseStream() {
        this.checkSizeHeaders();
        this.ctx.send(StatusCode.OK);
        return new NoopOutputStream();
    }

    @Override
    @NonNull
    public PrintWriter responseWriter() {
        return new PrintWriter(this.responseStream());
    }

    private void checkSizeHeaders() {
        if (this.ctx.getResponseLength() < 0L) {
            this.ctx.setResponseHeader("Transfer-Encoding", "chunked");
        } else {
            this.ctx.removeResponseHeader("Transfer-Encoding");
        }
    }

    private static class NoopSender
    implements Sender {
        private NoopSender() {
        }

        @Override
        @NonNull
        public Sender write(@NonNull byte[] data, @NonNull Sender.Callback callback) {
            return this;
        }

        @Override
        @NonNull
        public Sender write(@NonNull DataBuffer data, @NonNull Sender.Callback callback) {
            return this;
        }

        @Override
        public void close() {
        }
    }

    private static class NoopOutputStream
    extends OutputStream {
        private NoopOutputStream() {
        }

        @Override
        public void write(@NonNull byte[] b) throws IOException {
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

